/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import java.util.LinkedList;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class LempelZivCoder
extends Transformer {
    private LinkedList _codeBook;
    private String _current;
    private int _previousIndex = 0;

    public LempelZivCoder(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.BOOLEAN);
        this.output.setTypeEquals(BaseType.INT);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            boolean inputValue = ((BooleanToken)this.input.get(0)).booleanValue();
            this._current = this._current + (inputValue ? "1" : "0");
            int index = this._codeBook.indexOf(this._current);
            if (index == -1) {
                this.output.send(0, new IntToken(this._previousIndex));
                this.output.send(0, new IntToken(inputValue ? 1 : 0));
                this._codeBook.add(this._current);
                this._current = "";
                this._previousIndex = 0;
            } else {
                this._previousIndex = index;
            }
        }
    }

    @Override
    public void initialize() {
        this._codeBook = new LinkedList();
        this._codeBook.add("");
        this._current = "";
        this._previousIndex = 0;
    }
}

