/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.lib.conversions.Converter;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class BooleanToAnything
extends Converter {
    public Parameter falseValue = new Parameter((NamedObj)this, "falseValue", new IntToken(0));
    public Parameter trueValue = new Parameter((NamedObj)this, "trueValue", new IntToken(1));

    public BooleanToAnything(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.BOOLEAN);
        this.output.setTypeAtLeast(this.trueValue);
        this.output.setTypeAtLeast(this.falseValue);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        BooleanToAnything newObject = (BooleanToAnything)super.clone(workspace);
        newObject.output.setTypeAtLeast(newObject.trueValue);
        newObject.output.setTypeAtLeast(newObject.falseValue);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        BooleanToken inputToken = (BooleanToken)this.input.get(0);
        if (inputToken.booleanValue()) {
            this.output.send(0, this.trueValue.getToken());
        } else {
            this.output.send(0, this.falseValue.getToken());
        }
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (!this.input.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

