/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ComplexToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.math.Complex;

public class CartesianToComplex
extends TypedAtomicActor {
    public TypedIOPort x = new TypedIOPort(this, "x", true, false);
    public TypedIOPort y;
    public TypedIOPort output;

    public CartesianToComplex(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.x.setTypeEquals(BaseType.DOUBLE);
        this.y = new TypedIOPort(this, "y", true, false);
        this.y.setTypeEquals(BaseType.DOUBLE);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(BaseType.COMPLEX);
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        double xValue = ((DoubleToken)this.x.get(0)).doubleValue();
        double yValue = ((DoubleToken)this.y.get(0)).doubleValue();
        ComplexToken token = new ComplexToken(new Complex(xValue, yValue));
        this.output.send(0, token);
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (!this.x.hasToken(0) || !this.y.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

