/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.StringAttribute;

public class Round
extends Transformer {
    public StringAttribute function;
    private IntToken[] _resultArray = new IntToken[0];
    private int _function;
    private static final int _CEIL = 0;
    private static final int _FLOOR = 1;
    private static final int _ROUND = 2;
    private static final int _TRUNCATE = 3;

    public Round(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.function = new StringAttribute(this, "function");
        this.function.setExpression("round");
        this._function = 2;
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.output.setTypeEquals(BaseType.INT);
        this._attachText("_iconDescription", "<svg>\n<circle cx=\"0\" cy=\"0\" r=\"17\"style=\"fill:white\"/>\n</svg>\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.function) {
            String functionName = this.function.getExpression();
            if (functionName.equals("ceil")) {
                this._function = 0;
                return;
            } else if (functionName.equals("floor")) {
                this._function = 1;
                return;
            } else if (functionName.equals("round")) {
                this._function = 2;
                return;
            } else {
                if (!functionName.equals("truncate")) throw new IllegalActionException((Nameable)this, "Unrecognized rounding function: " + functionName);
                this._function = 3;
            }
            return;
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        double in = ((DoubleToken)this.input.get(0)).doubleValue();
        if (Double.isNaN(in)) {
            throw new IllegalActionException("Input is Double.NaN, there is no way to represent a NaN as an integer.");
        }
        this.output.send(0, new IntToken(this._doFunction(in)));
    }

    @Override
    public int iterate(int count) throws IllegalActionException {
        if (count > this._resultArray.length) {
            this._resultArray = new IntToken[count];
        }
        if (this.input.hasToken(0, count)) {
            Token[] inArray = this.input.get(0, count);
            for (int i = 0; i < count; ++i) {
                double value = ((DoubleToken)inArray[i]).doubleValue();
                if (Double.isNaN(value)) {
                    throw new IllegalActionException("Input is Double.NaN, there is no way to represent a NaN as an integer.");
                }
                this._resultArray[i] = new IntToken(this._doFunction(value));
            }
            this.output.send(0, this._resultArray, count);
            return 0;
        }
        return 1;
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (!this.input.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }

    private int _doFunction(double in) {
        int result;
        switch (this._function) {
            case 0: {
                result = (int)Math.ceil(in);
                break;
            }
            case 1: {
                result = (int)Math.floor(in);
                break;
            }
            case 2: {
                result = (int)Math.round(in);
                break;
            }
            case 3: {
                if (in > 0.0) {
                    result = (int)Math.floor(in);
                    break;
                }
                result = (int)Math.ceil(in);
                break;
            }
            default: {
                throw new InvalidStateException("Invalid value for _function private variable. Round actor (" + this.getFullName() + ")" + " on function type " + this._function);
            }
        }
        return result;
    }
}

