/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.SequenceActor;
import ptolemy.actor.lib.gui.Plotter;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.plot.Plot;

public class ArrayPlotterXY
extends Plotter
implements SequenceActor {
    public Parameter iterationsPerUpdate;
    public TypedIOPort x = new TypedIOPort(this, "x", true, false);
    public TypedIOPort y;
    private int _iteration = 0;
    private int _offset;
    private ArrayToken[] _xtokens;
    private ArrayToken[] _ytokens;

    public ArrayPlotterXY(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.x.setMultiport(true);
        this.x.setTypeEquals(BaseType.DOUBLE);
        this.x.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        new Parameter((NamedObj)this.x, "_showName", BooleanToken.TRUE);
        this.y = new TypedIOPort(this, "y", true, false);
        this.y.setMultiport(true);
        this.y.setTypeEquals(BaseType.DOUBLE);
        this.y.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        new Parameter((NamedObj)this.y, "_showName", BooleanToken.TRUE);
        this.iterationsPerUpdate = new Parameter(this, "iterationsPerUpdate");
        this.iterationsPerUpdate.setExpression("1");
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._iteration = 0;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        int xwidth = this.x.getWidth();
        int ywidth = this.y.getWidth();
        this._offset = ((IntToken)this.startingDataset.getToken()).intValue();
        int jointWidth = xwidth;
        if (jointWidth > ywidth) {
            jointWidth = ywidth;
        }
        if (this._xtokens == null || this._xtokens.length != jointWidth) {
            this._xtokens = new ArrayToken[jointWidth];
        }
        if (this._ytokens == null || this._ytokens.length != jointWidth) {
            this._ytokens = new ArrayToken[jointWidth];
        }
        for (int i = xwidth - 1; i >= 0; --i) {
            if (!this.x.hasToken(i)) continue;
            this._xtokens[i] = (ArrayToken)this.x.get(i);
            if (ywidth <= i || !this.y.hasToken(i)) continue;
            this._ytokens[i] = (ArrayToken)this.y.get(i);
            if (this._iteration != 0) continue;
            Token[] xArray = this._xtokens[i].arrayValue();
            Token[] yArray = this._ytokens[i].arrayValue();
            ((Plot)this.plot).clear(i + this._offset);
            for (int j = 0; j < xArray.length; ++j) {
                double xValue = ((DoubleToken)xArray[j]).doubleValue();
                double yValue = ((DoubleToken)yArray[j]).doubleValue();
                ((Plot)this.plot).addPoint(i + this._offset, xValue, yValue, true);
            }
        }
        for (int j = ywidth - 1; j >= xwidth; --j) {
            this.y.get(j);
        }
        ++this._iteration;
        if (this._iteration == ((IntToken)this.iterationsPerUpdate.getToken()).intValue()) {
            this._iteration = 0;
        }
        return super.postfire();
    }

    @Override
    public void wrapup() throws IllegalActionException {
        if (this._xtokens != null) {
            for (int i = this._xtokens.length - 1; i >= 0; --i) {
                if (this._xtokens[i] == null || this._ytokens[i] == null) continue;
                Token[] xArray = this._xtokens[i].arrayValue();
                Token[] yArray = this._ytokens[i].arrayValue();
                ((Plot)this.plot).clear(i + this._offset);
                for (int j = 0; j < xArray.length; ++j) {
                    double xValue = ((DoubleToken)xArray[j]).doubleValue();
                    double yValue = ((DoubleToken)yArray[j]).doubleValue();
                    ((Plot)this.plot).addPoint(i + this._offset, xValue, yValue, true);
                }
            }
        }
        super.wrapup();
    }
}

