/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import diva.gui.toolbox.FocusMouseListener;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.IntToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class ArrowKeySensor
extends TypedAtomicActor {
    public TypedIOPort upArrow = new TypedIOPort(this, "upArrow");
    public TypedIOPort leftArrow;
    public TypedIOPort rightArrow;
    public TypedIOPort downArrow;
    private MyFrame _myFrame;
    private boolean _upKeyPressed = false;
    private boolean _leftKeyPressed = false;
    private boolean _rightKeyPressed = false;
    private boolean _downKeyPressed = false;
    private boolean _upKeyReleased = false;
    private boolean _leftKeyReleased = false;
    private boolean _rightKeyReleased = false;
    private boolean _downKeyReleased = false;

    public ArrowKeySensor(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.upArrow.setTypeEquals(BaseType.INT);
        this.upArrow.setOutput(true);
        this.leftArrow = new TypedIOPort(this, "leftArrow");
        this.leftArrow.setTypeEquals(BaseType.INT);
        this.leftArrow.setOutput(true);
        this.rightArrow = new TypedIOPort(this, "rightArrow");
        this.rightArrow.setTypeEquals(BaseType.INT);
        this.rightArrow.setOutput(true);
        this.downArrow = new TypedIOPort(this, "downArrow");
        this.downArrow.setTypeEquals(BaseType.INT);
        this.downArrow.setOutput(true);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this._upKeyPressed) {
            this._upKeyPressed = false;
            this.upArrow.broadcast(new IntToken(1));
        }
        if (this._leftKeyPressed) {
            this._leftKeyPressed = false;
            this.leftArrow.broadcast(new IntToken(1));
        }
        if (this._rightKeyPressed) {
            this._rightKeyPressed = false;
            this.rightArrow.broadcast(new IntToken(1));
        }
        if (this._downKeyPressed) {
            this._downKeyPressed = false;
            this.downArrow.broadcast(new IntToken(1));
        }
        if (this._upKeyReleased) {
            this._upKeyReleased = false;
            this.upArrow.broadcast(new IntToken(0));
        }
        if (this._leftKeyReleased) {
            this._leftKeyReleased = false;
            this.leftArrow.broadcast(new IntToken(0));
        }
        if (this._rightKeyReleased) {
            this._rightKeyReleased = false;
            this.rightArrow.broadcast(new IntToken(0));
        }
        if (this._downKeyReleased) {
            this._downKeyReleased = false;
            this.downArrow.broadcast(new IntToken(0));
        }
    }

    @Override
    public void initialize() {
        this._myFrame = new MyFrame();
    }

    @Override
    public void wrapup() {
        if (this._myFrame != null) {
            this._myFrame.dispose();
        }
    }

    private class MyFrame
    extends JFrame {
        public MyFrame() {
            ActionListener myUpPressedListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrowKeySensor.this._upKeyPressed = true;
                    ArrowKeySensor.this._upKeyReleased = false;
                    MyFrame.this._tryCallingFireAtCurrentTime();
                }
            };
            ActionListener myUpReleasedListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrowKeySensor.this._upKeyReleased = true;
                    ArrowKeySensor.this._upKeyPressed = false;
                    MyFrame.this._tryCallingFireAtCurrentTime();
                }
            };
            ActionListener myLeftPressedListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrowKeySensor.this._leftKeyPressed = true;
                    ArrowKeySensor.this._leftKeyReleased = false;
                    MyFrame.this._tryCallingFireAtCurrentTime();
                }
            };
            ActionListener myLeftReleasedListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrowKeySensor.this._leftKeyReleased = true;
                    ArrowKeySensor.this._leftKeyPressed = false;
                    MyFrame.this._tryCallingFireAtCurrentTime();
                }
            };
            ActionListener myRightPressedListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrowKeySensor.this._rightKeyPressed = true;
                    ArrowKeySensor.this._rightKeyReleased = false;
                    MyFrame.this._tryCallingFireAtCurrentTime();
                }
            };
            ActionListener myRightReleasedListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrowKeySensor.this._rightKeyReleased = true;
                    ArrowKeySensor.this._rightKeyPressed = false;
                    MyFrame.this._tryCallingFireAtCurrentTime();
                }
            };
            ActionListener myDownPressedListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrowKeySensor.this._downKeyPressed = true;
                    ArrowKeySensor.this._downKeyReleased = false;
                    MyFrame.this._tryCallingFireAtCurrentTime();
                }
            };
            ActionListener myDownReleasedListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrowKeySensor.this._downKeyReleased = true;
                    ArrowKeySensor.this._downKeyPressed = false;
                    MyFrame.this._tryCallingFireAtCurrentTime();
                }
            };
            this.getContentPane().setLayout(new BorderLayout());
            JLabel label = new JLabel("This window reads Arrow Key strokes. It must have the focus (be on top) to do this");
            this.getContentPane().add(label);
            label.registerKeyboardAction(myUpPressedListener, "UpPressed", KeyStroke.getKeyStroke(38, 0, false), 2);
            label.registerKeyboardAction(myUpReleasedListener, "UpReleased", KeyStroke.getKeyStroke(38, 0, true), 2);
            label.registerKeyboardAction(myLeftPressedListener, "LeftPressed", KeyStroke.getKeyStroke(37, 0, false), 2);
            label.registerKeyboardAction(myLeftReleasedListener, "LeftReleased", KeyStroke.getKeyStroke(37, 0, true), 2);
            label.registerKeyboardAction(myRightPressedListener, "RightPressed", KeyStroke.getKeyStroke(39, 0, false), 2);
            label.registerKeyboardAction(myRightReleasedListener, "RightReleased", KeyStroke.getKeyStroke(39, 0, true), 2);
            label.registerKeyboardAction(myDownPressedListener, "DownPressed", KeyStroke.getKeyStroke(40, 0, false), 2);
            label.registerKeyboardAction(myDownReleasedListener, "DownReleased", KeyStroke.getKeyStroke(40, 0, true), 2);
            label.setRequestFocusEnabled(true);
            label.addMouseListener((MouseListener)new FocusMouseListener());
            this.pack();
            this.setVisible(true);
        }

        private void _tryCallingFireAtCurrentTime() {
            try {
                ArrowKeySensor.this.getDirector().fireAtCurrentTime(ArrowKeySensor.this);
            }
            catch (IllegalActionException ex) {
                System.out.println("--" + ex.toString() + "--");
                System.out.println(this + "Ex calling fireAtCurrentTime");
                throw new RuntimeException("-fireAt* catch-");
            }
        }
    }
}

