/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import java.io.InputStream;
import java.net.URL;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PlotEffigy;
import ptolemy.actor.lib.gui.PlotterBase;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.plot.Histogram;
import ptolemy.plot.PlotBox;
import ptolemy.plot.plotml.HistogramMLParser;

public class HistogramPlotter
extends PlotterBase {
    public Parameter binWidth;
    public Parameter binOffset;
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);

    public HistogramPlotter(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(true);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.binWidth = new Parameter(this, "binWidth");
        this.binWidth.setExpression("1.0");
        this.binWidth.setTypeEquals(BaseType.DOUBLE);
        this.binOffset = new Parameter(this, "binOffset");
        this.binOffset.setExpression("0.5");
        this.binOffset.setTypeEquals(BaseType.DOUBLE);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightGrey\"/>\n<rect x=\"-12\" y=\"-12\" width=\"24\" height=\"24\" style=\"fill:white\"/>\n<rect x=\"2\" y=\"-18\" width=\"4\" height=\"4\" style=\"fill:grey\"/>\n<rect x=\"8\" y=\"-18\" width=\"4\" height=\"4\" style=\"fill:grey\"/>\n<rect x=\"14\" y=\"-18\" width=\"4\" height=\"4\" style=\"fill:grey\"/>\n<rect x=\"-8\" y=\"2\" width=\"4\" height=\"10\" style=\"fill:red\"/>\n<rect x=\"-2\" y=\"-8\" width=\"4\" height=\"20\" style=\"fill:red\"/>\n<rect x=\"4\" y=\"-5\" width=\"4\" height=\"17\" style=\"fill:red\"/>\n</svg>\n");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.binWidth) {
            double width = ((DoubleToken)this.binWidth.getToken()).doubleValue();
            if (width <= 0.0) {
                throw new IllegalActionException((Nameable)this, "Invalid bin width (must be positive): " + width);
            }
            if (this.plot instanceof Histogram) {
                ((Histogram)this.plot).setBinWidth(width);
            }
        } else if (attribute == this.binOffset) {
            double offset = ((DoubleToken)this.binOffset.getToken()).doubleValue();
            if (this.plot instanceof Histogram) {
                ((Histogram)this.plot).setBinOffset(offset);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void configure(URL base, String source, String text) throws Exception {
        if (this.plot instanceof Histogram) {
            this._base = base;
            this._source = source;
            this._text = text;
            HistogramMLParser parser = new HistogramMLParser((Histogram)this.plot);
            if (source != null && !source.trim().equals("")) {
                URL xmlFile = new URL(base, source);
                InputStream stream = xmlFile.openStream();
                parser.parse(base, stream);
                stream.close();
            }
            if (text != null && !text.equals("")) {
                String trimmed = text.trim();
                if (trimmed.startsWith("<?") && trimmed.endsWith("?>")) {
                    if ((trimmed = trimmed.substring(2, trimmed.length() - 2).trim()).startsWith("plotml")) {
                        trimmed = trimmed.substring(6).trim();
                        parser.parse(base, trimmed);
                    }
                } else {
                    parser.parse(base, text);
                }
            }
        } else {
            super.configure(base, source, text);
        }
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        if (this.plot == null) {
            this.plot = this._newPlot();
            this.plot.setTitle(this.getName());
            this.plot.setButtons(true);
        }
        if (this._frame == null && this._container == null) {
            Effigy containerEffigy = Configuration.findEffigy(this.toplevel());
            if (containerEffigy == null) {
                throw new IllegalActionException((Nameable)this, "Cannot find effigy for top level: " + this.toplevel().getFullName());
            }
            try {
                PlotEffigy plotEffigy = new PlotEffigy(containerEffigy, containerEffigy.uniqueName("plot"));
                plotEffigy.identifier.setExpression(this.getFullName());
                PlotterBase.PlotWindowTableau tableau = new PlotterBase.PlotWindowTableau(this, plotEffigy, "tableau");
                this._frame = tableau.frame;
            }
            catch (Exception ex) {
                throw new IllegalActionException(this, null, ex, "Error creating effigy and tableau");
            }
            this._windowProperties.setProperties(this._frame);
            this._implementDeferredConfigurations();
            if (this._plotSize != null) {
                this._plotSize.setSize(this.plot);
            }
            this._frame.pack();
        } else {
            this.plot.clear(false);
            this.plot.repaint();
        }
        if (this._frame != null) {
            this._frame.show();
            this._frame.toFront();
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        int width = this.input.getWidth();
        for (int i = width - 1; i >= 0; --i) {
            if (!this.input.hasToken(i)) continue;
            DoubleToken curToken = (DoubleToken)this.input.get(i);
            double curValue = curToken.doubleValue();
            ((Histogram)this.plot).addPoint(i, curValue);
        }
        return super.postfire();
    }

    @Override
    protected void _implementDeferredConfigurations() {
        super._implementDeferredConfigurations();
        try {
            this.attributeChanged(this.binWidth);
            this.attributeChanged(this.binOffset);
        }
        catch (IllegalActionException illegalActionException) {
            // empty catch block
        }
    }

    @Override
    protected PlotBox _newPlot() {
        return new Histogram();
    }
}

