/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import java.awt.Container;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.ExpressionShellEffigy;
import ptolemy.actor.gui.ExpressionShellFrame;
import ptolemy.actor.gui.ExpressionShellTableau;
import ptolemy.actor.gui.Placeable;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.actor.gui.WindowPropertiesAttribute;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.gui.ShellInterpreter;
import ptolemy.gui.ShellTextArea;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class InteractiveShell
extends TypedAtomicActor
implements Placeable,
ShellInterpreter {
    public TypedIOPort input;
    public TypedIOPort output;
    public PortParameter prompt;
    public ShellTextArea shell;
    private Container _container;
    private boolean _firstTime = true;
    private TableauFrame _frame;
    private List _outputValues = new LinkedList();
    private boolean _returnFalseInPostfire = false;
    private WindowPropertiesAttribute _windowProperties;

    public InteractiveShell(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input = new TypedIOPort(this, "input", true, false);
        this.input.setTypeEquals(BaseType.STRING);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(BaseType.STRING);
        this.prompt = new PortParameter((NamedObj)this, "prompt", new StringToken(">>"));
        this.prompt.setTypeEquals(BaseType.STRING);
        this.prompt.setStringMode(true);
        this._windowProperties = new WindowPropertiesAttribute(this, "_windowProperties");
        this._windowProperties.setPersistent(true);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightGrey\"/>\n<rect x=\"-14\" y=\"-14\" width=\"28\" height=\"28\" style=\"fill:white\"/>\n<polyline points=\"-10,-10, -5,-5, -10,0\" style=\"stroke:black\"/>\n<polyline points=\"-7,-10, -2,-5, -7,0\" style=\"stroke:black\"/>\n</svg>\n");
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        InteractiveShell newObject = (InteractiveShell)super.clone(workspace);
        newObject.shell = null;
        newObject._container = null;
        newObject._frame = null;
        return newObject;
    }

    @Override
    public String evaluateCommand(String command) throws Exception {
        this.setOutput(command);
        return null;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.prompt.update();
        this.shell.mainPrompt = ((StringToken)this.prompt.getToken()).stringValue();
        if (this.input.numberOfSources() > 0 && this.input.hasToken(0)) {
            String value = ((StringToken)this.input.get(0)).stringValue();
            if (this._firstTime) {
                this._firstTime = false;
                this.shell.initialize(value);
            } else {
                this.shell.returnResult(value);
            }
        }
        this.shell.setEditable(true);
        String userCommand = this.getOutput();
        if (userCommand.trim().equalsIgnoreCase("quit") || userCommand.trim().equalsIgnoreCase("exit")) {
            this._returnFalseInPostfire = true;
        }
        this.output.broadcast(new StringToken(userCommand));
    }

    public synchronized String getOutput() {
        while (this._outputValues.size() < 1 && !this._stopRequested) {
            try {
                this.workspace().wait(this);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this._stopRequested) {
            return "";
        }
        return (String)this._outputValues.remove(0);
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        if (this.shell == null) {
            Effigy containerEffigy = Configuration.findEffigy(this.toplevel());
            if (containerEffigy == null) {
                throw new IllegalActionException((Nameable)this, "Cannot find effigy for top level: " + this.toplevel().getFullName());
            }
            try {
                ExpressionShellEffigy shellEffigy = new ExpressionShellEffigy(containerEffigy, containerEffigy.uniqueName("shell"));
                shellEffigy.identifier.setExpression(this.getFullName());
                ShellTableau tableau = new ShellTableau(shellEffigy, "tableau");
                this._frame = tableau.frame;
                this.shell = tableau.shell;
                this.shell.setInterpreter(this);
                this.shell.setEditable(false);
            }
            catch (Exception ex) {
                throw new IllegalActionException(this, null, ex, "Error creating effigy and tableau");
            }
            this._windowProperties.setProperties(this._frame);
            this._frame.pack();
        } else {
            this.shell.clearJTextArea();
        }
        if (this._frame != null) {
            this._frame.show();
            this._frame.toFront();
        }
        this._firstTime = true;
        this._returnFalseInPostfire = false;
    }

    @Override
    public boolean isCommandComplete(String command) {
        return true;
    }

    @Override
    public void place(Container container) {
        this._container = container;
        if (this._container == null) {
            if (this._frame != null) {
                this._frame.dispose();
            }
            this._frame = null;
            this.shell = null;
            return;
        }
        this.shell = new ShellTextArea();
        this.shell.setInterpreter(this);
        this.shell.clearJTextArea();
        this.shell.setEditable(false);
        this._container.add(this.shell);
        this.shell.setBackground(null);
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this._returnFalseInPostfire) {
            return false;
        }
        return super.postfire();
    }

    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        NamedObj previousContainer = this.getContainer();
        super.setContainer(container);
        if (container != previousContainer && previousContainer != null) {
            this._remove();
        }
    }

    public synchronized void setOutput(String value) {
        this._outputValues.add(value);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        InteractiveShell interactiveShell = this;
        synchronized (interactiveShell) {
            this.notifyAll();
        }
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        if (this._returnFalseInPostfire && this._frame != null) {
            this._frame.dispose();
            this._frame = null;
            this.shell = null;
        } else if (this.shell != null) {
            this.shell.setEditable(false);
        }
    }

    @Override
    protected void _exportMoMLContents(Writer output, int depth) throws IOException {
        if (this._frame != null) {
            this._windowProperties.recordProperties(this._frame);
        }
        super._exportMoMLContents(output, depth);
    }

    private void _remove() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (InteractiveShell.this.shell != null) {
                    if (InteractiveShell.this._container != null) {
                        InteractiveShell.this._container.remove(InteractiveShell.this.shell);
                        InteractiveShell.this._container.invalidate();
                        InteractiveShell.this._container.repaint();
                    } else if (InteractiveShell.this._frame != null) {
                        InteractiveShell.this._frame.dispose();
                    }
                }
            }
        });
    }

    public class ShellFrame
    extends ExpressionShellFrame {
        public ShellFrame(ExpressionShellTableau tableau) throws IllegalActionException, NameDuplicationException {
            super(tableau);
        }

        @Override
        protected boolean _close() {
            if (InteractiveShell.this._frame != null) {
                InteractiveShell.this._windowProperties.setProperties(InteractiveShell.this._frame);
            }
            super._close();
            InteractiveShell.this.place(null);
            return true;
        }
    }

    public class ShellTableau
    extends ExpressionShellTableau {
        public ShellTableau(ExpressionShellEffigy container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
            this.frame = new ShellFrame(this);
            this.setFrame(this.frame);
            this.frame.setTableau(this);
        }
    }
}

