/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.icon.EditorIcon;
import ptolemy.vergil.kernel.attributes.RectangleAttribute;

public class LEDMatrix
extends TypedAtomicActor {
    public TypedIOPort column = new TypedIOPort(this, "column", true, false);
    public TypedIOPort control;
    public TypedIOPort row;
    public Parameter columns;
    public Parameter rows;
    private RectangleAttribute[][] _leds;
    EditorIcon _ledArray_icon;

    public LEDMatrix(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.column.setTypeEquals(BaseType.INT);
        this.row = new TypedIOPort(this, "row", true, false);
        this.row.setTypeEquals(BaseType.INT);
        this.control = new TypedIOPort(this, "control", true, false);
        this.control.setTypeEquals(BaseType.BOOLEAN);
        this.columns = new Parameter(this, "columns");
        this.columns.setExpression("10");
        this.rows = new Parameter(this, "rows");
        this.rows.setExpression("10");
        this._ledArray_icon = new EditorIcon((NamedObj)this, "_icon");
        this._init();
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.row.hasToken(0) && this.column.hasToken(0) && this.control.hasToken(0)) {
            int rowValue = ((IntToken)this.row.get(0)).intValue();
            int columnValue = ((IntToken)this.column.get(0)).intValue();
            boolean controlValue = ((BooleanToken)this.control.get(0)).booleanValue();
            if (controlValue) {
                this._leds[rowValue][columnValue].fillColor.setToken("{1.0, 0.0, 0.0, 1.0}");
            } else {
                this._leds[rowValue][columnValue].fillColor.setToken("{0.0, 0.0, 0.0, 1.0}");
            }
        }
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        int columnsValue = ((IntToken)this.columns.getToken()).intValue();
        int rowsValue = ((IntToken)this.rows.getToken()).intValue();
        for (int x = 0; x < rowsValue; ++x) {
            for (int y = 0; y < columnsValue; ++y) {
                this._leds[x][y].fillColor.setToken("{0.0, 0.0, 0.0, 1.0}");
            }
        }
    }

    private void _init() throws IllegalActionException, NameDuplicationException {
        int columnsValue = ((IntToken)this.columns.getToken()).intValue();
        int rowsValue = ((IntToken)this.rows.getToken()).intValue();
        this._leds = new RectangleAttribute[rowsValue][columnsValue];
        for (int x = 0; x < rowsValue; ++x) {
            for (int y = 0; y < columnsValue; ++y) {
                RectangleAttribute rectangle = new RectangleAttribute((NamedObj)this._ledArray_icon, "_led_" + x + "_" + y);
                Location location = new Location((NamedObj)rectangle, "_location");
                double[] ledLocationValue = new double[]{x * 20, y * 20};
                location.setLocation(ledLocationValue);
                rectangle.width.setToken("20.0");
                rectangle.height.setToken("39.0");
                rectangle.centered.setToken("true");
                rectangle.fillColor.setToken("{0.0, 0.0, 0.0, 1.0}");
                this._leds[x][y] = rectangle;
            }
        }
    }
}

