/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphPane;
import diva.graph.JGraph;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.net.URL;
import java.util.List;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.gui.AbstractPlaceableActor;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.SizeAttribute;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.data.StringToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.moml.MoMLParser;
import ptolemy.moml.ParserAttribute;
import ptolemy.vergil.actor.ActorEditorGraphController;
import ptolemy.vergil.actor.ActorGraphModel;

public class ModelDisplay
extends AbstractPlaceableActor
implements ChangeListener {
    public FileParameter modelURL = new FileParameter(this, "modelURL");
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    private PtolemyEffigy _effigy;
    private NamedObj _entity;
    private JGraph _graph;
    private Tableau _tableau;

    public ModelDisplay(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.STRING);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.modelURL) {
            URL url = this.modelURL.asURL();
            if (url != null) {
                MoMLParser parser = new MoMLParser();
                try {
                    this._entity = parser.parse(null, url);
                    ParserAttribute parserAttribute = new ParserAttribute(this._entity, "_parser");
                    parserAttribute.setParser(parser);
                }
                catch (Exception ex) {
                    throw new IllegalActionException((Nameable)this, ex, "Failed to read model from: " + url);
                }
            } else {
                this._createBlankEntity();
            }
            this.place(null);
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void changeExecuted(ChangeRequest change) {
    }

    @Override
    public void changeFailed(ChangeRequest change, Exception exception) {
        this.stop();
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.getWidth() > 0 && this.input.hasToken(0)) {
            String moml = ((StringToken)this.input.get(0)).stringValue();
            MoMLChangeRequest request = new MoMLChangeRequest(this, this._entity, moml);
            request.addChangeListener(this);
            this._entity.requestChange(request);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        if (this._entity == null) {
            this._createBlankEntity();
        }
        if (this._graph == null) {
            Effigy containerEffigy = Configuration.findEffigy(this.toplevel());
            try {
                this._effigy = new PtolemyEffigy(containerEffigy, "ModelDisplay Effigy");
                this._effigy.setModel(this._entity);
                this._tableau = new Tableau(this._effigy, "tableau");
            }
            catch (NameDuplicationException e) {
                throw new IllegalActionException((Nameable)this, e, "Failed to create tableau.");
            }
            this._frame = new TableauFrame(this._tableau);
            this.setFrame(this._frame);
            this._tableau.setFrame(this._frame);
            this.place(this._frame.getContentPane());
            this._frame.pack();
        }
        if (this._frame != null) {
            ((TableauFrame)this._frame).show();
            this._frame.toFront();
        }
    }

    @Override
    public void place(Container container) {
        if (container == null) {
            if (this._frame != null) {
                this._frame.dispose();
            }
            this._frame = null;
            if (this._tableau != null) {
                try {
                    this._tableau.setContainer(null);
                    this._effigy.setContainer(null);
                }
                catch (Exception e) {
                    throw new InternalErrorException(e);
                }
            }
            this._tableau = null;
            this._graph = null;
        } else {
            ActorEditorGraphController controller = new ActorEditorGraphController();
            if (this._entity == null) {
                this._createBlankEntity();
            }
            ActorGraphModel graphModel = new ActorGraphModel(this._entity);
            GraphPane graphPane = new GraphPane((GraphController)controller, (GraphModel)graphModel);
            this._graph = new JGraph(graphPane);
            List size = this._entity.attributeList(SizeAttribute.class);
            if (size.size() > 0) {
                ((SizeAttribute)size.get(0)).setSize((Component)this._graph);
            } else {
                this._graph.setMinimumSize(new Dimension(200, 200));
                this._graph.setMaximumSize(new Dimension(200, 200));
                this._graph.setPreferredSize(new Dimension(200, 200));
                this._graph.setSize(200, 200);
            }
            container.add((Component)this._graph);
        }
    }

    private void _createBlankEntity() {
        String moml = "<entity name=\"top\" class=\"ptolemy.kernel.CompositeEntity\"/>";
        MoMLParser parser = new MoMLParser();
        try {
            this._entity = parser.parse(null, moml);
            ParserAttribute parserAttribute = new ParserAttribute(this._entity, "_parser");
            parserAttribute.setParser(parser);
        }
        catch (Exception ex) {
            throw new InternalErrorException(ex);
        }
    }
}

