/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.Placeable;
import ptolemy.actor.gui.SizeAttribute;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.actor.gui.TokenEffigy;
import ptolemy.actor.gui.WindowPropertiesAttribute;
import ptolemy.actor.lib.Sink;
import ptolemy.actor.lib.image.ImageTableau;
import ptolemy.data.ImageToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.gui.StatusBar;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;
import ptolemy.media.Picture;

public class ImageDisplay
extends Sink
implements Placeable {
    protected Container _container;
    protected TokenEffigy _effigy;
    protected ImageWindow _frame;
    protected int _oldXSize = 0;
    protected int _oldYSize = 0;
    protected Picture _picture;
    private SizeAttribute _pictureSize;
    private ImageTableau _tableau;
    private WindowPropertiesAttribute _windowProperties;

    public ImageDisplay(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.OBJECT);
        this._frame = null;
        this._container = null;
        this._windowProperties = new WindowPropertiesAttribute(this, "_windowProperties");
        this._windowProperties.setPersistent(true);
        this._pictureSize = new SizeAttribute(this, "_pictureSize");
        this._pictureSize.setPersistent(true);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ImageDisplay newObject = (ImageDisplay)super.clone(workspace);
        newObject._container = null;
        newObject._frame = null;
        return newObject;
    }

    public Color getBackground() {
        return this._container.getBackground();
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        Runnable doDisplay = new Runnable(){

            @Override
            public void run() {
                ImageDisplay.this._createOrShowWindow();
            }
        };
        SwingUtilities.invokeLater(doDisplay);
    }

    @Override
    public void place(Container container) {
        if (this._container != null && this._picture != null) {
            this._container.remove(this._picture);
            this._container = null;
        }
        if (this._frame != null) {
            this._frame.dispose();
            this._frame = null;
        }
        this._container = container;
        if (container == null) {
            if (this._tableau != null) {
                try {
                    this._tableau.setContainer(null);
                }
                catch (KernelException ex) {
                    throw new InternalErrorException(ex);
                }
            }
            this._tableau = null;
            this._effigy = null;
            this._picture = null;
            this._oldXSize = 0;
            this._oldYSize = 0;
            return;
        }
        if (this._picture == null) {
            this._picture = new Picture(this._oldXSize, this._oldYSize);
        }
        this._container.add((Component)this._picture, "Center");
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this.input.hasToken(0)) {
            final Token in = this.input.get(0);
            Runnable doDisplay = new Runnable(){

                @Override
                public void run() {
                    ImageDisplay.this._display(in);
                }
            };
            SwingUtilities.invokeLater(doDisplay);
        }
        return super.postfire();
    }

    public void setBackground(Color background) {
        this._container.setBackground(background);
    }

    protected void _display(Token in) {
        if (!(in instanceof ImageToken)) {
            throw new InternalErrorException("Input is not an ImageToken. It is: " + in);
        }
        if (this._frame != null) {
            LinkedList<Token> tokens = new LinkedList<Token>();
            tokens.add(in);
            try {
                this._effigy.setTokens(tokens);
            }
            catch (IllegalActionException e) {
                throw new InternalErrorException(e);
            }
        } else if (this._picture != null) {
            Image image = ((ImageToken)in).asAWTImage();
            int xSize = image.getWidth(null);
            int ySize = image.getHeight(null);
            if (this._oldXSize != xSize || this._oldYSize != ySize) {
                if (this._debugging) {
                    this._debug("Image size has changed.");
                }
                this._oldXSize = xSize;
                this._oldYSize = ySize;
                Container container = this._picture.getParent();
                container.remove(this._picture);
                this._picture = new Picture(xSize, ySize);
                this._picture.setImage(image);
                this._picture.setBackground(null);
                container.add("Center", this._picture);
                container.validate();
                container.invalidate();
                container.repaint();
                container.doLayout();
                Container c = container.getParent();
                while (c.getParent() != null) {
                    c.invalidate();
                    c.validate();
                    if (!((c = c.getParent()) instanceof JFrame)) continue;
                    ((JFrame)c).pack();
                }
            } else {
                this._picture.setImage(((ImageToken)in).asAWTImage());
                this._picture.displayImage();
                this._picture.repaint();
            }
        }
    }

    private void _createOrShowWindow() {
        if (this._container == null) {
            if (this._tableau == null) {
                Effigy containerEffigy = Configuration.findEffigy(this.toplevel());
                if (containerEffigy == null) {
                    throw new InternalErrorException("Cannot find effigy for top level: " + this.toplevel().getFullName());
                }
                try {
                    this._effigy = new TokenEffigy(containerEffigy, containerEffigy.uniqueName("imageEffigy"));
                    this._effigy.identifier.setExpression(this.getFullName());
                    this._frame = new ImageWindow();
                    this._tableau = new ImageTableau(this._effigy, "tokenTableau", this._frame, this._oldXSize, this._oldYSize);
                    this._tableau.setTitle(this.getName());
                    this._frame.setTableau(this._tableau);
                    this._windowProperties.setProperties(this._frame);
                    Component[] components = this._frame.getContentPane().getComponents();
                    if (components.length > 0) {
                        this._pictureSize.setSize(components[0]);
                    }
                    this._tableau.show();
                }
                catch (Exception ex) {
                    throw new InternalErrorException(ex);
                }
            } else {
                this._effigy.clear();
                if (this._frame != null) {
                    this._frame.toFront();
                }
            }
        }
        if (this._frame != null) {
            this._frame.setVisible(true);
            this._frame.toFront();
        }
    }

    protected class ImageWindow
    extends TableauFrame {
        public ImageWindow() {
            super((Tableau)null, (StatusBar)null);
        }

        @Override
        protected boolean _close() {
            ImageDisplay.this._windowProperties.recordProperties(this);
            Component[] components = this.getContentPane().getComponents();
            if (components.length > 0) {
                ImageDisplay.this._pictureSize.recordSize(components[0]);
            }
            super._close();
            ImageDisplay.this.place(null);
            return true;
        }
    }
}

