/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.javasound;

import java.io.IOException;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.media.javasound.SoundWriter;

public class AudioWriteBuffer
extends TypedAtomicActor {
    public TypedIOPort address = new TypedIOPort(this, "address", true, false);
    public TypedIOPort data;
    public Parameter bufferLength;
    public Parameter overwrite;
    public StringAttribute pathName;
    public Parameter sampleRate;
    public Parameter bitsPerSample;
    public Parameter channels;
    private SoundWriter _soundWriter;
    private int _channels;
    private int _putSampleSize;
    private double[][] _audioPutArray;
    private Token[][] _inArray;
    private boolean _safeToInitialize = false;
    private double[] _audioBuffer;

    public AudioWriteBuffer(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.address.setMultiport(true);
        this.address.setTypeEquals(BaseType.INT);
        this.data = new TypedIOPort(this, "data", true, false);
        this.data.setMultiport(true);
        this.data.setTypeEquals(BaseType.DOUBLE);
        this.pathName = new StringAttribute(this, "pathName");
        this.pathName.setExpression("outfile.wav");
        this.sampleRate = new Parameter((NamedObj)this, "sampleRate", new IntToken(8000));
        this.sampleRate.setTypeEquals(BaseType.INT);
        this.bitsPerSample = new Parameter((NamedObj)this, "bitsPerSample", new IntToken(16));
        this.bitsPerSample.setTypeEquals(BaseType.INT);
        this.channels = new Parameter((NamedObj)this, "channels", new IntToken(1));
        this.channels.setTypeEquals(BaseType.INT);
        this.attributeChanged(this.channels);
        this.bufferLength = new Parameter((NamedObj)this, "bufferLength", new IntToken(8000));
        this.overwrite = new Parameter((NamedObj)this, "overwrite", new BooleanToken(true));
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.channels) {
            this._channels = ((IntToken)this.channels.getToken()).intValue();
            if (this._channels < 1) {
                throw new IllegalActionException((Nameable)this, "Attempt to set channels parameter to an illegal value of: " + this._channels + " . The value must be a " + "positive integer.");
            }
            if (this._inArray == null || this._channels != this._inArray.length) {
                this._inArray = new Token[this._channels][];
            }
            if (this._audioPutArray == null || this._channels != this._audioPutArray.length) {
                this._audioPutArray = new double[this._channels][];
            }
            for (int i = 0; i < this._channels; ++i) {
                this._audioPutArray[i] = new double[this._putSampleSize];
            }
        } else if (attribute == this.bufferLength) {
            if (this._safeToInitialize) {
                this._initializeWriter();
            }
        } else {
            super.attributeChanged(attribute);
            return;
        }
        if (this._safeToInitialize) {
            this._initializeWriter();
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._initializeWriter();
        this._safeToInitialize = true;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.address.hasToken(0) && this.data.hasToken(0)) {
            int addressValue = ((IntToken)this.address.get(0)).intValue();
            if (addressValue < 0) {
                this.data.get(0);
            } else if (addressValue > this._audioBuffer.length - 1) {
                this.data.get(0);
            } else {
                double sampleValue = ((DoubleToken)this.data.get(0)).doubleValue();
                boolean overwriteMode = ((BooleanToken)this.overwrite.getToken()).booleanValue();
                if (overwriteMode) {
                    this._audioBuffer[addressValue] = sampleValue;
                } else {
                    int n = addressValue;
                    this._audioBuffer[n] = this._audioBuffer[n] + sampleValue;
                }
            }
        } else if (this.address.hasToken(0)) {
            System.out.println(this.getName() + "WARNING: address port does not have a token!");
        } else if (this.data.hasToken(0)) {
            System.out.println(this.getName() + "WARNING: data port does not have a token!");
        } else {
            System.out.println(this.getName() + "WARNING: neither data port has a token!");
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        return true;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        this._channels = ((IntToken)this.channels.getToken()).intValue();
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        if (this._soundWriter != null) {
            try {
                for (int i = 0; i < this._audioBuffer.length; ++i) {
                    this._audioPutArray[0][0] = this._audioBuffer[i];
                    this._soundWriter.putSamples(this._audioPutArray);
                }
                this._soundWriter.closeFile();
            }
            catch (IOException ex) {
                throw new IllegalActionException((Nameable)this, "Error closing file:\n" + ex.getMessage());
            }
        }
        this._safeToInitialize = false;
    }

    private synchronized void _initializeWriter() throws IllegalActionException {
        if (this._soundWriter != null) {
            try {
                this._soundWriter.closeFile();
            }
            catch (IOException ex) {
                throw new IllegalActionException((Nameable)this, "Cannot write audio: \n" + ex.getMessage());
            }
        }
        this._putSampleSize = 1;
        for (int i = 0; i < this._channels; ++i) {
            this._audioPutArray[i] = new double[this._putSampleSize];
        }
        String pathNameString = this.pathName.getExpression();
        int sampleRateInt = ((IntToken)this.sampleRate.getToken()).intValue();
        int bitsPerSampleInt = ((IntToken)this.bitsPerSample.getToken()).intValue();
        int channelsInt = ((IntToken)this.channels.getToken()).intValue();
        int putSamplesSize = this._putSampleSize;
        this._soundWriter = new SoundWriter(pathNameString, sampleRateInt, bitsPerSampleInt, channelsInt, putSamplesSize);
        int length = ((IntToken)this.bufferLength.getToken()).intValue();
        this._audioBuffer = new double[length];
    }
}

