/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.javasound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.javasound.SoundActor;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class SoundPlayer
extends SoundActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    private byte[] _playbackData;
    protected SourceDataLine _sourceDataLine;

    public SoundPlayer(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.DOUBLE_MATRIX);
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        if (this._sourceDataLine != null && this._sourceDataLine.isOpen()) {
            this._sourceDataLine.drain();
            this._sourceDataLine.close();
        }
        boolean signed = true;
        boolean bigEndian = true;
        AudioFormat format = new AudioFormat(this._sampleRate, this._bytesPerSample * 8, this._channels, signed, bigEndian);
        try {
            this._sourceDataLine = AudioSystem.getSourceDataLine(format);
            this._sourceDataLine.open(format, this._bufferSize * this._bytesPerSample * this._channels);
            this._sourceDataLine.start();
        }
        catch (LineUnavailableException e) {
            throw new IllegalActionException((Nameable)this, e, "Specified audio format is not available on this hardware.");
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this.input.hasToken(0)) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.input.get(0);
            double[][] data = token.doubleMatrix();
            int numberOfSamples = data[0].length;
            int bufferSize = numberOfSamples * this._bytesPerSample * this._channels;
            if (this._playbackData == null || this._playbackData.length != bufferSize) {
                this._playbackData = new byte[bufferSize];
            }
            this._doubleArrayToByteArray(data, this._playbackData);
            this._sourceDataLine.write(this._playbackData, 0, bufferSize);
        }
        return true;
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        if (this._sourceDataLine != null) {
            this._sourceDataLine.drain();
            this._sourceDataLine.stop();
            this._sourceDataLine.close();
        }
        this._sourceDataLine = null;
    }
}

