/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.security;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Constants;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.util.StringUtilities;

public class KeyStoreActor
extends TypedAtomicActor {
    public StringParameter alias = new StringParameter(this, "alias");
    public Parameter createFileOrURLIfNecessary;
    public FileParameter fileOrURL;
    public StringParameter keyStoreType;
    public PortParameter keyPassword;
    public StringParameter provider;
    public PortParameter storePassword;
    protected String _alias;
    protected String _keyPassword;
    protected KeyStore _keyStore;
    protected String _keyStoreType;
    protected String _provider;
    protected String _storePassword;
    protected boolean _loadKeyStoreNeeded = true;
    private _StreamReaderThread _errorGobbler;
    private static int _keystoreStreamReaderThreadCount = 0;
    private boolean _initializeKeyStoreNeeded = true;
    private _StreamReaderThread _outputGobbler;
    private Process _process;
    private boolean _stopFireRequested = false;

    public KeyStoreActor(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.alias.setExpression("claudius");
        this.createFileOrURLIfNecessary = new Parameter(this, "createFileOrURLIfNecessary");
        this.createFileOrURLIfNecessary.setExpression("true");
        this.createFileOrURLIfNecessary.setTypeEquals(BaseType.BOOLEAN);
        this.fileOrURL = new FileParameter(this, "fileOrURL");
        this.fileOrURL.setExpression("$PTII/ptKeystore");
        this.keyPassword = new PortParameter(this, "keyPassword");
        this.keyPassword.setTypeEquals(BaseType.STRING);
        this.keyPassword.setStringMode(true);
        this.keyPassword.setExpression("this.is.the.keyPassword,change.it");
        this.keyStoreType = new StringParameter(this, "keyStoreType");
        this.keyStoreType.setExpression(KeyStore.getDefaultType());
        for (String keyStoreName : Security.getAlgorithms("KeyStore")) {
            this.keyStoreType.addChoice(keyStoreName);
        }
        this.provider = new StringParameter(this, "provider");
        this.provider.setExpression("SystemDefault");
        this.provider.addChoice("SystemDefault");
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            this.provider.addChoice(providers[i].getName());
        }
        this.storePassword = new PortParameter(this, "storePassword");
        this.storePassword.setTypeEquals(BaseType.STRING);
        this.storePassword.setStringMode(true);
        this.storePassword.setExpression("this.is.the.storePassword,change.it");
        this._storePassword = this.storePassword.getExpression();
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.alias) {
            this._alias = this.alias.getExpression();
        } else if (attribute == this.fileOrURL) {
            this._loadKeyStoreNeeded = true;
        } else if (attribute == this.keyPassword) {
            this._keyPassword = this.keyPassword.getExpression();
        } else if (attribute == this.keyStoreType) {
            this._initializeKeyStoreNeeded = true;
            this._keyStoreType = this.keyStoreType.getExpression();
        } else if (attribute == this.provider) {
            this._initializeKeyStoreNeeded = true;
            this._provider = this.provider.getExpression();
        } else if (attribute == this.storePassword) {
            this._loadKeyStoreNeeded = true;
            this._storePassword = this.storePassword.getExpression();
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void createKeystore(String keystoreFilename) throws IllegalActionException {
        File javaHomeFile;
        System.out.println("Creating keystore " + keystoreFilename);
        String javaHomeProperty = "ptolemy.ptII.java.home";
        String javaHome = null;
        try {
            javaHome = StringUtilities.getProperty(javaHomeProperty);
        }
        catch (SecurityException ex) {
            System.out.println("Warning: KeyStoreActor: Failed to get the java home directory (-sandbox always causes this): " + ex);
        }
        if (javaHome == null || javaHome.length() == 0) {
            javaHome = StringUtilities.getProperty("java.home");
            if (javaHome != null && javaHome.length() > 0) {
                javaHome = javaHome.replace('\\', '/');
            } else {
                throw new InternalErrorException(this, null, "Could not find the " + javaHomeProperty + " and the " + "java.home property. Perhaps " + "$PTII/lib/ptII.properties " + "is not being read properly?");
            }
        }
        if (!(javaHomeFile = new File(javaHome)).isDirectory()) {
            throw new InternalErrorException(this, null, "Could not find the Java directory that contains bin/keytool.  Tried looking for the '" + javaHome + "' directory. " + "Perhaps the " + javaHomeProperty + " or java.home property was not set " + "properly because " + "$PTII/lib/ptII.properties is not being read properly?");
        }
        String keytoolPath = javaHome + "/bin/keytool";
        String commonCommand = " -keystore " + keystoreFilename + " -storetype " + this._keyStoreType + " -alias " + this._alias + " -storepass \"" + this._storePassword + "\"" + " -keypass \"" + this._keyPassword + "\"";
        String command1 = keytoolPath + " -genkey" + " -dname \"CN=Claudius Ptolemaus, OU=Your Project, O=Your University, L=Your Town, S=Your State, C=US\"" + commonCommand;
        String command2 = keytoolPath + " -selfcert" + commonCommand;
        String command3 = keytoolPath + " -list" + " -keystore " + keystoreFilename + " -storepass \"" + this._storePassword + "\"";
        this._exec(command1);
        this._exec(command2);
        this._exec(command3);
        if (!new File(keystoreFilename).exists()) {
            throw new IllegalActionException((Nameable)this, "Failed to create '" + keystoreFilename + "', try running\n" + command1 + "\n" + command2 + "\n" + command3);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.keyPassword.update();
        this._keyPassword = ((StringToken)this.keyPassword.getToken()).stringValue();
        if (!this.keyPassword.getExpression().equals(this._keyPassword)) {
            this._loadKeyStoreNeeded = true;
        }
        this.keyPassword.setExpression(this._keyPassword);
        this.storePassword.update();
        this._storePassword = ((StringToken)this.storePassword.getToken()).stringValue();
        if (!this.storePassword.getExpression().equals(this._storePassword)) {
            this._loadKeyStoreNeeded = true;
        }
        this.storePassword.setExpression(this._storePassword);
        this._loadKeyStore();
    }

    @Override
    public synchronized void stopFire() {
        super.stopFire();
        this._stopFireRequested = true;
        try {
            this._terminateProcess();
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(ex);
        }
    }

    @Override
    public void wrapup() throws IllegalActionException {
        this._terminateProcess();
    }

    protected void _initializeKeyStore() throws IllegalActionException {
        if (this._initializeKeyStoreNeeded) {
            try {
                this._keyStore = this._provider.equalsIgnoreCase("SystemDefault") ? KeyStore.getInstance(this._keyStoreType) : KeyStore.getInstance(this._keyStoreType, this._provider);
                this._initializeKeyStoreNeeded = false;
                this._loadKeyStoreNeeded = true;
            }
            catch (Throwable throwable) {
                throw new IllegalActionException((Nameable)this, throwable, "Failed to get instance '" + this.keyStoreType + "'of keyStore");
            }
        }
    }

    protected void _loadKeyStore() throws IllegalActionException {
        if (this._loadKeyStoreNeeded) {
            this._initializeKeyStore();
            InputStream keyStoreInputStream = null;
            try {
                keyStoreInputStream = this.fileOrURL.asURL().openStream();
            }
            catch (FileNotFoundException ex) {
            }
            catch (IOException ex2) {
                throw new IllegalActionException((Nameable)this, ex2, "Failed to open '" + this.fileOrURL.asURL() + "' keyStore");
            }
            if (keyStoreInputStream == null && ((BooleanToken)this.createFileOrURLIfNecessary.getToken()).booleanValue()) {
                String keystoreFileName = this.fileOrURL.stringValue();
                try {
                    String classpathProperty = ((StringToken)Constants.get("CLASSPATH")).stringValue();
                    if (keystoreFileName.startsWith(classpathProperty)) {
                        keystoreFileName = ((StringToken)Constants.get("PTII")).stringValue() + "/" + keystoreFileName.substring(classpathProperty.length());
                    }
                    this.createKeystore(keystoreFileName);
                }
                catch (IllegalActionException ex) {
                    throw new IllegalActionException((Nameable)this, ex, "Failed to create keystore '" + keystoreFileName + "'");
                }
                try {
                    keyStoreInputStream = this.fileOrURL.asURL().openStream();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (keyStoreInputStream == null) {
                try {
                    this._keyStore.load(null, null);
                    this.alias.removeAllChoices();
                }
                catch (Exception ex) {
                    throw new IllegalActionException((Nameable)this, ex, "Problem creating a new empty keyStore.");
                }
            }
            try {
                this._keyStore.load(keyStoreInputStream, this._storePassword.toCharArray());
                this.alias.removeAllChoices();
                Enumeration<String> aliases = this._keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String aliasName = aliases.nextElement();
                    this.alias.addChoice(aliasName);
                }
                keyStoreInputStream.close();
            }
            catch (EOFException ex) {
                throw new IllegalActionException((Nameable)this, ex, "Problem loading " + this.fileOrURLDescription() + ", perhaps the file is of length 0? " + "To create a sample file, try " + "cd $PTII; make ptKeystore");
            }
            catch (Exception ex) {
                throw new IllegalActionException((Nameable)this, ex, "Problem loading " + this.fileOrURLDescription());
            }
            this._loadKeyStoreNeeded = false;
        }
    }

    protected String fileOrURLDescription() {
        if (this.fileOrURL == null) {
            return "Keystore URL is null";
        }
        StringBuffer results = new StringBuffer("Keystore");
        String name = null;
        try {
            name = ": '" + this.fileOrURL.stringValue() + "'";
        }
        catch (Throwable throwable) {
            name = ": " + this.fileOrURL.toString();
        }
        results.append(name);
        String exists = ", which does not exist";
        try {
            File fileHandle = this.fileOrURL.asFile();
            if (fileHandle.exists()) {
                exists = fileHandle.canRead() ? ", which exists and is readable" : ", which exists and is not readable";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        results.append(exists + ", ");
        String url = " and cannot be represented as a URL";
        try {
            url = " as a URL is: '" + this.fileOrURL.asURL().toString() + "'";
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        results.append(url);
        return results.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _exec(String command) throws IllegalActionException {
        String outputString = "";
        String errorString = "";
        try {
            this._stopFireRequested = false;
            System.out.println("Keystore Command: " + command);
            if (this._process != null) {
                this._terminateProcess();
            }
            Runtime runtime = Runtime.getRuntime();
            String[] commandTokens = StringUtilities.tokenizeForExec(command);
            this._process = runtime.exec(commandTokens);
            this._outputGobbler = new _StreamReaderThread(this._process.getInputStream(), "KeyStoreActor Stdout Gobbler-" + _keystoreStreamReaderThreadCount++, this);
            this._errorGobbler = new _StreamReaderThread(this._process.getErrorStream(), "KeyStoreActor Stderr Gobbler-" + _keystoreStreamReaderThreadCount++, this);
            this._errorGobbler.start();
            this._outputGobbler.start();
            try {
                this._process.waitFor();
                KeyStoreActor keyStoreActor = this;
                synchronized (keyStoreActor) {
                    this._process = null;
                }
            }
            catch (InterruptedException interrupted) {
                // empty catch block
            }
            outputString = this._outputGobbler.getAndReset();
            errorString = this._errorGobbler.getAndReset();
            if (this._debugging) {
                this._debug("Exec: Error: '" + errorString + "'");
                this._debug("Exec: Output: '" + outputString + "'");
            }
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Problem setting up command '" + command + "'\n" + outputString + "\n" + errorString);
        }
        System.out.print(outputString);
        System.err.print(errorString);
    }

    private void _terminateProcess() throws IllegalActionException {
        if (this._process != null) {
            this._process.destroy();
            this._process = null;
        }
    }

    private class _StreamReaderThread
    extends Thread {
        private Nameable _actor;
        private StringBuffer _stringBuffer;
        private InputStream _inputStream;
        private InputStreamReader _inputStreamReader;

        _StreamReaderThread(InputStream inputStream, String name, Nameable actor) {
            super(name);
            this._inputStream = inputStream;
            this._inputStreamReader = new InputStreamReader(this._inputStream);
            this._actor = actor;
            this._stringBuffer = new StringBuffer();
        }

        public String getAndReset() {
            block7: {
                if (KeyStoreActor.this._debugging) {
                    try {
                        KeyStoreActor.this._debug("getAndReset: Gobbler '" + this.getName() + "' Ready: " + this._inputStreamReader.ready() + " Available: " + this._inputStream.available());
                    }
                    catch (Exception ex) {
                        throw new InternalErrorException(ex);
                    }
                }
                try {
                    this._read();
                }
                catch (Throwable throwable) {
                    if (!KeyStoreActor.this._debugging) break block7;
                    KeyStoreActor.this._debug("WARNING: getAndReset(): _read() threw an exception, which we are ignoring.\n" + throwable.getMessage());
                }
            }
            String results = this._stringBuffer.toString();
            this._stringBuffer = new StringBuffer();
            try {
                this._inputStreamReader.close();
            }
            catch (Exception ex) {
                throw new InternalErrorException(null, (Throwable)ex, this.getName() + " failed to close.");
            }
            return results;
        }

        @Override
        public void run() {
            this._read();
        }

        private void _read() {
            char[] chars = new char[80];
            try {
                int length;
                while ((length = this._inputStreamReader.read(chars, 0, 80)) != -1 && !KeyStoreActor.this._stopRequested && !KeyStoreActor.this._stopFireRequested) {
                    if (KeyStoreActor.this._debugging) {
                        KeyStoreActor.this._debug("_read(): Gobbler '" + this.getName() + "' Ready: " + this._inputStreamReader.ready() + " Value: '" + String.valueOf(chars, 0, length) + "'");
                    }
                    this._stringBuffer.append(chars, 0, length);
                }
            }
            catch (Throwable throwable) {
                throw new InternalErrorException(this._actor, throwable, this.getName() + ": Failed while reading from " + this._inputStream);
            }
        }
    }
}

