/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.security;

import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.util.Iterator;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.StringToken;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class SignatureActor
extends TypedAtomicActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public TypedIOPort output;
    public StringParameter provider;
    public StringParameter signatureAlgorithm;
    protected String _provider;
    protected Signature _signature;
    protected String _signatureAlgorithm;
    private boolean _updateSignatureNeeded = true;

    public SignatureActor(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(new ArrayType(BaseType.UNSIGNED_BYTE));
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(new ArrayType(BaseType.UNSIGNED_BYTE));
        this.provider = new StringParameter(this, "provider");
        this.provider.setExpression("SystemDefault");
        this.provider.addChoice("SystemDefault");
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            this.provider.addChoice(providers[i].getName());
        }
        this.signatureAlgorithm = new StringParameter(this, "signatureAlgorithm");
        Iterator<String> signatureAlgorithms = Security.getAlgorithms("Signature").iterator();
        int i = 0;
        while (signatureAlgorithms.hasNext()) {
            String algorithmName = signatureAlgorithms.next();
            if (i == 0) {
                this.signatureAlgorithm.setExpression(algorithmName);
            }
            this.signatureAlgorithm.addChoice(algorithmName);
            ++i;
        }
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.signatureAlgorithm) {
            this._updateSignatureNeeded = true;
            this._signatureAlgorithm = ((StringToken)this.signatureAlgorithm.getToken()).stringValue();
        } else if (attribute == this.provider) {
            this._updateSignatureNeeded = true;
            this._provider = ((StringToken)this.provider.getToken()).stringValue();
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this._updateSignature();
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._updateSignature();
    }

    private void _updateSignature() throws IllegalActionException {
        if (this._updateSignatureNeeded) {
            try {
                this._signature = this._provider.equalsIgnoreCase("SystemDefault") ? Signature.getInstance(this._signatureAlgorithm) : Signature.getInstance(this._signatureAlgorithm, this._provider);
            }
            catch (Throwable throwable) {
                throw new IllegalActionException((Nameable)this, throwable, "Failed to initialize Signature with algorithm: '" + this._signatureAlgorithm + "', provider: '" + this._provider + "'");
            }
            this._updateSignatureNeeded = false;
        }
    }
}

