/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.security;

import java.security.PrivateKey;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.security.KeyToken;
import ptolemy.actor.lib.security.SignatureActor;
import ptolemy.data.ArrayToken;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class SignatureSigner
extends SignatureActor {
    public TypedIOPort privateKey = new TypedIOPort(this, "privateKey", true, false);
    public TypedIOPort signature;
    private PrivateKey _privateKey = null;

    public SignatureSigner(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.privateKey.setTypeEquals(KeyToken.KEY);
        this.signature = new TypedIOPort(this, "signature", false, true);
        this.signature.setTypeEquals(new ArrayType(BaseType.UNSIGNED_BYTE));
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.privateKey.hasToken(0)) {
            KeyToken keyToken = (KeyToken)this.privateKey.get(0);
            this._privateKey = (PrivateKey)keyToken.getValue();
        }
        if (this.input.hasToken(0)) {
            try {
                byte[] dataBytes = ArrayToken.arrayTokenToUnsignedByteArray((ArrayToken)this.input.get(0));
                this._signature.initSign(this._privateKey);
                this._signature.update(dataBytes);
                this.output.send(0, ArrayToken.unsignedByteArrayToArrayToken(dataBytes));
                this.signature.send(0, ArrayToken.unsignedByteArrayToArrayToken(this._signature.sign()));
            }
            catch (Throwable throwable) {
                throw new IllegalActionException((Nameable)this, throwable, "Problem sending data");
            }
        }
    }
}

