/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.security;

import java.io.ByteArrayOutputStream;
import java.security.Key;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.security.CipherActor;
import ptolemy.actor.lib.security.KeyToken;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Settable;

public class SymmetricEncryption
extends CipherActor {
    public TypedIOPort key;

    public SymmetricEncryption(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.algorithm.setVisibility(Settable.NOT_EDITABLE);
        this.algorithm.setPersistent(false);
        this.algorithm.setVisibility(Settable.EXPERT);
        this.key = new TypedIOPort(this, "key", true, false);
        this.key.setTypeEquals(KeyToken.KEY);
        this.keySize.setVisibility(Settable.EXPERT);
    }

    @Override
    public void fire() throws IllegalActionException {
        if (this.key.hasToken(0)) {
            try {
                KeyToken keyToken = (KeyToken)this.key.get(0);
                Key securityKey = keyToken.getValue();
                if (!this._algorithm.equals(securityKey.getAlgorithm())) {
                    this._algorithm = securityKey.getAlgorithm();
                    this.algorithm.setExpression(this._algorithm);
                    this._updateCipherNeeded = true;
                    this._updateCipher();
                }
                this._cipher.init(1, securityKey);
            }
            catch (Exception ex) {
                throw new IllegalActionException((Nameable)this, ex, "Failed to initialize Cipher with algorithm: '" + this._algorithm + "', padding: '" + this._padding + "', provider: '" + this._provider + "'");
            }
        }
        super.fire();
    }

    @Override
    protected byte[] _process(byte[] dataBytes) throws IllegalActionException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this._cipher.doFinal(dataBytes));
        }
        catch (Exception ex) {
            throw new IllegalActionException((Nameable)this, ex, "Problem processing " + dataBytes.length + " bytes.");
        }
        return byteArrayOutputStream.toByteArray();
    }
}

