/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.string;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class StringReplace
extends TypedAtomicActor {
    public PortParameter stringToEdit;
    public TypedIOPort output;
    public PortParameter pattern = new PortParameter(this, "pattern");
    public Parameter replaceAll;
    public PortParameter replacement;
    private Pattern _pattern;

    public StringReplace(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.pattern.setStringMode(true);
        this.pattern.setExpression("");
        new SingletonParameter(this.pattern.getPort(), "_showName").setToken(BooleanToken.TRUE);
        this.replaceAll = new Parameter(this, "replaceAll");
        this.replaceAll.setExpression("true");
        this.replaceAll.setTypeEquals(BaseType.BOOLEAN);
        this.replacement = new PortParameter(this, "replacement");
        this.replacement.setStringMode(true);
        this.replacement.setExpression("");
        new SingletonParameter(this.replacement.getPort(), "_showName").setToken(BooleanToken.TRUE);
        this.stringToEdit = new PortParameter(this, "stringToEdit");
        this.stringToEdit.setStringMode(true);
        this.stringToEdit.setExpression("");
        new SingletonParameter(this.stringToEdit.getPort(), "_showName").setToken(BooleanToken.TRUE);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(BaseType.STRING);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.pattern) {
            try {
                String patternValue = ((StringToken)this.pattern.getToken()).stringValue();
                this._pattern = Pattern.compile(patternValue);
            }
            catch (PatternSyntaxException ex) {
                String patternValue = ((StringToken)this.pattern.getToken()).stringValue();
                throw new IllegalActionException((Nameable)this, ex, "Failed to compile regular expression \"" + patternValue + "\"");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.replacement.update();
        this.stringToEdit.update();
        this.pattern.update();
        String replacementValue = ((StringToken)this.replacement.getToken()).stringValue();
        String stringToEditValue = ((StringToken)this.stringToEdit.getToken()).stringValue();
        boolean replaceAllTokens = ((BooleanToken)this.replaceAll.getToken()).booleanValue();
        Matcher match = this._pattern.matcher(stringToEditValue);
        String outputString = replaceAllTokens ? match.replaceAll(replacementValue) : match.replaceFirst(replacementValue);
        this.output.send(0, new StringToken(outputString));
    }
}

