/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.vhdl.SynchronousFixTransformer;
import ptolemy.data.FixToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class AddSubtract
extends SynchronousFixTransformer {
    public TypedIOPort A = new TypedIOPort(this, "A", true, false);
    public TypedIOPort B;
    public Parameter operation;

    public AddSubtract(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.A.setTypeEquals(BaseType.FIX);
        this.B = new TypedIOPort(this, "B", true, false);
        this.B.setTypeEquals(BaseType.FIX);
        this.operation = new StringParameter(this, "operation");
        this.operation.setExpression("ADD");
        this.operation.addChoice("ADD");
        this.operation.addChoice("SUBTRACT");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        Token result = null;
        if (this.A.isKnown() && this.B.isKnown()) {
            Token tokenA = new FixToken();
            Token tokenB = new FixToken();
            if (this.A.hasToken(0)) {
                tokenA = this.A.get(0);
            }
            if (this.B.hasToken(0)) {
                tokenB = this.B.get(0);
            }
            result = this.operation.getExpression().endsWith("ADD") ? tokenA.add(tokenB) : tokenA.subtract(tokenB);
            this.sendOutput(this.output, 0, result);
        } else {
            this.output.resend(0);
        }
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.A, this.output);
        this.removeDependency(this.B, this.output);
    }
}

