/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.vhdl.SynchronousFixTransformer;
import ptolemy.data.FixToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.math.FixPoint;

public class IntegerCounter
extends SynchronousFixTransformer {
    public TypedIOPort enable = new TypedIOPort(this, "enable", true, false);
    public TypedIOPort reset;
    public Parameter width;
    public Parameter hasEnable;
    private int _previousCount = 0;
    private int _currentCount = 0;

    public IntegerCounter(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.enable.setTypeEquals(BaseType.FIX);
        this.reset = new TypedIOPort(this, "reset", true, false);
        this.reset.setTypeEquals(BaseType.FIX);
        this.width = new Parameter(this, "width");
        this.width.setTypeEquals(BaseType.INT);
        this.width.setExpression("4");
        this.hasEnable = new Parameter(this, "hasEnable");
        this.hasEnable.setTypeEquals(BaseType.BOOLEAN);
        this.hasEnable.setExpression("true");
        this._showQuantizationParameters(false, true, false);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.hasEnable) {
            try {
                if (this.hasEnable.getExpression().equals("true")) {
                    this.enable.setContainer(this);
                }
                this.enable.setContainer(null);
            }
            catch (NameDuplicationException ex) {
                throw new IllegalActionException((Nameable)this, ex, "Cannot set the container for the enable port");
            }
        } else if (attribute == this.width) {
            this._setQuantizationParameters("U" + this.width.getExpression() + ".0", null, null);
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.reset.isKnown() && (this.enable.getContainer() == null || this.enable.getContainer() != null && this.enable.isKnown())) {
            this._currentCount = this._previousCount;
            if (this.enable.getContainer() != null && this.enable.hasToken(0)) {
                FixToken enableToken = (FixToken)this.enable.get(0);
                this._checkFixTokenWidth(enableToken, 1);
                boolean enableValue = enableToken.fixValue().toBitString().equals("1");
                if (enableValue) {
                    ++this._currentCount;
                }
            } else if (this.enable.getContainer() == null) {
                ++this._currentCount;
            }
            if (this.reset.hasToken(0)) {
                FixToken resetToken = (FixToken)this.reset.get(0);
                this._checkFixTokenWidth(resetToken, 1);
                boolean resetValue = resetToken.fixValue().toBitString().equals("1");
                if (resetValue) {
                    this._currentCount = 0;
                }
            }
            FixPoint result = new FixPoint(this._currentCount);
            FixToken outputToken = new FixToken(result);
            this.sendOutput(this.output, 0, outputToken);
        } else {
            this.output.resend(0);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._previousCount = 0;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._previousCount = this._currentCount;
        return super.postfire();
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.enable, this.output);
        this.removeDependency(this.reset, this.output);
    }
}

