/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.parameters;

import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class DoubleRangeParameter
extends Parameter {
    public Parameter max;
    public Parameter min = new Parameter(this, "min");
    public Parameter precision;
    private boolean _inCheck = false;

    public DoubleRangeParameter(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.min.setExpression("0.0");
        this.min.setTypeEquals(BaseType.DOUBLE);
        this.max = new Parameter(this, "max");
        this.max.setExpression("1.0");
        this.max.setTypeEquals(BaseType.DOUBLE);
        this.precision = new Parameter(this, "precision");
        this.precision.setExpression("100");
        this.precision.setTypeEquals(BaseType.INT);
        this.setTypeEquals(BaseType.DOUBLE);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-2\" width=\"60\" height=\"4\" style=\"fill:white\"/>\n<rect x=\"15\" y=\"-10\" width=\"4\" height=\"20\" style=\"fill:grey\"/>\n</svg>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.max && !this._inCheck) {
            try {
                this._inCheck = true;
                double maxValue = ((DoubleToken)this.max.getToken()).doubleValue();
                double value = ((DoubleToken)this.getToken()).doubleValue();
                if (!(value > maxValue)) return;
                this.setToken(this.max.getToken());
                return;
            }
            finally {
                this._inCheck = false;
            }
        } else if (attribute == this.min && !this._inCheck) {
            try {
                this._inCheck = true;
                double minValue = ((DoubleToken)this.min.getToken()).doubleValue();
                double value = ((DoubleToken)this.getToken()).doubleValue();
                if (!(value < minValue)) return;
                this.setToken(this.min.getToken());
                return;
            }
            finally {
                this._inCheck = false;
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    protected void _setTokenAndNotify(Token newToken) throws IllegalActionException {
        if (this._inCheck) {
            super._setTokenAndNotify(newToken);
            return;
        }
        if (newToken instanceof DoubleToken) {
            try {
                this._inCheck = true;
                double minValue = ((DoubleToken)this.min.getToken()).doubleValue();
                double maxValue = ((DoubleToken)this.max.getToken()).doubleValue();
                double currentValue = ((DoubleToken)newToken).doubleValue();
                if (minValue <= currentValue && currentValue <= maxValue) {
                    super._setTokenAndNotify(newToken);
                    return;
                }
                throw new IllegalActionException((Nameable)this, "Value is required to lie between " + this.min + " and " + this.max + ".");
            }
            finally {
                this._inCheck = false;
            }
        }
        throw new IllegalActionException((Nameable)this, "Value is required to be a double token.");
    }
}

