/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.process;

import java.io.InterruptedIOException;
import ptolemy.actor.Actor;
import ptolemy.actor.FiringEvent;
import ptolemy.actor.FiringsRecordable;
import ptolemy.actor.Manager;
import ptolemy.actor.process.ProcessDirector;
import ptolemy.actor.process.TerminateProcessException;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.PtolemyThread;
import ptolemy.kernel.util.Workspace;

public class ProcessThread
extends PtolemyThread {
    private Actor _actor;
    private ProcessDirector _director;
    private Manager _manager;
    private String _name;

    public ProcessThread(Actor actor, ProcessDirector director) {
        this._actor = actor;
        this._director = director;
        this._manager = actor.getManager();
        if (this._actor instanceof NamedObj) {
            this._name = ((NamedObj)((Object)this._actor)).getFullName();
            this.addDebugListener((NamedObj)((Object)this._actor));
        } else {
            this._name = "Unnamed";
        }
        this.setName(this._name);
        this._director.addThread(this);
    }

    public Actor getActor() {
        return this._actor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object firingsRecordable;
        this._debug("-- Starting thread.");
        Workspace workspace = this._director.workspace();
        boolean iterate = true;
        Throwable thrownWhenIterate = null;
        IllegalActionException thrownWhenWrapup = null;
        try {
            this._actor.initialize();
            while (iterate) {
                if (this._director.isStopFireRequested()) {
                    this._debug("-- Thread pause requested. Get lock on director.");
                    ProcessDirector processDirector = this._director;
                    synchronized (processDirector) {
                        this._director.threadHasPaused(this);
                        while (this._director.isStopFireRequested()) {
                            if (this._director.isStopRequested()) {
                                this._debug("-- Thread stop requested, so cancel iteration.");
                                break;
                            }
                            this._debug("-- Thread waiting for canceled pause request.");
                            try {
                                workspace.wait(this._director);
                            }
                            catch (InterruptedException ex) {
                                this._debug("-- Thread interrupted, so cancel iteration.");
                                break;
                            }
                        }
                        this._director.threadHasResumed(this);
                    }
                    this._debug("-- Thread resuming.");
                }
                if (this._director.isStopRequested()) {
                    return;
                }
                firingsRecordable = null;
                if (((Entity)((Object)this._actor)).getContainer() == null) continue;
                if (this._actor instanceof FiringsRecordable) {
                    firingsRecordable = (FiringsRecordable)((Object)this._actor);
                }
                if (!this._actor.prefire()) continue;
                if (firingsRecordable != null) {
                    firingsRecordable.recordFiring(FiringEvent.BEFORE_FIRE);
                }
                this._actor.fire();
                if (firingsRecordable != null) {
                    firingsRecordable.recordFiring(FiringEvent.AFTER_FIRE);
                }
                iterate = this._actor.postfire();
            }
            return;
        }
        catch (Throwable t) {
            thrownWhenIterate = t;
            return;
        }
        finally {
            firingsRecordable = this._director;
            synchronized (firingsRecordable) {
                this._director.removeThread(this);
                try {
                    this.wrapup();
                }
                catch (IllegalActionException e) {
                    thrownWhenWrapup = e;
                }
                finally {
                    this._debug("-- Thread stopped.");
                    boolean rethrow = false;
                    if (thrownWhenIterate instanceof TerminateProcessException) {
                        this._debug("-- Blocked Receiver call threw TerminateProcessException.");
                    } else if (thrownWhenIterate instanceof InterruptedException) {
                        this._debug("-- Thread was interrupted: " + thrownWhenIterate);
                    } else if (thrownWhenIterate instanceof InterruptedIOException || thrownWhenIterate != null && thrownWhenIterate.getCause() instanceof InterruptedIOException) {
                        this._debug("-- IO was interrupted: " + thrownWhenIterate);
                    } else if (thrownWhenIterate instanceof IllegalActionException) {
                        this._debug("-- Exception: " + thrownWhenIterate);
                        this._manager.notifyListenersOfException((IllegalActionException)thrownWhenIterate);
                    } else if (thrownWhenIterate != null) {
                        rethrow = true;
                    }
                    if (thrownWhenWrapup instanceof IllegalActionException) {
                        this._debug("-- Exception: " + thrownWhenWrapup);
                        this._manager.notifyListenersOfException(thrownWhenWrapup);
                    } else if (thrownWhenWrapup != null) {
                        this._manager.notifyListenersOfThrowable(thrownWhenWrapup);
                    } else if (rethrow) {
                        this._manager.notifyListenersOfThrowable(thrownWhenIterate);
                    }
                }
            }
        }
    }

    public void wrapup() throws IllegalActionException {
        this._debug("-- Thread wrapup() called.");
        this._actor.wrapup();
    }
}

