/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.sched;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.IOPort;
import ptolemy.actor.sched.Firing;
import ptolemy.actor.sched.FixedPointDirector;
import ptolemy.actor.sched.NotSchedulableException;
import ptolemy.actor.sched.Schedule;
import ptolemy.actor.sched.Scheduler;
import ptolemy.actor.sched.StaticSchedulingDirector;
import ptolemy.actor.util.FunctionDependency;
import ptolemy.actor.util.FunctionDependencyOfCompositeActor;
import ptolemy.graph.DirectedAcyclicGraph;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class FixedPointScheduler
extends Scheduler {
    private Hashtable _actorToDepth = null;
    private Hashtable _portToDepth = null;

    public FixedPointScheduler(FixedPointDirector container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    protected Schedule _getSchedule() throws NotSchedulableException {
        boolean useOptimizedSchedule;
        StaticSchedulingDirector director = (StaticSchedulingDirector)this.getContainer();
        if (director == null) {
            throw new NotSchedulableException(this, "No director.  ");
        }
        CompositeActor compositeActor = (CompositeActor)director.getContainer();
        if (compositeActor == null) {
            throw new NotSchedulableException(this, "No container.");
        }
        FunctionDependencyOfCompositeActor functionDependency = (FunctionDependencyOfCompositeActor)compositeActor.getFunctionDependency();
        Object[] cycleNodes = functionDependency.getCycleNodes();
        if (cycleNodes.length != 0) {
            StringBuffer names = new StringBuffer();
            for (int i = 0; i < cycleNodes.length; ++i) {
                if (!(cycleNodes[i] instanceof Nameable)) continue;
                if (i > 0) {
                    names.append(", ");
                }
                names.append(((Nameable)cycleNodes[i]).getContainer().getFullName());
            }
            throw new NotSchedulableException(director, "There are dependency loops in the model:" + names.toString() + "\n" + " The results may contain unknowns.  This " + "scheduler cannot handle this model.");
        }
        DirectedAcyclicGraph dependencyGraph = functionDependency.getDetailedDependencyGraph().toDirectedAcyclicGraph();
        if (this._debugging) {
            this._debug("## dependency graph is:" + dependencyGraph.toString());
        }
        if (useOptimizedSchedule = false) {
            return this._constructSchedule(dependencyGraph);
        }
        return this._constructNaiveSchedule(dependencyGraph);
    }

    private void _computeActorDepth() {
        CompositeActor container = (CompositeActor)this.getContainer();
        LinkedList actors = (LinkedList)container.deepEntityList();
        actors.add(container);
        int numberOfActors = actors.size();
        this._actorToDepth = new Hashtable(numberOfActors);
        Iterator actorsIterator = actors.iterator();
        int defaultActorDepth = -numberOfActors;
        while (actorsIterator.hasNext()) {
            Actor actor = (Actor)actorsIterator.next();
            int depth = -1;
            for (IOPort inputPort : actor.inputPortList()) {
                int inputDepth = (Integer)this._portToDepth.get(inputPort);
                if (inputDepth >= depth && depth != -1) continue;
                depth = inputDepth;
            }
            for (IOPort outputPort : actor.outputPortList()) {
                int outputDepth = (Integer)this._portToDepth.get(outputPort);
                if (outputDepth >= depth && depth != -1) continue;
                depth = outputDepth;
            }
            if (depth == -1) {
                depth = defaultActorDepth;
            }
            this._actorToDepth.put(actor, depth);
            ++defaultActorDepth;
        }
    }

    private void _computePortDepth(DirectedAcyclicGraph dependencyGraph) {
        Actor portContainer;
        boolean verbose = false;
        Object[] sort = dependencyGraph.topologicalSort();
        int numberOfPorts = sort.length;
        if (this._debugging && verbose) {
            this._debug("## Result of topological sort (highest depth to lowest):");
        }
        this._portToDepth = new Hashtable(numberOfPorts);
        LinkedList<IOPort> ports = new LinkedList<IOPort>();
        for (int i = 0; i < numberOfPorts; ++i) {
            IOPort ioPort = (IOPort)sort[i];
            ports.add(ioPort);
            int depth = i;
            portContainer = (Actor)((Object)ioPort.getContainer());
            if (portContainer.equals(this.getContainer())) {
                depth = ioPort.isOutput() ? (depth += numberOfPorts) : (depth -= numberOfPorts);
            }
            this._portToDepth.put(ioPort, depth);
            if (!this._debugging || !verbose) continue;
            this._debug(ioPort.getFullName(), "depth: " + depth);
        }
        if (this._debugging && verbose) {
            this._debug("## adjusting port depths based on the strictness constraints.");
        }
        LinkedList<Actor> actorsWithPortDepthsAdjusted = new LinkedList<Actor>();
        for (int i = sort.length - 1; i >= 0; --i) {
            List inputPorts;
            IOPort ioPort = (IOPort)sort[i];
            portContainer = (Actor)((Object)ioPort.getContainer());
            if (portContainer.equals(this.getContainer())) continue;
            if (ioPort.isInput()) {
                boolean depthNeedsAdjusted = false;
                int numberOfOutputPorts = portContainer.outputPortList().size();
                if (numberOfOutputPorts == 0) {
                    depthNeedsAdjusted = true;
                }
                if (portContainer.isStrict()) {
                    depthNeedsAdjusted = true;
                }
                if (!depthNeedsAdjusted || (inputPorts = portContainer.inputPortList()).size() <= 1 || actorsWithPortDepthsAdjusted.contains(portContainer)) continue;
                actorsWithPortDepthsAdjusted.add(portContainer);
            } else {
                FunctionDependency functionDependency = portContainer.getFunctionDependency();
                inputPorts = functionDependency.getInputPortsDependentOn(ioPort);
            }
            Iterator inputsIterator = inputPorts.iterator();
            int maximumPortDepth = -1;
            while (inputsIterator.hasNext()) {
                Object object = inputsIterator.next();
                IOPort input = (IOPort)object;
                int inputPortDepth = ports.indexOf(input);
                if (maximumPortDepth >= inputPortDepth) continue;
                maximumPortDepth = inputPortDepth;
            }
            for (IOPort input : inputPorts) {
                if (this._debugging && verbose) {
                    this._debug(input.getFullName(), "depth is adjusted to: " + maximumPortDepth);
                }
                this._portToDepth.put(input, maximumPortDepth);
            }
        }
        if (this._debugging) {
            this._debug("## End of topological sort of ports.");
        }
    }

    private Schedule _constructNaiveSchedule(DirectedAcyclicGraph dependencyGraph) {
        Schedule schedule = new Schedule();
        Object[] sort = dependencyGraph.topologicalSort();
        if (this._debugging) {
            this._debug("## Schedule generated:");
        }
        Actor actor = null;
        Actor previouslySeenActor = null;
        for (int i = 0; i < sort.length; ++i) {
            IOPort ioPort = (IOPort)sort[i];
            if (ioPort.isInput() && ioPort.sourcePortList().size() == 0) continue;
            actor = (Actor)((Object)ioPort.getContainer());
            if (previouslySeenActor == actor) {
                if (ioPort.isOutput()) {
                    continue;
                }
            } else {
                previouslySeenActor = actor;
            }
            if (actor == this.getContainer().getContainer()) continue;
            Firing firing = new Firing(actor);
            schedule.add(firing);
            if (!this._debugging) continue;
            this._debug(actor.getFullName() + " scheduled at position: " + i);
        }
        if (this._debugging) {
            this._debug("## End of schedule.");
        }
        this.setValid(true);
        return schedule;
    }

    private Schedule _constructSchedule(DirectedAcyclicGraph dependencyGraph) {
        this._computePortDepth(dependencyGraph);
        this._computeActorDepth();
        Schedule schedule = new Schedule();
        Object[] sort = dependencyGraph.topologicalSort();
        if (this._debugging) {
            this._debug("## Schedule generated:");
        }
        Actor actor = null;
        for (int i = 0; i < sort.length; ++i) {
            IOPort ioPort = (IOPort)sort[i];
            if (!ioPort.isOutput() && ioPort.sourcePortList().size() == 0 || (actor = (Actor)((Object)ioPort.getContainer())) == this.getContainer().getContainer()) continue;
            Firing firing = new Firing(actor);
            schedule.add(firing);
            if (!this._debugging) continue;
            this._debug(actor.getFullName() + " scheduled at position: " + i);
        }
        if (this._debugging) {
            this._debug("## End of schedule.");
        }
        this.setValid(true);
        return schedule;
    }
}

