/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.BooleanToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.ShortToken;
import ptolemy.data.Token;
import ptolemy.data.TokenUtilities;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.data.unit.UnitUtilities;
import ptolemy.kernel.util.IllegalActionException;

public class FloatToken
extends ScalarToken {
    public static final FloatToken NIL = new FloatToken(Float.NaN);
    public static final FloatToken ONE = new FloatToken(1.0f);
    public static final FloatToken ZERO = new FloatToken(0.0f);
    private float _value;

    public FloatToken() {
        this._value = 0.0f;
    }

    public FloatToken(float value) {
        this._value = value;
    }

    public FloatToken(String init) throws IllegalActionException {
        if (init == null || init.equals("nil")) {
            throw new IllegalActionException(FloatToken.notSupportedNullNilStringMessage("FloatToken", init));
        }
        try {
            this._value = Float.parseFloat(init);
        }
        catch (NumberFormatException e) {
            throw new IllegalActionException(null, e, "Failed to parse \"" + init + "\" as a number.");
        }
    }

    public static FloatToken convert(Token token) throws IllegalActionException {
        if (token instanceof FloatToken) {
            return (FloatToken)token;
        }
        if (token.isNil()) {
            return NIL;
        }
        int compare = TypeLattice.compare((Type)BaseType.FLOAT, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(FloatToken.notSupportedIncomparableConversionMessage(token, "float"));
        }
        compare = TypeLattice.compare((Type)BaseType.SHORT, token);
        if (compare == 0 || compare == 1) {
            ShortToken shortToken = ShortToken.convert(token);
            FloatToken result = new FloatToken(shortToken.floatValue());
            if (shortToken._unitCategoryExponents != null && !UnitUtilities.isUnitless(shortToken._unitCategoryExponents)) {
                result._unitCategoryExponents = shortToken._copyOfCategoryExponents();
            }
            return result;
        }
        throw new IllegalActionException(FloatToken.notSupportedConversionMessage(token, "float"));
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (this.isNil() || ((FloatToken)object).isNil()) {
            return false;
        }
        return ((FloatToken)object).floatValue() == this._value;
    }

    @Override
    public float floatValue() {
        return this._value;
    }

    @Override
    public Type getType() {
        return BaseType.FLOAT;
    }

    public int hashCode() {
        return (int)this._value;
    }

    @Override
    public boolean isNil() {
        return this == NIL;
    }

    @Override
    public Token one() {
        return ONE;
    }

    @Override
    public String toString() {
        String unitString = "";
        if (!this._isUnitless()) {
            unitString = " * " + this.unitsString();
        }
        if (this.isNil()) {
            return super.toString();
        }
        if (Float.isNaN(this._value) || Float.isInfinite(this._value)) {
            return Float.toString(this._value) + "f" + unitString;
        }
        float mag = Math.abs(this._value);
        if (mag == 0.0f || mag < 1000000.0f && (double)mag > 0.001) {
            return TokenUtilities.regularFormat.format(this._value) + "f" + unitString;
        }
        return TokenUtilities.exponentialFormat.format(this._value) + "f" + unitString;
    }

    @Override
    public Token zero() {
        return ZERO;
    }

    @Override
    protected ScalarToken _absolute() {
        FloatToken result = this._value >= 0.0f ? this : new FloatToken(-this._value);
        return result;
    }

    @Override
    protected ScalarToken _add(ScalarToken rightArgument) {
        float sum = this._value + ((FloatToken)rightArgument).floatValue();
        return new FloatToken(sum);
    }

    @Override
    protected ScalarToken _bitwiseAnd(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(FloatToken.notSupportedMessage("bitwiseAnd", this, rightArgument));
    }

    @Override
    protected ScalarToken _bitwiseNot() throws IllegalActionException {
        throw new IllegalActionException(FloatToken.notSupportedMessage("bitwiseNot", this, this));
    }

    @Override
    protected ScalarToken _bitwiseOr(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(FloatToken.notSupportedMessage("bitwiseOr", this, rightArgument));
    }

    @Override
    protected ScalarToken _bitwiseXor(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(FloatToken.notSupportedMessage("bitwiseXor", this, rightArgument));
    }

    @Override
    protected ScalarToken _divide(ScalarToken divisor) {
        float quotient = this._value / ((FloatToken)divisor).floatValue();
        return new FloatToken(quotient);
    }

    @Override
    protected BooleanToken _isCloseTo(ScalarToken rightArgument, double epsilon) {
        double left;
        double right = ((FloatToken)rightArgument).doubleValue();
        if (right > (left = this.doubleValue()) + epsilon || right < left - epsilon) {
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    @Override
    protected BooleanToken _isLessThan(ScalarToken rightArgument) throws IllegalActionException {
        FloatToken convertedArgument = (FloatToken)rightArgument;
        return BooleanToken.getInstance(this._value < convertedArgument.floatValue());
    }

    @Override
    protected ScalarToken _modulo(ScalarToken rightArgument) {
        float remainder = this._value % ((FloatToken)rightArgument).floatValue();
        return new FloatToken(remainder);
    }

    @Override
    protected ScalarToken _multiply(ScalarToken rightArgument) {
        float product = this._value * ((FloatToken)rightArgument).floatValue();
        return new FloatToken(product);
    }

    @Override
    protected ScalarToken _subtract(ScalarToken rightArgument) {
        float difference = this._value - ((FloatToken)rightArgument).floatValue();
        return new FloatToken(difference);
    }
}

