/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.IntToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.math.Complex;
import ptolemy.math.ComplexMatrixMath;
import ptolemy.math.DoubleMatrixMath;
import ptolemy.math.IntegerArrayMath;
import ptolemy.math.IntegerMatrixMath;
import ptolemy.math.LongMatrixMath;

public class IntMatrixToken
extends MatrixToken {
    private int[] _value;
    private int _rowCount;
    private int _columnCount;

    public IntMatrixToken() {
        this._value = new int[1];
        this._value[0] = 0;
        this._rowCount = 1;
        this._columnCount = 1;
    }

    public IntMatrixToken(int[] value, int rows, int columns) throws IllegalActionException {
        this(value, rows, columns, 0);
    }

    public IntMatrixToken(int[] value, int rows, int columns, int copy) throws IllegalActionException {
        if (value == null) {
            throw new IllegalActionException("IntMatrixToken: The specified matrix is null.");
        }
        this._rowCount = rows;
        this._columnCount = columns;
        this._value = copy == 0 ? IntegerArrayMath.allocCopy(value) : value;
    }

    public IntMatrixToken(int[][] value) throws IllegalActionException {
        this(value, 0);
    }

    public IntMatrixToken(int[][] value, int copy) throws IllegalActionException {
        if (value == null) {
            throw new IllegalActionException("IntMatrixToken: The specified matrix is null.");
        }
        this._initialize(value);
    }

    public IntMatrixToken(String init) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode tree = parser.generateParseTree(init);
        Token token = new ParseTreeEvaluator().evaluateParseTree(tree);
        if (!(token instanceof IntMatrixToken)) {
            throw new IllegalActionException("A matrix token cannot be created from the expression '" + init + "'");
        }
        int[][] value = ((IntMatrixToken)token).intMatrix();
        this._initialize(value);
    }

    public IntMatrixToken(Token[] tokens, int rows, int columns) throws IllegalActionException {
        int elements = rows * columns;
        if (tokens == null) {
            throw new IllegalActionException("IntMatrixToken: The specified array is null.");
        }
        if (tokens.length != elements) {
            throw new IllegalActionException("IntMatrixToken: The specified array is not of the correct length");
        }
        this._rowCount = rows;
        this._columnCount = columns;
        this._value = new int[elements];
        for (int i = 0; i < elements; ++i) {
            Token token = tokens[i];
            if (!(token instanceof ScalarToken)) {
                throw new IllegalActionException("IntMatrixToken: Element " + i + " in the array with value " + token + " is not a ScalarToken");
            }
            this._value[i] = ((ScalarToken)token).intValue();
        }
    }

    @Override
    public Complex[][] complexMatrix() {
        return ComplexMatrixMath.toMatrixFromArray(IntegerArrayMath.toComplexArray(this._value), this._rowCount, this._columnCount);
    }

    public static IntMatrixToken convert(Token token) throws IllegalActionException {
        if (token instanceof IntMatrixToken) {
            return (IntMatrixToken)token;
        }
        int compare = TypeLattice.compare((Type)BaseType.INT_MATRIX, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(IntMatrixToken.notSupportedIncomparableConversionMessage(token, "[int]"));
        }
        throw new IllegalActionException(IntMatrixToken.notSupportedConversionMessage(token, "[int]"));
    }

    public static Token convert(ScalarToken token, int size) throws IllegalActionException {
        int compare = TypeLattice.compare((Type)BaseType.INT, (Token)token);
        if (compare == 0 || compare == 1) {
            if (token.isNil()) {
                throw new IllegalActionException(Token.notSupportedConversionMessage(token, "[int]"));
            }
            IntToken intToken = IntToken.convert(token);
            int intValue = intToken.intValue();
            int[] result = new int[size * size];
            for (int i = 0; i < size; ++i) {
                result[i] = intValue;
            }
            return new IntMatrixToken(result, size, size, 1);
        }
        throw new IllegalActionException(IntMatrixToken.notSupportedConversionMessage(token, "[int]"));
    }

    @Override
    public MatrixToken crop(int rowStart, int colStart, int rowSpan, int colSpan) throws IllegalActionException {
        int[][] value = this.intMatrix();
        try {
            int[][] result = IntegerMatrixMath.crop(value, rowStart, colStart, rowSpan, colSpan);
            return new IntMatrixToken(result);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalActionException("Matrix crop indices out of bounds (rowStart = " + rowStart + ", colStart = " + colStart + ", rowSpan = " + rowSpan + ", colSpan = " + colSpan + ").");
        }
    }

    @Override
    public double[][] doubleMatrix() {
        return DoubleMatrixMath.toMatrixFromArray(IntegerArrayMath.toDoubleArray(this._value), this._rowCount, this._columnCount);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        IntMatrixToken matrixArgument = (IntMatrixToken)object;
        if (this._rowCount != matrixArgument.getRowCount()) {
            return false;
        }
        if (this._columnCount != matrixArgument.getColumnCount()) {
            return false;
        }
        int[] value = matrixArgument._value;
        int elements = this._rowCount * this._columnCount;
        for (int i = 0; i < elements; ++i) {
            if (this._value[i] == value[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getColumnCount() {
        return this._columnCount;
    }

    @Override
    public Token getElementAsToken(int row, int column) throws ArrayIndexOutOfBoundsException {
        return new IntToken(this._value[row * this._columnCount + column]);
    }

    public int getElementAt(int row, int column) {
        return this._value[row * this._columnCount + column];
    }

    @Override
    public Type getElementType() {
        return BaseType.INT;
    }

    @Override
    public int getRowCount() {
        return this._rowCount;
    }

    @Override
    public Type getType() {
        return BaseType.INT_MATRIX;
    }

    public int hashCode() {
        int code = 0;
        int elements = this._rowCount * this._columnCount;
        for (int i = 0; i < elements; ++i) {
            code += this._value[i];
        }
        return code;
    }

    @Override
    public int[][] intMatrix() {
        return IntegerMatrixMath.toMatrixFromArray(this._value, this._rowCount, this._columnCount);
    }

    @Override
    public MatrixToken join(MatrixToken[][] matrices) throws IllegalActionException {
        if (matrices == null || matrices.length == 0 || matrices[0].length == 0) {
            throw new IllegalActionException("matrixJoin: No input matrices.");
        }
        int rows = 0;
        int columns = 0;
        for (int i = 0; i < matrices.length; ++i) {
            rows += matrices[i][0].getRowCount();
        }
        for (int j = 0; j < matrices[0].length; ++j) {
            columns += matrices[0][j].getColumnCount();
        }
        int[][] tiled = new int[rows][columns];
        int row = 0;
        for (int i = 0; i < matrices.length; ++i) {
            int column = 0;
            for (int j = 0; j < matrices[i].length; ++j) {
                int columnCount;
                if (!(matrices[i][j] instanceof IntMatrixToken)) {
                    throw new IllegalActionException("matrixJoin: matrices not all of the same type.");
                }
                int rowCount = matrices[i][j].getRowCount();
                if (row + rowCount > rows) {
                    rowCount = rows - row;
                }
                if (column + (columnCount = matrices[i][j].getColumnCount()) > columns) {
                    columnCount = columns - column;
                }
                IntegerMatrixMath.matrixCopy(matrices[i][j].intMatrix(), 0, 0, tiled, row, column, rowCount, columnCount);
                column += matrices[0][j].getColumnCount();
            }
            row += matrices[i][0].getRowCount();
        }
        return new IntMatrixToken(tiled);
    }

    @Override
    public long[][] longMatrix() {
        return LongMatrixMath.toMatrixFromArray(IntegerArrayMath.toLongArray(this._value), this._rowCount, this._columnCount);
    }

    @Override
    public Token one() {
        try {
            return new IntMatrixToken(IntegerMatrixMath.identity(this._rowCount), 1);
        }
        catch (IllegalActionException illegalAction) {
            throw new InternalErrorException("IntMatrixToken.one: Cannot create identity matrix.");
        }
    }

    @Override
    public Token oneRight() {
        try {
            return new IntMatrixToken(IntegerMatrixMath.identity(this._columnCount), 1);
        }
        catch (IllegalActionException illegalAction) {
            throw new InternalErrorException("IntMatrixToken.oneRight: Cannot create identity matrix.");
        }
    }

    @Override
    public MatrixToken[][] split(int[] rows, int[] columns) {
        MatrixToken[][] result = new MatrixToken[rows.length][columns.length];
        int[][] source = this.intMatrix();
        int row = 0;
        for (int i = 0; i < rows.length; ++i) {
            int column = 0;
            for (int j = 0; j < columns.length; ++j) {
                int columnspan;
                int[][] contents = new int[rows[i]][columns[j]];
                int rowspan = rows[i];
                if (row + rowspan > source.length) {
                    rowspan = source.length - row;
                }
                if (column + (columnspan = columns[j]) > source[0].length) {
                    columnspan = source[0].length - column;
                }
                if (columnspan > 0 && rowspan > 0) {
                    IntegerMatrixMath.matrixCopy(source, row, column, contents, 0, 0, rowspan, columnspan);
                }
                column += columns[j];
                try {
                    result[i][j] = new IntMatrixToken(contents);
                    continue;
                }
                catch (IllegalActionException e) {
                    throw new InternalErrorException(e);
                }
            }
            row += rows[i];
        }
        return result;
    }

    @Override
    public Token zero() {
        try {
            return new IntMatrixToken(new int[this._rowCount * this._columnCount], this._rowCount, this._columnCount, 1);
        }
        catch (IllegalActionException illegalAction) {
            throw new InternalErrorException("IntMatrixToken.zero: Cannot create zero matrix.");
        }
    }

    @Override
    protected MatrixToken _add(MatrixToken rightArgument) throws IllegalActionException {
        IntMatrixToken convertedArgument = (IntMatrixToken)rightArgument;
        int[] result = IntegerArrayMath.add(convertedArgument._getInternalIntArray(), this._value);
        return new IntMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    @Override
    protected MatrixToken _addElement(Token rightArgument) throws IllegalActionException {
        int scalar;
        if (rightArgument instanceof IntMatrixToken) {
            if (((IntMatrixToken)rightArgument).getRowCount() != 1 || ((IntMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((IntMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((IntToken)rightArgument).intValue();
        }
        int[] result = IntegerArrayMath.add(this._value, scalar);
        return new IntMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    @Override
    protected MatrixToken _divideElement(Token rightArgument) throws IllegalActionException {
        int scalar;
        if (rightArgument instanceof IntMatrixToken) {
            if (((IntMatrixToken)rightArgument).getRowCount() != 1 || ((IntMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((IntMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((IntToken)rightArgument).intValue();
        }
        int[] result = IntegerArrayMath.divide(this._value, scalar);
        return new IntMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected int[] _getInternalIntArray() {
        return this._value;
    }

    @Override
    protected MatrixToken _moduloElement(Token rightArgument) throws IllegalActionException {
        int scalar;
        if (rightArgument instanceof IntMatrixToken) {
            if (((IntMatrixToken)rightArgument).getRowCount() != 1 || ((IntMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((IntMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((IntToken)rightArgument).intValue();
        }
        int[] result = IntegerArrayMath.modulo(this._value, scalar);
        return new IntMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    @Override
    protected MatrixToken _multiply(MatrixToken rightArgument) throws IllegalActionException {
        IntMatrixToken convertedArgument = (IntMatrixToken)rightArgument;
        int[] A = this._value;
        int[] B = convertedArgument._getInternalIntArray();
        int m = this._rowCount;
        int n = this._columnCount;
        int p = convertedArgument.getColumnCount();
        int[] newMatrix = new int[m * p];
        int in = 0;
        int ta = 0;
        for (int i = 0; i < m; ++i) {
            ta += n;
            for (int j = 0; j < p; ++j) {
                int sum = 0;
                int ib = j;
                int ia = i * n;
                while (ia < ta) {
                    sum += A[ia] * B[ib];
                    ++ia;
                    ib += p;
                }
                newMatrix[in++] = sum;
            }
        }
        return new IntMatrixToken(newMatrix, m, p, 1);
    }

    @Override
    protected MatrixToken _multiplyElement(Token rightArgument) throws IllegalActionException {
        int scalar;
        if (rightArgument instanceof IntMatrixToken) {
            if (((IntMatrixToken)rightArgument).getRowCount() != 1 || ((IntMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((IntMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((IntToken)rightArgument).intValue();
        }
        int[] result = IntegerArrayMath.multiply(this._value, scalar);
        return new IntMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    @Override
    protected MatrixToken _subtract(MatrixToken rightArgument) throws IllegalActionException {
        IntMatrixToken convertedArgument = (IntMatrixToken)rightArgument;
        int[] result = IntegerArrayMath.subtract(this._value, convertedArgument._getInternalIntArray());
        return new IntMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    @Override
    protected MatrixToken _subtractElement(Token rightArgument) throws IllegalActionException {
        int scalar;
        if (rightArgument instanceof IntMatrixToken) {
            if (((IntMatrixToken)rightArgument).getRowCount() != 1 || ((IntMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((IntMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((IntToken)rightArgument).intValue();
        }
        int[] result = IntegerArrayMath.add(this._value, -scalar);
        return new IntMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    @Override
    protected MatrixToken _subtractElementReverse(Token rightArgument) throws IllegalActionException {
        int scalar;
        if (rightArgument instanceof IntMatrixToken) {
            if (((IntMatrixToken)rightArgument).getRowCount() != 1 || ((IntMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((IntMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((IntToken)rightArgument).intValue();
        }
        int[] result = IntegerArrayMath.negative(IntegerArrayMath.add(this._value, -scalar));
        return new IntMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    private void _initialize(int[][] value) {
        this._rowCount = value.length;
        this._columnCount = value[0].length;
        this._value = IntegerMatrixMath.fromMatrixToArray(value);
    }
}

