/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ptolemy.data.expr.ASTPtArrayConstructNode;
import ptolemy.data.expr.ASTPtBitwiseNode;
import ptolemy.data.expr.ASTPtFunctionApplicationNode;
import ptolemy.data.expr.ASTPtFunctionDefinitionNode;
import ptolemy.data.expr.ASTPtFunctionalIfNode;
import ptolemy.data.expr.ASTPtLeafNode;
import ptolemy.data.expr.ASTPtLogicalNode;
import ptolemy.data.expr.ASTPtMatrixConstructNode;
import ptolemy.data.expr.ASTPtMethodCallNode;
import ptolemy.data.expr.ASTPtPowerNode;
import ptolemy.data.expr.ASTPtProductNode;
import ptolemy.data.expr.ASTPtRecordConstructNode;
import ptolemy.data.expr.ASTPtRelationalNode;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ASTPtShiftNode;
import ptolemy.data.expr.ASTPtSumNode;
import ptolemy.data.expr.ASTPtUnaryNode;
import ptolemy.data.expr.AbstractParseTreeVisitor;
import ptolemy.data.expr.ModelScope;
import ptolemy.data.expr.ParserScope;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.util.IllegalActionException;

public class ParseTreeFreeVariableRenamer
extends AbstractParseTreeVisitor {
    protected Variable _dependentVariable;
    protected Set _formalParameters = new HashSet();
    protected String _name;
    protected ParserScope _scope;
    protected Variable _variableToRename;

    public void renameVariables(ASTPtRootNode node, Variable dependentVariable, Variable variableToRename, String name) throws IllegalActionException {
        this._scope = dependentVariable.getParserScope();
        this._dependentVariable = dependentVariable;
        this._variableToRename = variableToRename;
        this._name = name;
        node.visit(this);
        this._scope = null;
        this._variableToRename = null;
        this._name = null;
    }

    @Override
    public void visitArrayConstructNode(ASTPtArrayConstructNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitBitwiseNode(ASTPtBitwiseNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitFunctionApplicationNode(ASTPtFunctionApplicationNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitFunctionDefinitionNode(ASTPtFunctionDefinitionNode node) throws IllegalActionException {
        List arguments = node.getArgumentNameList();
        Collection alreadyFormal = this._intersection(this._formalParameters, arguments);
        this._formalParameters.addAll(arguments);
        node.getExpressionTree().visit(this);
        this._formalParameters.removeAll(arguments);
        this._formalParameters.addAll(alreadyFormal);
    }

    @Override
    public void visitFunctionalIfNode(ASTPtFunctionalIfNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitLeafNode(ASTPtLeafNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            return;
        }
        String name = node.getName();
        if (name != null && !this._formalParameters.contains(name) && ModelScope.getScopedVariable(null, this._dependentVariable, name) == this._variableToRename) {
            node._name = this._name;
        }
    }

    @Override
    public void visitLogicalNode(ASTPtLogicalNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitMatrixConstructNode(ASTPtMatrixConstructNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitMethodCallNode(ASTPtMethodCallNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitPowerNode(ASTPtPowerNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitProductNode(ASTPtProductNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitRecordConstructNode(ASTPtRecordConstructNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitRelationalNode(ASTPtRelationalNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitShiftNode(ASTPtShiftNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitSumNode(ASTPtSumNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitUnaryNode(ASTPtUnaryNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    protected Collection _intersection(Collection collection1, Collection collection2) {
        HashSet result = new HashSet();
        Iterator items = collection1.iterator();
        while (items.hasNext()) {
            Object item = items.next();
            if (!collection2.contains(item)) continue;
            result.add(items);
        }
        return result;
    }

    @Override
    protected void _visitAllChildren(ASTPtRootNode node) throws IllegalActionException {
        int numChildren = node.jjtGetNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            this._visitChild(node, i);
        }
    }

    @Override
    protected void _visitChild(ASTPtRootNode node, int i) throws IllegalActionException {
        ASTPtRootNode child = (ASTPtRootNode)node.jjtGetChild(i);
        child.visit(this);
    }
}

