/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtArrayConstructNode;
import ptolemy.data.expr.ASTPtBitwiseNode;
import ptolemy.data.expr.ASTPtFunctionApplicationNode;
import ptolemy.data.expr.ASTPtFunctionDefinitionNode;
import ptolemy.data.expr.ASTPtFunctionalIfNode;
import ptolemy.data.expr.ASTPtLeafNode;
import ptolemy.data.expr.ASTPtLogicalNode;
import ptolemy.data.expr.ASTPtMatrixConstructNode;
import ptolemy.data.expr.ASTPtMethodCallNode;
import ptolemy.data.expr.ASTPtPowerNode;
import ptolemy.data.expr.ASTPtProductNode;
import ptolemy.data.expr.ASTPtRecordConstructNode;
import ptolemy.data.expr.ASTPtRelationalNode;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ASTPtShiftNode;
import ptolemy.data.expr.ASTPtSumNode;
import ptolemy.data.expr.ASTPtUnaryNode;
import ptolemy.data.expr.AbstractParseTreeVisitor;
import ptolemy.data.expr.CachedMethod;
import ptolemy.data.expr.Constants;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.ParserScope;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.FixType;
import ptolemy.data.type.FunctionType;
import ptolemy.data.type.MatrixType;
import ptolemy.data.type.RecordType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeConstant;
import ptolemy.data.type.TypeLattice;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.math.Precision;

public class ParseTreeTypeInference
extends AbstractParseTreeVisitor {
    protected ParserScope _scope;
    protected Type _inferredChildType;

    public Type inferTypes(ASTPtRootNode node) throws IllegalActionException {
        node.visit(this);
        return this._inferredChildType;
    }

    public Type inferTypes(ASTPtRootNode node, ParserScope scope) throws IllegalActionException {
        this._scope = scope;
        node.visit(this);
        this._scope = null;
        return this._inferredChildType;
    }

    @Override
    public void visitArrayConstructNode(ASTPtArrayConstructNode node) throws IllegalActionException {
        Object[] childTypes = this._inferAllChildren(node);
        this._setType(node, new ArrayType((Type)TypeLattice.lattice().leastUpperBound(childTypes), childTypes.length));
    }

    @Override
    public void visitBitwiseNode(ASTPtBitwiseNode node) throws IllegalActionException {
        Object[] childTypes = this._inferAllChildren(node);
        this._setType(node, (Type)TypeLattice.lattice().leastUpperBound(childTypes));
    }

    @Override
    public void visitFunctionApplicationNode(ASTPtFunctionApplicationNode node) throws IllegalActionException {
        CachedMethod cachedMethod;
        int argCount = node.jjtGetNumChildren() - 1;
        String functionName = node.getFunctionName();
        Type[] childTypes = new Type[argCount];
        for (int i = 0; i < argCount; ++i) {
            childTypes[i] = this._inferChild(node, i + 1);
            if (childTypes[i] != null) continue;
            throw new RuntimeException("node " + node + " has null type.");
        }
        Type baseType = null;
        if (this._scope != null && functionName != null) {
            baseType = this._scope.getType(functionName);
        }
        if (baseType != null || functionName == null) {
            baseType = this._inferChild(node, 0);
            if (baseType instanceof FunctionType) {
                this._setType(node, ((FunctionType)baseType).getReturnType());
                return;
            }
            if (argCount == 1) {
                if (baseType instanceof ArrayType) {
                    this._setType(node, ((ArrayType)baseType).getElementType());
                    return;
                }
                this._assert(true, node, "Cannot use array indexing on '" + node.getFunctionName() + "' because it does not have an array type.");
            } else if (argCount == 2) {
                if (baseType instanceof MatrixType) {
                    this._setType(node, ((MatrixType)baseType).getElementType());
                    return;
                }
                this._assert(true, node, "Cannot use matrix indexing on '" + node.getFunctionName() + "' because it does not have a matrix type.");
            }
            throw new IllegalActionException("Wrong number of indices when referencing " + functionName);
        }
        if (functionName.compareTo("cast") == 0 && argCount == 2) {
            ASTPtRootNode castTypeNode = (ASTPtRootNode)node.jjtGetChild(1);
            ParseTreeEvaluator parseTreeEvaluator = new ParseTreeEvaluator();
            try {
                Token t = parseTreeEvaluator.evaluateParseTree(castTypeNode, this._scope);
                this._setType(node, t.getType());
            }
            catch (IllegalActionException ex) {
                this._setType(node, childTypes[0]);
            }
            return;
        }
        if (functionName.compareTo("fix") == 0 && argCount == 3) {
            ASTPtRootNode lengthNode = (ASTPtRootNode)node.jjtGetChild(2);
            ASTPtRootNode integerBitsNode = (ASTPtRootNode)node.jjtGetChild(3);
            ParseTreeEvaluator parseTreeEvaluator = new ParseTreeEvaluator();
            try {
                Token length = parseTreeEvaluator.evaluateParseTree(lengthNode, this._scope);
                Token integerBits = parseTreeEvaluator.evaluateParseTree(integerBitsNode, this._scope);
                this._setType(node, new FixType(new Precision(((ScalarToken)length).intValue(), ((ScalarToken)integerBits).intValue())));
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (functionName.compareTo("eval") == 0) {
            this._setType(node, BaseType.GENERAL);
            return;
        }
        if (functionName.compareTo("matlab") == 0) {
            this._setType(node, BaseType.GENERAL);
            return;
        }
        try {
            cachedMethod = CachedMethod.findMethod(functionName, childTypes, 8);
        }
        catch (Exception ex) {
            this._setType(node, BaseType.UNKNOWN);
            return;
        }
        if (!cachedMethod.isValid()) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < childTypes.length; ++i) {
                if (i == 0) {
                    buffer.append(((Object)childTypes[i]).toString());
                    continue;
                }
                buffer.append(", " + ((Object)childTypes[i]).toString());
            }
            throw new IllegalActionException("No matching function " + node.getFunctionName() + "( " + buffer + " ).");
        }
        Type type = cachedMethod.getReturnType();
        this._setType(node, type);
    }

    @Override
    public void visitFunctionDefinitionNode(ASTPtFunctionDefinitionNode node) throws IllegalActionException {
        ParserScope functionScope;
        final HashMap map = new HashMap();
        for (int i = 0; i < node._argTypes.length; ++i) {
            map.put(node.getArgumentNameList().get(i), node.getArgumentTypes()[i]);
        }
        final ParserScope currentScope = this._scope;
        this._scope = functionScope = new ParserScope(){

            @Override
            public Token get(String name) {
                return null;
            }

            @Override
            public Type getType(String name) throws IllegalActionException {
                Type type = (Type)map.get(name);
                if (type == null && currentScope != null) {
                    return currentScope.getType(name);
                }
                return type;
            }

            @Override
            public InequalityTerm getTypeTerm(String name) throws IllegalActionException {
                Type type = (Type)map.get(name);
                if (type == null && currentScope != null) {
                    return currentScope.getTypeTerm(name);
                }
                return new TypeConstant(type);
            }

            @Override
            public Set identifierSet() throws IllegalActionException {
                Set set = currentScope.identifierSet();
                set.addAll(map.keySet());
                return set;
            }
        };
        node.getExpressionTree().visit(this);
        Type returnType = this._inferredChildType;
        FunctionType type = new FunctionType(node._argTypes, returnType);
        this._setType(node, type);
        this._scope = currentScope;
    }

    @Override
    public void visitFunctionalIfNode(ASTPtFunctionalIfNode node) throws IllegalActionException {
        Type conditionalType = this._inferChild(node, 0);
        if (conditionalType != BaseType.BOOLEAN) {
            throw new IllegalActionException("Functional-if must branch on a boolean, but instead type was " + conditionalType);
        }
        Type trueType = this._inferChild(node, 1);
        Type falseType = this._inferChild(node, 2);
        this._setType(node, (Type)TypeLattice.lattice().leastUpperBound(trueType, falseType));
    }

    @Override
    public void visitLeafNode(ASTPtLeafNode node) throws IllegalActionException {
        Type type;
        if (node.isConstant() && node.isEvaluated()) {
            this._setType(node, node.getToken().getType());
            return;
        }
        String name = node.getName();
        if (this._scope != null && (type = this._scope.getType(name)) != null) {
            this._setType(node, type);
            return;
        }
        if (Constants.get(name) != null) {
            this._setType(node, Constants.get(name).getType());
            return;
        }
        throw new IllegalActionException("The ID " + name + " is undefined.");
    }

    @Override
    public void visitLogicalNode(ASTPtLogicalNode node) throws IllegalActionException {
        this._inferAllChildren(node);
        this._setType(node, BaseType.BOOLEAN);
    }

    @Override
    public void visitMatrixConstructNode(ASTPtMatrixConstructNode node) throws IllegalActionException {
        Object[] childTypes = this._inferAllChildren(node);
        Type elementType = (Type)TypeLattice.lattice().leastUpperBound(childTypes);
        MatrixType matrixType = MatrixType.getMatrixTypeForElementType(elementType);
        this._setType(node, matrixType);
    }

    @Override
    public void visitMethodCallNode(ASTPtMethodCallNode node) throws IllegalActionException {
        RecordType type;
        Type[] childTypes = this._inferAllChildren(node);
        if (childTypes.length == 1 && childTypes[0] instanceof RecordType && (type = (RecordType)childTypes[0]).labelSet().contains(node.getMethodName())) {
            this._setType(node, type.get(node.getMethodName()));
            return;
        }
        CachedMethod cachedMethod = CachedMethod.findMethod(node.getMethodName(), childTypes, 16);
        if (!cachedMethod.isValid()) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 1; i < childTypes.length; ++i) {
                if (i == 1) {
                    buffer.append(((Object)childTypes[i]).toString());
                    continue;
                }
                buffer.append(", " + ((Object)childTypes[i]).toString());
            }
            throw new IllegalActionException("No matching method " + ((Object)childTypes[0]).toString() + "." + node.getMethodName() + "( " + buffer + " ).");
        }
        Type type2 = cachedMethod.getReturnType();
        this._setType(node, type2);
    }

    @Override
    public void visitPowerNode(ASTPtPowerNode node) throws IllegalActionException {
        Type[] childTypes = this._inferAllChildren(node);
        Type baseType = childTypes[0];
        this._setType(node, baseType);
    }

    @Override
    public void visitProductNode(ASTPtProductNode node) throws IllegalActionException {
        Type[] childTypes = this._inferAllChildren(node);
        List lexicalTokenList = node.getLexicalTokenList();
        int numChildren = node.jjtGetNumChildren();
        Type resultType = childTypes[0];
        for (int i = 1; i < numChildren; ++i) {
            ptolemy.data.expr.Token operator = (ptolemy.data.expr.Token)lexicalTokenList.get(i - 1);
            Type nextType = childTypes[i];
            if (operator.kind == 12) {
                resultType = resultType.multiply(nextType);
                continue;
            }
            if (operator.kind == 13) {
                resultType = resultType.divide(nextType);
                continue;
            }
            if (operator.kind == 14) {
                resultType = resultType.modulo(nextType);
                continue;
            }
            this._assert(false, node, "Invalid operation");
        }
        this._setType(node, resultType);
    }

    @Override
    public void visitRecordConstructNode(ASTPtRecordConstructNode node) throws IllegalActionException {
        Type[] childTypes = this._inferAllChildren(node);
        String[] names = node.getFieldNames().toArray(new String[node.jjtGetNumChildren()]);
        this._setType(node, new RecordType(names, childTypes));
    }

    @Override
    public void visitRelationalNode(ASTPtRelationalNode node) throws IllegalActionException {
        this._inferAllChildren(node);
        this._setType(node, BaseType.BOOLEAN);
    }

    @Override
    public void visitShiftNode(ASTPtShiftNode node) throws IllegalActionException {
        Type[] childTypes = this._inferAllChildren(node);
        Type baseType = childTypes[0];
        this._setType(node, baseType);
    }

    @Override
    public void visitSumNode(ASTPtSumNode node) throws IllegalActionException {
        Type[] childTypes = this._inferAllChildren(node);
        List lexicalTokenList = node.getLexicalTokenList();
        int numChildren = node.jjtGetNumChildren();
        Type resultType = childTypes[0];
        for (int i = 1; i < numChildren; ++i) {
            ptolemy.data.expr.Token operator = (ptolemy.data.expr.Token)lexicalTokenList.get(i - 1);
            Type nextType = childTypes[i];
            if (operator.kind == 10) {
                resultType = resultType.add(nextType);
                continue;
            }
            if (operator.kind == 11) {
                resultType = resultType.subtract(nextType);
                continue;
            }
            this._assert(false, node, "Invalid operation");
        }
        this._setType(node, resultType);
    }

    @Override
    public void visitUnaryNode(ASTPtUnaryNode node) throws IllegalActionException {
        Type[] childTypes = this._inferAllChildren(node);
        Type baseType = childTypes[0];
        if (node.isMinus()) {
            this._setType(node, baseType.zero().subtract(baseType));
        } else {
            this._setType(node, baseType);
        }
    }

    protected void _assert(boolean flag, ASTPtRootNode node, String message) {
        if (!flag) {
            throw new InternalErrorException(message + ": " + node.toString());
        }
    }

    protected Type _getTypeForName(String name) throws IllegalActionException {
        Type type;
        if (this._scope != null && (type = this._scope.getType(name)) != null) {
            return type;
        }
        if (Constants.get(name) != null) {
            return Constants.get(name).getType();
        }
        throw new IllegalActionException("The ID " + name + " is undefined.");
    }

    protected Type[] _inferAllChildren(ASTPtRootNode node) throws IllegalActionException {
        Type[] types = new Type[node.jjtGetNumChildren()];
        int numChildren = node.jjtGetNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            this._inferChild(node, i);
            Type type = this._inferredChildType;
            if (type == null) {
                throw new RuntimeException("node " + node.jjtGetChild(i) + " has no type.");
            }
            types[i] = type;
        }
        return types;
    }

    protected Type _inferChild(ASTPtRootNode node, int i) throws IllegalActionException {
        ASTPtRootNode child = (ASTPtRootNode)node.jjtGetChild(i);
        child.visit(this);
        return this._inferredChildType;
    }

    protected boolean _isValidName(String name) throws IllegalActionException {
        if (this._scope != null) {
            try {
                return this._scope.getType(name) != null;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    protected void _setType(ASTPtRootNode node, Type type) {
        this._inferredChildType = type;
        node.setType(type);
    }
}

