/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.type;

import ptolemy.data.FunctionToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.StructuredType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;

public class FunctionType
extends StructuredType {
    private FieldTypeTerm[] _argTypeTerms;
    private FieldTypeTerm _returnTypeTerm;
    private static FunctionType _representative = new FunctionType(new Type[0], BaseType.UNKNOWN);

    public FunctionType(Type[] types, Type returnType) {
        this._argTypeTerms = new FieldTypeTerm[types.length];
        for (int i = 0; i < types.length; ++i) {
            FieldTypeTerm fieldType;
            this._argTypeTerms[i] = fieldType = new FieldTypeTerm(types[i]);
        }
        this._returnTypeTerm = new FieldTypeTerm(returnType);
    }

    @Override
    public Object clone() {
        if (this.isConstant()) {
            return this;
        }
        Type[] types = new Type[this._argTypeTerms.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.getArgType(i);
        }
        FunctionType newObj = new FunctionType(types, this.getReturnType());
        try {
            newObj.updateType(this);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(null, (Throwable)ex, "Failed to update new instance.");
        }
        return newObj;
    }

    @Override
    public Token convert(Token token) throws IllegalActionException {
        if (!this.isCompatible(token.getType())) {
            throw new IllegalArgumentException(Token.notSupportedConversionMessage(token, this.toString()));
        }
        return token;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FunctionType)) {
            return false;
        }
        FunctionType functionType = (FunctionType)object;
        if (this.getArgCount() != functionType.getArgCount()) {
            return false;
        }
        for (int i = 0; i < this.getArgCount(); ++i) {
            Type argType;
            Type myType = this.getArgType(i);
            if (((Object)myType).equals(argType = functionType.getArgType(i))) continue;
            return false;
        }
        return ((Object)this.getReturnType()).equals(functionType.getReturnType());
    }

    public int getArgCount() {
        return this._argTypeTerms.length;
    }

    public Type getArgType(int i) {
        if (i < 0 || i >= this._argTypeTerms.length) {
            return null;
        }
        FieldTypeTerm fieldType = this._argTypeTerms[i];
        if (fieldType == null) {
            return null;
        }
        return fieldType._resolvedType;
    }

    public Type getReturnType() {
        return this._returnTypeTerm._resolvedType;
    }

    @Override
    public Class getTokenClass() {
        return FunctionToken.class;
    }

    public FieldTypeTerm getArgTypeTerm(int i) {
        return this._argTypeTerms[i];
    }

    public int hashCode() {
        return this._returnTypeTerm.hashCode() + 1;
    }

    @Override
    public void initialize(Type type) {
        try {
            for (int i = 0; i < this.getArgCount(); ++i) {
                FieldTypeTerm fieldType = this.getArgTypeTerm(i);
                if (!fieldType.isSettable()) continue;
                fieldType.initialize(type);
            }
        }
        catch (IllegalActionException iae) {
            throw new InternalErrorException("FunctionType.initialize: Cannot initialize the element type to " + type + " " + iae.getMessage());
        }
    }

    @Override
    public boolean isAbstract() {
        return !this.isInstantiable();
    }

    @Override
    public boolean isCompatible(Type type) {
        if (((Object)type).equals(BaseType.UNKNOWN)) {
            return true;
        }
        if (!(type instanceof FunctionType)) {
            return false;
        }
        FunctionType argumentFunctionType = (FunctionType)type;
        if (argumentFunctionType.getArgCount() != this.getArgCount()) {
            return false;
        }
        for (int i = 0; i < this.getArgCount(); ++i) {
            Type thisFieldTypeTerm;
            Type argumentFieldTypeTerm = argumentFunctionType.getArgType(i);
            if (argumentFieldTypeTerm.isCompatible(thisFieldTypeTerm = this.getArgType(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConstant() {
        for (int i = 0; i < this.getArgCount(); ++i) {
            FieldTypeTerm fieldType = this.getArgTypeTerm(i);
            Type type = fieldType._declaredType;
            if (type.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInstantiable() {
        for (int i = 0; i < this.getArgCount(); ++i) {
            Type type = this.getArgType(i);
            if (type.isInstantiable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubstitutionInstance(Type type) {
        if (!(type instanceof FunctionType)) {
            return false;
        }
        FunctionType functionType = (FunctionType)type;
        int argCount = this.getArgCount();
        if (functionType.getArgCount() != argCount) {
            return false;
        }
        for (int i = 0; i < this.getArgCount(); ++i) {
            Type argType;
            Type myArgType = this.getArgType(i);
            if (myArgType.isSubstitutionInstance(argType = functionType.getArgType(i))) continue;
            return false;
        }
        return this.getReturnType().isSubstitutionInstance(functionType.getReturnType());
    }

    @Override
    public String toString() {
        StringBuffer results = new StringBuffer("(function(");
        for (int i = 0; i < this.getArgCount(); ++i) {
            if (i != 0) {
                results.append(", ");
            }
            results.append("a" + i + ":" + this.getArgType(i));
        }
        return results.toString() + ") " + this.getReturnType() + ")";
    }

    @Override
    public void updateType(StructuredType newType) throws IllegalActionException {
        if (this.isConstant()) {
            if (this.equals(newType)) {
                return;
            }
            throw new IllegalActionException("FunctionType.updateType: This type is a constant and the argument is not the same as this type. This type: " + this.toString() + " argument: " + newType.toString());
        }
        if (!this.isSubstitutionInstance(newType)) {
            throw new IllegalActionException("FunctionType.updateType: Cannot update this type to the new type.");
        }
        for (int i = 0; i < this.getArgCount(); ++i) {
            FieldTypeTerm argTypeTerm = this.getArgTypeTerm(i);
            if (!argTypeTerm.isSettable()) continue;
            Type newArgType = ((FunctionType)newType).getArgType(i);
            argTypeTerm.setValue(newArgType);
        }
        if (this._returnTypeTerm.isSettable()) {
            this._returnTypeTerm.setValue(((FunctionType)newType).getReturnType());
        }
    }

    @Override
    protected int _compare(StructuredType type) {
        if (!(type instanceof FunctionType)) {
            throw new IllegalArgumentException("FunctionType.compare: The argument is not a FunctionType.");
        }
        if (this.equals(type)) {
            return 0;
        }
        if (this._isLessThanOrEqualTo(this, (FunctionType)type)) {
            return -1;
        }
        if (this._isLessThanOrEqualTo((FunctionType)type, this)) {
            return 1;
        }
        return 2;
    }

    @Override
    protected StructuredType _getRepresentative() {
        return _representative;
    }

    @Override
    protected StructuredType _greatestLowerBound(StructuredType type) {
        if (!(type instanceof FunctionType)) {
            throw new IllegalArgumentException("FunctionType.greatestLowerBound: The argument is not a FunctionType.");
        }
        FunctionType functionType = (FunctionType)type;
        int argCount = this.getArgCount();
        if (functionType.getArgCount() != argCount) {
            throw new IllegalArgumentException("Types are not comparable because they have different numbers of arguments");
        }
        Type[] types = new Type[argCount];
        for (int i = 0; i < argCount; ++i) {
            Type type1 = this.getArgType(i);
            Type type2 = functionType.getArgType(i);
            types[i] = type1 == null ? type2 : (type2 == null ? type1 : (Type)TypeLattice.lattice().greatestLowerBound(type1, type2));
        }
        Type returnType = (Type)TypeLattice.lattice().greatestLowerBound(this.getReturnType(), functionType.getReturnType());
        return new FunctionType(types, returnType);
    }

    @Override
    protected StructuredType _leastUpperBound(StructuredType type) {
        if (!(type instanceof FunctionType)) {
            throw new IllegalArgumentException("FunctionType.leastUpperBound: The argument is not a FunctionType.");
        }
        FunctionType functionType = (FunctionType)type;
        int argCount = this.getArgCount();
        if (functionType.getArgCount() != argCount) {
            throw new IllegalArgumentException("Types are not comparable because they have different numbers of arguments");
        }
        Type[] types = new Type[argCount];
        for (int i = 0; i < argCount; ++i) {
            Type type1 = this.getArgType(i);
            Type type2 = functionType.getArgType(i);
            types[i] = type1 == null ? type2 : (type2 == null ? type1 : (Type)TypeLattice.lattice().leastUpperBound(type1, type2));
        }
        Type returnType = (Type)TypeLattice.lattice().leastUpperBound(this.getReturnType(), functionType.getReturnType());
        return new FunctionType(types, returnType);
    }

    private boolean _isLessThanOrEqualTo(FunctionType t1, FunctionType t2) {
        int argCount = t1.getArgCount();
        if (t2.getArgCount() != argCount) {
            return false;
        }
        for (int i = 0; i < argCount; ++i) {
            Type type2;
            Type type1 = t1.getArgType(i);
            int result = TypeLattice.compare(type1, type2 = t2.getArgType(i));
            if (result != 1 && result != 2) continue;
            return false;
        }
        return true;
    }

    private class FieldTypeTerm
    implements InequalityTerm {
        private Type _declaredType = null;
        private Type _resolvedType = null;

        private FieldTypeTerm(Type declaredType) {
            try {
                this._resolvedType = this._declaredType = (Type)declaredType.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new InternalErrorException("FunctionType.FieldTypeTerm: The specified type cannot be cloned.");
            }
        }

        @Override
        public Object getAssociatedObject() {
            return FunctionType.this;
        }

        @Override
        public Object getValue() {
            return this._resolvedType;
        }

        @Override
        public InequalityTerm[] getVariables() {
            if (this.isSettable()) {
                InequalityTerm[] variable = new InequalityTerm[]{this};
                return variable;
            }
            return new InequalityTerm[0];
        }

        @Override
        public void initialize(Object e) throws IllegalActionException {
            if (!this.isSettable()) {
                throw new IllegalActionException("FunctionType$FieldTypeTerm.initialize: The type is not settable.");
            }
            if (!(e instanceof Type)) {
                throw new IllegalActionException("FieldTypeTerm.initialize: The argument is not a Type.");
            }
            if (this._declaredType == BaseType.UNKNOWN) {
                this._resolvedType = (Type)e;
            } else {
                ((StructuredType)this._resolvedType).initialize((Type)e);
            }
        }

        @Override
        public boolean isSettable() {
            return !this._declaredType.isConstant();
        }

        @Override
        public boolean isValueAcceptable() {
            return this._resolvedType.isInstantiable();
        }

        @Override
        public void setValue(Object e) throws IllegalActionException {
            if (!this.isSettable()) {
                throw new IllegalActionException("FunctionType$FieldTypeTerm.setValue: The type is not settable.");
            }
            if (!this._declaredType.isSubstitutionInstance((Type)e)) {
                throw new IllegalActionException("FieldTypeTerm.setValue: Cannot update the field type of this FunctionType to the new type. Field type: " + ((Object)this._declaredType).toString() + ", New type: " + e.toString());
            }
            if (this._declaredType == BaseType.UNKNOWN) {
                try {
                    this._resolvedType = (Type)((Type)e).clone();
                }
                catch (CloneNotSupportedException cnse) {
                    throw new InternalErrorException("FunctionType$FieldTypeTerm.setValue: The specified type cannot be cloned.");
                }
            } else {
                ((StructuredType)this._resolvedType).updateType((StructuredType)e);
            }
        }

        public String toString() {
            return "(FunctionFieldTypeTerm, " + this.getValue() + ")";
        }
    }
}

