/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.kernel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.Receiver;
import ptolemy.actor.StateReceiver;
import ptolemy.actor.lib.SequenceActor;
import ptolemy.actor.sched.Firing;
import ptolemy.actor.sched.NotSchedulableException;
import ptolemy.actor.sched.Schedule;
import ptolemy.actor.sched.Scheduler;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.domains.ct.kernel.CTCompositeActor;
import ptolemy.domains.ct.kernel.CTDynamicActor;
import ptolemy.domains.ct.kernel.CTEventGenerator;
import ptolemy.domains.ct.kernel.CTReceiver;
import ptolemy.domains.ct.kernel.CTSchedule;
import ptolemy.domains.ct.kernel.CTStatefulActor;
import ptolemy.domains.ct.kernel.CTStepSizeControlActor;
import ptolemy.domains.ct.kernel.CTWaveformGenerator;
import ptolemy.graph.DirectedAcyclicGraph;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class CTScheduler
extends Scheduler {
    public static final CTReceiver.SignalType CONTINUOUS = CTReceiver.CONTINUOUS;
    public static final CTReceiver.SignalType DISCRETE = CTReceiver.DISCRETE;
    public static final CTReceiver.SignalType UNKNOWN = CTReceiver.UNKNOWN;
    private static final String _STATIC_NAME = "CTScheduler";
    private SignalTypeMap _signalTypeMap;

    public CTScheduler() {
        this((Workspace)null);
    }

    public CTScheduler(Workspace workspace) {
        super(workspace);
        try {
            this.setName(_STATIC_NAME);
        }
        catch (KernelException ex) {
            throw new InternalErrorException("Internal error when setting name to a CTScheduler");
        }
    }

    public boolean isContinuous(Actor actor) throws IllegalActionException {
        if (this._signalTypeMap == null) {
            throw new IllegalActionException((Nameable)this, " isContinuous() can only be called after initialization.");
        }
        LinkedList continuousActors = this._signalTypeMap.getContinuousActors();
        return continuousActors.contains(actor);
    }

    public boolean isDiscrete(Actor actor) throws IllegalActionException {
        if (this._signalTypeMap == null) {
            throw new IllegalActionException((Nameable)this, " isDiscrete() can only be called after initialization.");
        }
        LinkedList discreteActors = this._signalTypeMap.getDiscreteActors();
        return discreteActors.contains(actor);
    }

    public List predecessorList(Actor actor) {
        if (actor == null) {
            return null;
        }
        LinkedList<Actor> predecessors = new LinkedList<Actor>();
        for (IOPort port : actor.inputPortList()) {
            for (IOPort outPort : port.deepConnectedOutPortList()) {
                Actor pre = (Actor)((Object)outPort.getContainer());
                if (actor.getExecutiveDirector() != pre.getExecutiveDirector() || predecessors.contains(pre)) continue;
                predecessors.addLast(pre);
            }
        }
        return predecessors;
    }

    public String signalTypeToString(CTReceiver.SignalType signalType) {
        if (signalType == CONTINUOUS) {
            return "CONTINUOUS";
        }
        if (signalType == DISCRETE) {
            return "DISCRETE";
        }
        if (signalType == UNKNOWN) {
            return "UNKNOWN";
        }
        return "An INVALID signaltype: " + signalType + ".";
    }

    public List successorList(Actor actor) {
        if (actor == null) {
            return null;
        }
        LinkedList<Actor> successors = new LinkedList<Actor>();
        for (IOPort outPort : actor.outputPortList()) {
            for (IOPort inPort : outPort.deepConnectedInPortList()) {
                Actor post = (Actor)((Object)inPort.getContainer());
                if (actor.getExecutiveDirector() != post.getExecutiveDirector() || successors.contains(post)) continue;
                successors.addLast(post);
            }
        }
        return successors;
    }

    @Override
    public String toString() {
        return this.getFullName();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Schedule _getSchedule() throws NotSchedulableException, IllegalActionException {
        CTSchedule ctSchedule = new CTSchedule();
        this._signalTypeMap = new SignalTypeMap();
        LinkedList continuousActors = new LinkedList();
        LinkedList discreteActors = new LinkedList();
        LinkedList<Actor> dynamicActors = new LinkedList<Actor>();
        LinkedList<Actor> stateTransitionActors = new LinkedList<Actor>();
        LinkedList<Actor> arithmeticActors = new LinkedList<Actor>();
        LinkedList sinkActors = new LinkedList();
        LinkedList<Actor> eventGenerators = new LinkedList<Actor>();
        LinkedList<Actor> waveformGenerators = new LinkedList<Actor>();
        LinkedList<Actor> ctSubsystems = new LinkedList<Actor>();
        LinkedList<Actor> nonCTSubsystems = new LinkedList<Actor>();
        Schedule continuousActorSchedule = new Schedule();
        Schedule discreteActorSchedule = new Schedule();
        Schedule dynamicActorSchedule = new Schedule();
        Schedule eventGeneratorSchedule = new Schedule();
        Schedule outputSchedule = new Schedule();
        Schedule outputSSCActorSchedule = new Schedule();
        Schedule statefulActorSchedule = new Schedule();
        Schedule stateSSCActorSchedule = new Schedule();
        Schedule stateTransitionSchedule = new Schedule();
        Schedule waveformGeneratorSchedule = new Schedule();
        CompositeActor container = (CompositeActor)this.getContainer().getContainer();
        boolean isCTCompositeActor = container instanceof CTCompositeActor;
        for (IOPort inPort : container.inputPortList()) {
            if (!isCTCompositeActor) {
                Receiver[][] localReceivers = inPort.getReceivers();
                try {
                    Receiver localReceiver = localReceivers[0][0];
                    if (localReceiver instanceof StateReceiver) {
                        this._signalTypeMap.setType(inPort, CONTINUOUS);
                    }
                    this._signalTypeMap.setType(inPort, DISCRETE);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new IllegalActionException((Nameable)this, ex, "The container \"" + container.getFullName() + "\" is a \"" + container.getClass().getName() + "\", which is not a CT Composite actor, yet " + "the port \"" + inPort.getFullName() + "\" appears to have no receivers?  " + "Perhaps the port is not connected?");
                }
            } else {
                Parameter signalType = (Parameter)inPort.getAttribute("signalType");
                if (signalType != null) {
                    String type = ((StringToken)signalType.getToken()).stringValue();
                    if ((type = type.trim().toUpperCase()).equals("CONTINUOUS")) {
                        this._signalTypeMap.setType(inPort, CONTINUOUS);
                    } else {
                        if (!type.equals("DISCRETE")) throw new IllegalActionException((Nameable)inPort, "Unrecognized signal type. It should be a string of either \"CONTINUOUS\" or \"DISCRETE\".");
                        this._signalTypeMap.setType(inPort, DISCRETE);
                    }
                } else {
                    this._signalTypeMap.setType(inPort, CONTINUOUS);
                }
            }
            this._signalTypeMap.propagateTypeInside(inPort);
        }
        for (Actor a : container.deepEntityList()) {
            if (this._debugging & this._verbose) {
                this._debug("Examine " + a.getFullName() + " for signal types.");
            }
            if (a instanceof CompositeActor) {
                if (a instanceof CTCompositeActor) {
                    if (((CTCompositeActor)a).containsDynamicActors()) {
                        dynamicActors.add(a);
                    }
                    arithmeticActors.add(a);
                    ctSubsystems.add(a);
                    statefulActorSchedule.add(new Firing(a));
                    if (((CTCompositeActor)a).containsWaveformGenerators()) {
                        waveformGenerators.add(a);
                    }
                    eventGenerators.add(a);
                } else {
                    nonCTSubsystems.add(a);
                }
            } else {
                if (a instanceof CTStatefulActor) {
                    statefulActorSchedule.add(new Firing(a));
                }
                if (a instanceof CTWaveformGenerator) {
                    waveformGenerators.add(a);
                } else if (a instanceof CTEventGenerator) {
                    eventGenerators.add(a);
                } else if (a instanceof CTDynamicActor) {
                    dynamicActors.add(a);
                } else {
                    arithmeticActors.add(a);
                }
            }
            if (a instanceof SequenceActor) {
                if (this.predecessorList(a).isEmpty()) {
                    throw new NotSchedulableException(a.getName() + " is a SequenceActor, which cannot be a" + " source actor in the CT domain.");
                }
                for (IOPort port : ((Entity)((Object)a)).portList()) {
                    this._signalTypeMap.setType(port, DISCRETE);
                    if (!port.isOutput()) continue;
                    this._signalTypeMap.propagateType(port);
                }
                continue;
            }
            if (a instanceof CompositeActor && !(a instanceof CTCompositeActor)) {
                for (IOPort port : ((Entity)((Object)a)).portList()) {
                    if (!port.isOutput()) continue;
                    Receiver[][] insideReceivers = port.getInsideReceivers();
                    if (insideReceivers.length > 0 && insideReceivers[0] != null && insideReceivers[0].length > 0) {
                        Receiver receiver = insideReceivers[0][0];
                        if (receiver instanceof StateReceiver) {
                            this._signalTypeMap.setType(port, CONTINUOUS);
                        } else {
                            this._signalTypeMap.setType(port, DISCRETE);
                        }
                    } else {
                        this._signalTypeMap.setType(port, CONTINUOUS);
                    }
                    this._signalTypeMap.propagateType(port);
                }
                continue;
            }
            for (IOPort port : ((Entity)((Object)a)).portList()) {
                Parameter signalType = (Parameter)port.getAttribute("signalType");
                if (signalType != null) {
                    String string2 = ((StringToken)signalType.getToken()).stringValue();
                    string2 = string2.trim().toUpperCase();
                    if (string2.equals("CONTINUOUS")) {
                        this._signalTypeMap.setType(port, CONTINUOUS);
                        if (!port.isOutput()) continue;
                        this._signalTypeMap.propagateType(port);
                        continue;
                    }
                    if (!string2.equals("DISCRETE")) throw new InvalidStateException(port, " signalType not understandable.");
                    this._signalTypeMap.setType(port, DISCRETE);
                    if (!port.isOutput()) continue;
                    this._signalTypeMap.propagateType(port);
                    continue;
                }
                if (!(a instanceof CTCompositeActor)) continue;
                if (this._signalTypeMap.getType(port) == UNKNOWN) {
                    this._signalTypeMap.setType(port, CONTINUOUS);
                }
                if (!port.isOutput()) continue;
                this._signalTypeMap.propagateType(port);
            }
            if (!this.predecessorList(a).isEmpty()) continue;
            for (IOPort port : ((Entity)((Object)a)).portList()) {
                if (this._signalTypeMap.getType(port) != UNKNOWN) continue;
                this._signalTypeMap.setType(port, CONTINUOUS);
                if (!port.isOutput()) continue;
                this._signalTypeMap.propagateType(port);
            }
        }
        DirectedAcyclicGraph arithmeticGraph = this._toGraph(arithmeticActors);
        if (!arithmeticGraph.isAcyclic()) {
            void var30_38;
            Object[] cycleNodes = arithmeticGraph.cycleNodes();
            LinkedList<Object> nodesAsList = new LinkedList<Object>();
            StringBuffer inCycle = new StringBuffer("Cycle includes: ");
            boolean bl = false;
            while (var30_38 < cycleNodes.length) {
                inCycle.append(((NamedObj)cycleNodes[var30_38]).getFullName());
                if (var30_38 < cycleNodes.length - 1) {
                    inCycle.append(", ");
                }
                nodesAsList.add(cycleNodes[var30_38]);
                ++var30_38;
            }
            throw new NotSchedulableException(nodesAsList, null, "Algebraic loop. " + inCycle.toString());
        }
        DirectedAcyclicGraph dynamicGraph = this._toGraph(dynamicActors);
        if (!dynamicGraph.isAcyclic()) {
            throw new NotSchedulableException("Loops of dynamic actors (e.g. integrators) are not allowed in the CT domain. You may insert a Scale actor with factor 1.");
        }
        Object[] sortedArithmeticActors = arithmeticGraph.topologicalSort();
        for (int i = 0; i < sortedArithmeticActors.length; ++i) {
            Actor actor = (Actor)sortedArithmeticActors[i];
            Iterator inputPorts = actor.inputPortList().iterator();
            CTReceiver.SignalType knownInputType = UNKNOWN;
            boolean needManuallySetType = true;
            while (inputPorts.hasNext()) {
                IOPort inputPort = (IOPort)inputPorts.next();
                if (inputPort.getWidth() == 0) continue;
                CTReceiver.SignalType inputType = this._signalTypeMap.getType(inputPort);
                if (inputType == UNKNOWN) {
                    throw new NotSchedulableException("Cannot resolve signal type for port " + inputPort.getFullName() + ". If you are certain about the signal type" + ", you can set them manually.\n" + " To do this, you can add a parameter " + "called 'signalType' with value " + "'\"CONTINUOUS\"' or '\"DISCRETE\"'" + " to a port.");
                }
                if (knownInputType == UNKNOWN) {
                    knownInputType = inputType;
                    needManuallySetType = false;
                    continue;
                }
                if (knownInputType == inputType) continue;
                needManuallySetType = true;
                break;
            }
            for (IOPort outputPort : actor.outputPortList()) {
                if (outputPort.getWidth() == 0) continue;
                CTReceiver.SignalType outputType = this._signalTypeMap.getType(outputPort);
                if (outputType == UNKNOWN) {
                    if (needManuallySetType) {
                        throw new NotSchedulableException("Cannot resolve signal type for port " + outputPort.getFullName() + ".\n To set the signal type manually, " + "add a parameter with name 'signalType'" + " and a string value '\"CONTINUOUS\"' " + "or '\"DISCRETE\"'.");
                    }
                    this._signalTypeMap.setType(outputPort, knownInputType);
                }
                this._signalTypeMap.propagateType(outputPort);
            }
        }
        this._setPortSignalTypes(this._signalTypeMap);
        if (this._debugging) {
            this._debug("Resolved signal types: {\n" + this._signalTypeMap.toString() + "}");
        }
        discreteActors = this._signalTypeMap.getDiscreteActors();
        continuousActors = this._signalTypeMap.getContinuousActors();
        continuousActors.removeAll(ctSubsystems);
        continuousActors.addAll(ctSubsystems);
        discreteActors.removeAll(ctSubsystems);
        discreteActors.addAll(ctSubsystems);
        for (CompositeActor compositeActor : nonCTSubsystems) {
            if (!discreteActors.contains(compositeActor) || !continuousActors.contains(compositeActor)) continue;
            waveformGenerators.add(compositeActor);
            discreteActors.remove(compositeActor);
            continuousActors.remove(compositeActor);
        }
        DirectedAcyclicGraph directedAcyclicGraph = this._toGraph(discreteActors);
        Object[] discreteSorted = directedAcyclicGraph.topologicalSort();
        for (int i = 0; i < discreteSorted.length; ++i) {
            Actor actor = (Actor)discreteSorted[i];
            if (continuousActors.contains(actor)) {
                if (actor instanceof CTCompositeActor) {
                    discreteActorSchedule.add(new Firing(actor));
                    continue;
                }
                if (!(actor instanceof CTEventGenerator) && !(actor instanceof CTWaveformGenerator)) continue;
                continuousActors.remove(actor);
                continue;
            }
            discreteActorSchedule.add(new Firing(actor));
        }
        for (Actor generator : waveformGenerators) {
            waveformGeneratorSchedule.add(new Firing(generator));
        }
        if (!eventGenerators.isEmpty()) {
            DirectedAcyclicGraph eventGraph = this._toGraph(eventGenerators);
            Object[] eventSorted = eventGraph.topologicalSort();
            for (int i = 0; i < eventSorted.length; ++i) {
                Actor actor = (Actor)eventSorted[i];
                eventGeneratorSchedule.add(new Firing(actor));
                if (!(actor instanceof CTStepSizeControlActor)) continue;
                outputSSCActorSchedule.add(new Firing(actor));
            }
        }
        for (Actor actor : continuousActors) {
            continuousActorSchedule.add(new Firing(actor));
        }
        LinkedList<Actor> stateRelatedActors = new LinkedList<Actor>();
        arithmeticGraph = this._toArithmeticGraph(continuousActors);
        if (!dynamicActors.isEmpty()) {
            Object[] dynamicArray = dynamicActors.toArray();
            Object[] xSorted = dynamicGraph.topologicalSort(dynamicArray);
            for (int i = 0; i < xSorted.length; ++i) {
                Actor dynamicActor = (Actor)xSorted[i];
                dynamicActorSchedule.add(0, new Firing(dynamicActor));
                stateRelatedActors.add(dynamicActor);
                if (dynamicActor instanceof CTStepSizeControlActor) {
                    stateSSCActorSchedule.add(new Firing(dynamicActor));
                }
                Object[] fx = arithmeticGraph.backwardReachableNodes(dynamicActor);
                Object[] fxSorted = arithmeticGraph.topologicalSort(fx);
                for (int fxi = 0; fxi < fxSorted.length; ++fxi) {
                    Actor actor = (Actor)fxSorted[fxi];
                    if (stateTransitionActors.contains(actor)) continue;
                    stateTransitionActors.add(actor);
                    stateRelatedActors.add(actor);
                    if (!(actor instanceof CTStepSizeControlActor)) continue;
                    stateSSCActorSchedule.add(new Firing(actor));
                }
                if (!(dynamicActor instanceof CTCompositeActor) || stateTransitionActors.contains(dynamicActor)) continue;
                stateTransitionActors.add(dynamicActor);
            }
        }
        for (Actor stActor : stateTransitionActors) {
            stateTransitionSchedule.add(new Firing(stActor));
        }
        sinkActors = (LinkedList)continuousActors.clone();
        sinkActors.removeAll(stateRelatedActors);
        sinkActors.removeAll(ctSubsystems);
        sinkActors.addAll(ctSubsystems);
        if (!sinkActors.isEmpty()) {
            arithmeticGraph = this._toArithmeticGraph(sinkActors);
            Object[] sinkArray = sinkActors.toArray();
            Object[] gxSorted = arithmeticGraph.topologicalSort(sinkArray);
            for (int i = 0; i < gxSorted.length; ++i) {
                Actor a = (Actor)gxSorted[i];
                outputSchedule.add(new Firing(a));
                if (eventGenerators.contains(a) || !(a instanceof CTStepSizeControlActor)) continue;
                outputSSCActorSchedule.add(new Firing(a));
            }
        }
        ctSchedule.add(continuousActorSchedule);
        ctSchedule.add(discreteActorSchedule);
        ctSchedule.add(dynamicActorSchedule);
        ctSchedule.add(eventGeneratorSchedule);
        ctSchedule.add(outputSchedule);
        ctSchedule.add(outputSSCActorSchedule);
        ctSchedule.add(stateTransitionSchedule);
        ctSchedule.add(statefulActorSchedule);
        ctSchedule.add(stateSSCActorSchedule);
        ctSchedule.add(waveformGeneratorSchedule);
        this.setValid(true);
        return ctSchedule;
    }

    private static void _setOrCreate(NamedObj container, String name, String value) throws IllegalActionException {
        Variable parameter = (Variable)container.getAttribute(name);
        if (parameter == null) {
            try {
                parameter = new Variable(container, name);
                parameter.setVisibility(Settable.NOT_EDITABLE);
                parameter.setPersistent(false);
            }
            catch (KernelException ex) {
                throw new InternalErrorException(ex.toString());
            }
        }
        parameter.setToken(new StringToken(value));
    }

    private void _setPortSignalTypes(final SignalTypeMap typeMap) {
        Director director = (Director)this.getContainer();
        final CompositeActor container = (CompositeActor)director.getContainer();
        ChangeRequest request = new ChangeRequest(this, "Record signal types"){

            @Override
            protected void _execute() throws KernelException {
                for (Entity entity : container.deepEntityList()) {
                    for (IOPort port : entity.portList()) {
                        String typeString = typeMap.getType(port).toString();
                        CTScheduler._setOrCreate(port, "resolvedSignalType", typeString);
                    }
                }
            }
        };
        request.setPersistent(false);
        container.requestChange(request);
    }

    private DirectedAcyclicGraph _toArithmeticGraph(List list) {
        DirectedAcyclicGraph graph = new DirectedAcyclicGraph();
        for (Actor actor : list) {
            graph.addNodeWeight(actor);
        }
        for (Actor actor : list) {
            if (!(actor instanceof CTCompositeActor) && (actor instanceof CTDynamicActor || actor instanceof CTEventGenerator)) continue;
            for (Actor successor : this.successorList(actor)) {
                if (!list.contains(successor)) continue;
                graph.addEdge(actor, successor);
            }
        }
        return graph;
    }

    private DirectedAcyclicGraph _toGraph(List list) {
        DirectedAcyclicGraph g = new DirectedAcyclicGraph();
        for (Actor a : list) {
            g.addNodeWeight(a);
        }
        for (Actor a : list) {
            for (Actor s : this.successorList(a)) {
                if (!list.contains(s)) continue;
                g.addEdge(a, s);
            }
        }
        return g;
    }

    private class SignalTypeMap {
        private HashMap _map = new HashMap();
        private LinkedList _continuousActors = new LinkedList();
        private LinkedList _discreteActors = new LinkedList();

        public LinkedList getContinuousActors() {
            return this._continuousActors;
        }

        public LinkedList getDiscreteActors() {
            return this._discreteActors;
        }

        public CTReceiver.SignalType getType(IOPort port) throws NotSchedulableException {
            if (!this._map.containsKey(port)) {
                return UNKNOWN;
            }
            return (CTReceiver.SignalType)this._map.get(port);
        }

        public void setType(IOPort port, CTReceiver.SignalType type) throws NotSchedulableException {
            if (!this._map.containsKey(port)) {
                int j;
                int i;
                Receiver[][] receivers;
                this._map.put(port, type);
                if (port.getContainer() != CTScheduler.this.getContainer().getContainer() && port.isInput()) {
                    receivers = port.getReceivers();
                    for (i = 0; i < receivers.length; ++i) {
                        for (j = 0; j < receivers[i].length; ++j) {
                            ((CTReceiver)receivers[i][j]).setSignalType(type);
                        }
                    }
                }
                if (port.getContainer() == CTScheduler.this.getContainer().getContainer() && port.isOutput()) {
                    receivers = port.getInsideReceivers();
                    for (i = 0; i < receivers.length; ++i) {
                        for (j = 0; j < receivers[i].length; ++j) {
                            ((CTReceiver)receivers[i][j]).setSignalType(type);
                        }
                    }
                }
                Entity actor = (Entity)port.getContainer();
                if (type == CONTINUOUS && actor != CTScheduler.this.getContainer().getContainer() && !this._continuousActors.contains(actor)) {
                    this._continuousActors.add(actor);
                }
                if (type == DISCRETE && actor != CTScheduler.this.getContainer().getContainer() && !this._discreteActors.contains(actor)) {
                    this._discreteActors.add(actor);
                }
            } else {
                CTReceiver.SignalType previousType = (CTReceiver.SignalType)this._map.get(port);
                if (previousType != type) {
                    throw new NotSchedulableException(port.getFullName() + " has a signal type conflict: \n" + "Its signal type was set/resolved to " + CTScheduler.this.signalTypeToString(previousType) + ", but is going to be set to " + CTScheduler.this.signalTypeToString(type) + " now.");
                }
            }
        }

        public void propagateType(IOPort port) throws NotSchedulableException {
            if (!this._map.containsKey(port)) {
                throw new InternalErrorException(port.getFullName() + " type unknown.");
            }
            for (IOPort nextPort : port.sinkPortList()) {
                if (!this._map.containsKey(nextPort)) {
                    Parameter signalType = (Parameter)nextPort.getAttribute("signalType");
                    if (signalType != null) {
                        try {
                            String configuredType = ((StringToken)signalType.getToken()).stringValue();
                            configuredType = configuredType.trim().toUpperCase();
                            String propagateType = CTScheduler.this.signalTypeToString(this.getType(port));
                            if (configuredType.compareToIgnoreCase("UNKNOWN") != 0 && propagateType.compareToIgnoreCase(configuredType) != 0) {
                                throw new NotSchedulableException("Signal type conflict: " + port.getFullName() + " (of type " + configuredType + ") and " + nextPort.getFullName() + " (of type " + propagateType + ")" + "). Perhaps the connection has " + "sequence semantics?");
                            }
                        }
                        catch (IllegalActionException e) {
                            throw new NotSchedulableException("The signal type parameter does not contain a valid value.");
                        }
                    }
                    this.setType(nextPort, this.getType(port));
                    continue;
                }
                if (this.getType(port) == this.getType(nextPort)) continue;
                LinkedList<IOPort> offendingPorts = new LinkedList<IOPort>();
                offendingPorts.add(port);
                offendingPorts.add(nextPort);
                throw new NotSchedulableException(offendingPorts, null, "Signal type conflict: " + port.getFullName() + " (of type " + CTScheduler.this.signalTypeToString(this.getType(port)) + ") and " + nextPort.getFullName() + " (of type " + CTScheduler.this.signalTypeToString(this.getType(nextPort)) + ")" + "). Perhaps the connection has " + "sequence semantics?");
            }
        }

        public void propagateTypeInside(IOPort port) throws NotSchedulableException {
            if (!this._map.containsKey(port)) {
                throw new InternalErrorException(port.getFullName() + " type unknown.");
            }
            for (IOPort nextPort : port.insideSinkPortList()) {
                if (!this._map.containsKey(nextPort)) {
                    this.setType(nextPort, this.getType(port));
                    continue;
                }
                if (this.getType(port) == this.getType(nextPort)) continue;
                throw new NotSchedulableException("Signal type conflict: " + port.getFullName() + " (of type " + CTScheduler.this.signalTypeToString(this.getType(port)) + ") and " + nextPort.getFullName() + " (of type " + CTScheduler.this.signalTypeToString(this.getType(nextPort)) + ")" + "). Perhaps the connections has " + "sequence semantics instead of the continuous " + "signal semantics that CT requires?  This " + "would happen if one of the actors was an " + "SDF actor.");
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            if (this._map != null) {
                for (IOPort port : this._map.keySet()) {
                    String type = CTScheduler.this.signalTypeToString(this.getType(port));
                    buffer.append("  " + port.getFullName() + " :: " + type + "\n");
                    if (!type.equals("UNKNOWN")) continue;
                    throw new InternalErrorException("Found unsolved signal type at " + port.getFullName() + " :: " + type);
                }
            }
            return buffer.toString();
        }
    }
}

