/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.kernel;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.FiringEvent;
import ptolemy.actor.IOPort;
import ptolemy.actor.Receiver;
import ptolemy.actor.TimedDirector;
import ptolemy.actor.util.FunctionDependency;
import ptolemy.actor.util.FunctionDependencyOfCompositeActor;
import ptolemy.actor.util.Time;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.de.kernel.DECQEventQueue;
import ptolemy.domains.de.kernel.DEEvent;
import ptolemy.domains.de.kernel.DEEventQueue;
import ptolemy.domains.de.kernel.DEReceiver;
import ptolemy.graph.DirectedAcyclicGraph;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.DebugListener;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class DEDirector
extends Director
implements TimedDirector {
    public Parameter binCountFactor;
    public Parameter isCQAdaptive;
    public Parameter minBinCount;
    public Parameter startTime;
    public Parameter stopTime;
    public Parameter stopWhenQueueIsEmpty;
    public Parameter synchronizeToRealTime;
    private Hashtable _actorToDepth = null;
    private boolean _delegateFireAt = false;
    private Set _disabledActors;
    private DEEventQueue _eventQueue;
    private boolean _exceedStopTime = false;
    private boolean _isInitializing = false;
    private int _microstep = 0;
    private boolean _noMoreActorsToFire = false;
    private Hashtable _portToDepth = null;
    private long _realStartTime = 0L;
    private long _sortValid = -1L;
    private Time _startTime;
    private boolean _stopFireRequested = false;
    private Time _stopTime;
    private boolean _stopWhenQueueIsEmpty = true;
    private boolean _synchronizeToRealTime;

    public DEDirector() {
        this._initParameters();
    }

    public DEDirector(Workspace workspace) {
        super(workspace);
        this._initParameters();
    }

    public DEDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._initParameters();
    }

    @Override
    public void addDebugListener(DebugListener listener) {
        if (this._eventQueue != null) {
            this._eventQueue.addDebugListener(listener);
        }
        super.addDebugListener(listener);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.startTime) {
            double startTimeValue = ((DoubleToken)this.startTime.getToken()).doubleValue();
            this._startTime = new Time((Director)this, startTimeValue);
        } else if (attribute == this.stopTime) {
            double stopTimeValue = ((DoubleToken)this.stopTime.getToken()).doubleValue();
            this._stopTime = new Time((Director)this, stopTimeValue);
        } else if (attribute == this.stopWhenQueueIsEmpty) {
            this._stopWhenQueueIsEmpty = ((BooleanToken)this.stopWhenQueueIsEmpty.getToken()).booleanValue();
        } else if (attribute == this.synchronizeToRealTime) {
            this._synchronizeToRealTime = ((BooleanToken)this.synchronizeToRealTime.getToken()).booleanValue();
        } else {
            super.attributeChanged(attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire() throws IllegalActionException {
        while (true) {
            boolean refire;
            Actor actorToFire;
            if ((actorToFire = this._getNextActorToFire()) == null) {
                if (this._isTopLevel()) {
                    if (this._debugging) {
                        this._debug("No more events in the event queue.");
                    }
                    if (!this._stopFireRequested) {
                        this._noMoreActorsToFire = true;
                    }
                } else if (this._debugging) {
                    this._debug("No actor requests to be fired at the current tag.");
                }
                this._stopFireRequested = false;
                return;
            }
            if (actorToFire == this.getContainer()) {
                this._stopFireRequested = false;
                return;
            }
            if (this._debugging) {
                this._debug("DE director fires at " + this.getModelTime() + "  with microstep as " + this._microstep);
            }
            do {
                refire = false;
                if (this._debugging) {
                    if (actorToFire.getContainer() == null) {
                        this._debug("Actor has no container. Disabling actor.");
                        this._disableActor(actorToFire);
                        break;
                    }
                    this._debug(new FiringEvent(this, actorToFire, FiringEvent.BEFORE_PREFIRE));
                    if (!actorToFire.prefire()) {
                        this._debug("*** Prefire returned false.");
                        break;
                    }
                    this._debug(new FiringEvent(this, actorToFire, FiringEvent.AFTER_PREFIRE));
                    this._debug(new FiringEvent(this, actorToFire, FiringEvent.BEFORE_FIRE));
                    actorToFire.fire();
                    this._debug(new FiringEvent(this, actorToFire, FiringEvent.AFTER_FIRE));
                    this._debug(new FiringEvent(this, actorToFire, FiringEvent.BEFORE_POSTFIRE));
                    if (!actorToFire.postfire()) {
                        this._debug("*** Postfire returned false:", actorToFire.getName());
                        this._disableActor(actorToFire);
                        break;
                    }
                    this._debug(new FiringEvent(this, actorToFire, FiringEvent.AFTER_POSTFIRE));
                } else {
                    if (actorToFire.getContainer() == null) {
                        this._disableActor(actorToFire);
                        break;
                    }
                    if (!actorToFire.prefire()) break;
                    actorToFire.fire();
                    if (!actorToFire.postfire()) {
                        this._disableActor(actorToFire);
                        break;
                    }
                }
                Iterator inputPorts = actorToFire.inputPortList().iterator();
                block5: while (inputPorts.hasNext() && !refire) {
                    IOPort port = (IOPort)inputPorts.next();
                    for (int i = 0; i < port.getWidth(); ++i) {
                        if (!port.hasToken(i)) continue;
                        refire = true;
                        continue block5;
                    }
                }
            } while (refire);
            DEEventQueue dEEventQueue = this._eventQueue;
            synchronized (dEEventQueue) {
                if (!this._eventQueue.isEmpty()) {
                    DEEvent next = this._eventQueue.get();
                    if (next.timeStamp().compareTo(this.getModelTime()) > 0) {
                        this._microstep = 0;
                        break;
                    }
                    if (next.microstep() > this._microstep) {
                        break;
                    }
                    if (next.timeStamp().compareTo(this.getModelTime()) < 0 || next.microstep() < this._microstep) {
                        throw new IllegalActionException("The tag of the next event (" + next.timeStamp() + "." + next.microstep() + ") can not be less than" + " the current tag (" + this.getModelTime() + "." + this._microstep + ") !");
                    }
                }
            }
        }
        this._stopFireRequested = false;
        if (this._debugging) {
            this._debug("DE director fired!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireAt(Actor actor, Time time) throws IllegalActionException {
        if (this._eventQueue == null) {
            throw new IllegalActionException((Nameable)this, "Calling fireAt() before preinitialize().");
        }
        if (this._debugging) {
            this._debug("DEDirector: Actor " + actor.getFullName() + " requests refiring at " + time);
        }
        DEEventQueue dEEventQueue = this._eventQueue;
        synchronized (dEEventQueue) {
            this._enqueueEvent(actor, time);
            this._eventQueue.notifyAll();
        }
        if (this._delegateFireAt) {
            CompositeActor container = (CompositeActor)this.getContainer();
            if (this._debugging) {
                this._debug("DEDirector: Requests refiring of: " + container.getName() + " at time " + time);
            }
            container.getExecutiveDirector().fireAt((Actor)container, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireAtCurrentTime(Actor actor) throws IllegalActionException {
        if (this._eventQueue == null) {
            throw new IllegalActionException((Nameable)this, "Calling fireAt() before preinitialize().");
        }
        DEEventQueue dEEventQueue = this._eventQueue;
        synchronized (dEEventQueue) {
            this.fireAt(actor, this.getModelTime());
        }
    }

    public void fireAtRelativeTime(Actor actor, Time time) throws IllegalActionException {
        this.fireAt(actor, time.add(this.getModelTime()));
    }

    public DEEventQueue getEventQueue() {
        return this._eventQueue;
    }

    @Override
    public Time getModelNextIterationTime() {
        Time aFutureTimeOfUpperLevel;
        Director executiveDirector;
        Time aFutureTime = Time.POSITIVE_INFINITY;
        if (this._eventQueue.size() > 0) {
            aFutureTime = this._eventQueue.get().timeStamp();
        }
        Object[] events = this._eventQueue.toArray();
        for (int i = 0; i < events.length; ++i) {
            DEEvent event = (DEEvent)events[i];
            Time eventTime = event.timeStamp();
            int eventMicrostep = event.microstep();
            if (eventTime.compareTo(this.getModelTime()) <= 0 && eventMicrostep <= this._microstep) continue;
            aFutureTime = eventTime;
            break;
        }
        if ((executiveDirector = ((CompositeActor)this.getContainer()).getExecutiveDirector()) != null && aFutureTime.compareTo(aFutureTimeOfUpperLevel = executiveDirector.getModelNextIterationTime()) > 0) {
            aFutureTime = aFutureTimeOfUpperLevel;
        }
        return aFutureTime;
    }

    @Override
    public final Time getModelStartTime() {
        return this._startTime;
    }

    @Override
    public final Time getModelStopTime() {
        return this._stopTime;
    }

    public long getRealStartTimeMillis() {
        return this._realStartTime;
    }

    @Override
    public final double getStartTime() {
        return this.getModelStartTime().getDoubleValue();
    }

    @Override
    public final double getStopTime() {
        return this.getModelStopTime().getDoubleValue();
    }

    @Override
    public void initialize() throws IllegalActionException {
        this._isInitializing = true;
        this._eventQueue.clear();
        this._disabledActors = null;
        this._exceedStopTime = false;
        this._microstep = 0;
        this._noMoreActorsToFire = false;
        this._realStartTime = System.currentTimeMillis();
        this._stopFireRequested = false;
        super.initialize();
        if (!this._stopTime.isPositiveInfinite()) {
            this.fireAt((Actor)((Object)this.getContainer()), this._stopTime);
        }
        if (this._isEmbedded() && !this._eventQueue.isEmpty()) {
            this._requestFiring();
            this._delegateFireAt = true;
        } else {
            this._delegateFireAt = false;
        }
        this._isInitializing = false;
    }

    @Override
    public void invalidateSchedule() {
        this._sortValid = -1L;
    }

    @Override
    public Receiver newReceiver() {
        if (this._debugging && this._verbose) {
            this._debug("Creating a new DE receiver.");
        }
        return new DEReceiver();
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        boolean result = super.postfire();
        boolean stop = ((BooleanToken)this.stopWhenQueueIsEmpty.getToken()).booleanValue();
        if (this._noMoreActorsToFire && (stop || this.getModelTime().compareTo(this.getModelStopTime()) == 0)) {
            this._exceedStopTime = true;
            if (result) {
                // empty if block
            }
            result = false;
        } else if (this._exceedStopTime) {
            if (result) {
                // empty if block
            }
            result = false;
        } else if (this._isEmbedded() && !this._eventQueue.isEmpty()) {
            this._requestFiring();
        }
        if (this._isEmbedded()) {
            this._delegateFireAt = true;
        }
        return result;
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        boolean result = super.prefire();
        if (this._debugging) {
            this._debug("Current time is: " + this.getModelTime());
        }
        if (this._isTopLevel()) {
            if (this._debugging) {
                this._debug("Prefire returns: " + result);
            }
            return result;
        }
        Time modelTime = this.getModelTime();
        Time nextEventTime = Time.POSITIVE_INFINITY;
        if (!this._eventQueue.isEmpty()) {
            nextEventTime = this._eventQueue.get().timeStamp();
        }
        while (modelTime.compareTo(nextEventTime) > 0) {
            this._eventQueue.take();
            if (!this._eventQueue.isEmpty()) {
                nextEventTime = this._eventQueue.get().timeStamp();
                continue;
            }
            nextEventTime = Time.POSITIVE_INFINITY;
        }
        if (!nextEventTime.equals(modelTime)) {
            CompositeActor container = (CompositeActor)this.getContainer();
            Iterator inputPorts = container.inputPortList().iterator();
            boolean hasInput = false;
            block1: while (inputPorts.hasNext() && !hasInput) {
                IOPort port = (IOPort)inputPorts.next();
                for (int i = 0; i < port.getWidth(); ++i) {
                    if (!port.hasToken(i)) continue;
                    hasInput = true;
                    continue block1;
                }
            }
            if (!hasInput) {
                result = false;
            }
        }
        if (this._debugging) {
            this._debug("Prefire returns: " + result);
        }
        this._delegateFireAt = !result;
        return result;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        this._eventQueue = new DECQEventQueue(((IntToken)this.minBinCount.getToken()).intValue(), ((IntToken)this.binCountFactor.getToken()).intValue(), ((BooleanToken)this.isCQAdaptive.getToken()).booleanValue());
        if (this._debugListeners != null) {
            for (DebugListener listener : this._debugListeners) {
                this._eventQueue.addDebugListener(listener);
            }
        }
        super.preinitialize();
        if (this._sortValid != this.workspace().getVersion()) {
            this._actorToDepth = null;
            this._portToDepth = null;
            this._computePortDepth();
            this._computeActorDepth();
        }
    }

    @Override
    public void removeDebugListener(DebugListener listener) {
        if (this._eventQueue != null) {
            this._eventQueue.removeDebugListener(listener);
        }
        super.removeDebugListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this._eventQueue != null) {
            DEEventQueue dEEventQueue = this._eventQueue;
            synchronized (dEEventQueue) {
                this._stopRequested = true;
                this._eventQueue.notifyAll();
            }
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopFire() {
        if (this._eventQueue != null) {
            DEEventQueue dEEventQueue = this._eventQueue;
            synchronized (dEEventQueue) {
                this._stopFireRequested = true;
                this._eventQueue.notifyAll();
            }
        }
        super.stopFire();
    }

    @Override
    public String[] suggestedModalModelDirectors() {
        String[] defaultSuggestions = new String[2];
        defaultSuggestions[1] = "ptolemy.domains.fsm.kernel.MultirateFSMDirector";
        defaultSuggestions[0] = "ptolemy.domains.fsm.kernel.FSMDirector";
        return defaultSuggestions;
    }

    @Override
    public boolean transferOutputs(IOPort port) throws IllegalActionException {
        boolean anyWereTransferred = false;
        boolean moreTransfersRemaining = true;
        while (moreTransfersRemaining) {
            moreTransfersRemaining = super.transferOutputs(port);
            anyWereTransferred |= moreTransfersRemaining;
        }
        return anyWereTransferred;
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        this._disabledActors = null;
        this._eventQueue.clear();
        this._noMoreActorsToFire = false;
        this._microstep = 0;
    }

    protected void _enqueueEvent(Actor actor, Time time) throws IllegalActionException {
        if (this._eventQueue == null || this._disabledActors != null && this._disabledActors.contains(actor)) {
            return;
        }
        int microstep = 0;
        if (time.compareTo(this.getModelTime()) == 0) {
            microstep = this._isInitializing ? this._microstep : this._microstep + 1;
        } else if (time.compareTo(this.getModelTime()) < 0) {
            throw new IllegalActionException((Nameable)actor, "Attempt to queue an event in the past: Current time is " + this.getModelTime() + " while event time is " + time);
        }
        int depth = this._getDepthOfActor(actor);
        if (this._debugging) {
            this._debug("enqueue a pure event: ", ((NamedObj)((Object)actor)).getName(), "time = " + time + " microstep = " + microstep + " depth = " + depth);
        }
        DEEvent newEvent = new DEEvent(actor, time, microstep, depth);
        this._eventQueue.put(newEvent);
    }

    protected void _enqueueTriggerEvent(IOPort ioPort) throws IllegalActionException {
        Actor actor = (Actor)((Object)ioPort.getContainer());
        if (this._eventQueue == null || this._disabledActors != null && this._disabledActors.contains(actor)) {
            return;
        }
        int depth = this._getDepthOfIOPort(ioPort);
        if (this._debugging) {
            this._debug("enqueue a trigger event for ", ((NamedObj)((Object)actor)).getName(), " time = " + this.getModelTime() + " microstep = " + this._microstep + " depth = " + depth);
        }
        DEEvent newEvent = new DEEvent(ioPort, this.getModelTime(), this._microstep, depth);
        this._eventQueue.put(newEvent);
    }

    protected void _computeActorDepth() throws IllegalActionException {
        CompositeActor container = (CompositeActor)this.getContainer();
        LinkedList actors = (LinkedList)container.deepEntityList();
        actors.add(container);
        int numberOfActors = actors.size();
        this._actorToDepth = new Hashtable(numberOfActors);
        Iterator actorsIterator = actors.iterator();
        int defaultActorDepth = -numberOfActors;
        while (actorsIterator.hasNext()) {
            Actor actor = (Actor)actorsIterator.next();
            int depth = -1;
            for (IOPort inputPort : actor.inputPortList()) {
                int inputDepth = this._getDepthOfIOPort(inputPort);
                if (inputDepth >= depth && depth != -1) continue;
                depth = inputDepth;
            }
            for (IOPort outputPort : actor.outputPortList()) {
                int outputDepth = this._getDepthOfIOPort(outputPort);
                if (outputDepth >= depth && depth != -1) continue;
                depth = outputDepth;
            }
            if (depth == -1) {
                depth = defaultActorDepth;
            }
            this._actorToDepth.put(actor, depth);
            ++defaultActorDepth;
        }
        if (!this._eventQueue.isEmpty()) {
            LinkedList<DEEvent> updatedEventList = new LinkedList<DEEvent>();
            while (!this._eventQueue.isEmpty()) {
                DEEvent event = this._eventQueue.take();
                IOPort ioPort = event.ioPort();
                Actor actor = event.actor();
                if (ioPort != null) {
                    event._updateDepth(this._getDepthOfIOPort(ioPort));
                } else if (actor != null) {
                    event._updateDepth(this._getDepthOfActor(actor));
                }
                updatedEventList.add(event);
            }
            for (DEEvent updatedEvent : updatedEventList) {
                this._eventQueue.put(updatedEvent);
            }
        }
    }

    private void _computePortDepth() throws IllegalActionException {
        Actor portContainer;
        DirectedAcyclicGraph portsGraph = this._constructDirectedGraph();
        this._verbose = true;
        if (this._debugging && this._verbose) {
            this._debug("## ports graph is:" + portsGraph.toString());
        }
        Object[] sort = portsGraph.topologicalSort();
        int numberOfPorts = sort.length;
        if (this._debugging && this._verbose) {
            this._debug("## Result of topological sort (highest depth to lowest):");
        }
        this._portToDepth = new Hashtable(numberOfPorts);
        LinkedList<IOPort> ports = new LinkedList<IOPort>();
        for (int i = 0; i <= numberOfPorts - 1; ++i) {
            IOPort ioPort = (IOPort)sort[i];
            ports.add(ioPort);
            int depth = i;
            portContainer = (Actor)((Object)ioPort.getContainer());
            if (ioPort.isOutput() && portContainer.equals(this.getContainer())) {
                depth += numberOfPorts;
            }
            this._portToDepth.put(ioPort, depth);
            if (!this._debugging || !this._verbose) continue;
            this._debug(ioPort.getFullName(), "depth: " + depth);
        }
        if (this._debugging && this._verbose) {
            this._debug("## adjusting port depths to make opaque composite actors and actors with no output ports strict.");
        }
        HashSet<Actor> actorsWithPortDepthsAdjusted = new HashSet<Actor>();
        for (int i = sort.length - 1; i >= 0; --i) {
            IOPort ioPort = (IOPort)sort[i];
            portContainer = (Actor)((Object)ioPort.getContainer());
            if (portContainer.equals(this.getContainer())) continue;
            if (ioPort.isInput() && (portContainer.outputPortList().size() == 0 || portContainer instanceof CompositeActor && ((CompositeActor)portContainer).isOpaque())) {
                List inputPorts = portContainer.inputPortList();
                if (inputPorts.size() <= 1 || actorsWithPortDepthsAdjusted.contains(portContainer)) continue;
                actorsWithPortDepthsAdjusted.add(portContainer);
                Iterator inputsIterator = inputPorts.iterator();
                int maximumPortDepth = -1;
                while (inputsIterator.hasNext()) {
                    IOPort input = (IOPort)inputsIterator.next();
                    int inputPortDepth = ports.indexOf(input);
                    if (maximumPortDepth >= inputPortDepth) continue;
                    maximumPortDepth = inputPortDepth;
                }
                for (IOPort input : inputPorts) {
                    if (this._debugging && this._verbose) {
                        this._debug(input.getFullName(), "depth is adjusted to: " + maximumPortDepth);
                    }
                    this._portToDepth.put(input, maximumPortDepth);
                }
            }
            if (!ioPort.isOutput()) continue;
            FunctionDependency functionDependency = portContainer.getFunctionDependency();
            List inputPorts = functionDependency.getInputPortsDependentOn(ioPort);
            Iterator inputsIterator = inputPorts.iterator();
            int maximumPortDepth = -1;
            while (inputsIterator.hasNext()) {
                IOPort input = (IOPort)inputsIterator.next();
                int inputPortDepth = ports.indexOf(input);
                if (maximumPortDepth >= inputPortDepth) continue;
                maximumPortDepth = inputPortDepth;
            }
            for (IOPort input : inputPorts) {
                if (this._debugging && this._verbose) {
                    this._debug(input.getFullName(), "depth is adjusted to: " + maximumPortDepth);
                }
                this._portToDepth.put(input, maximumPortDepth);
            }
        }
        if (this._debugging) {
            this._debug("## End of topological sort of ports.");
        }
        this._sortValid = this.workspace().getVersion();
    }

    private DirectedAcyclicGraph _constructDirectedGraph() throws IllegalActionException {
        DirectedAcyclicGraph portsGraph = new DirectedAcyclicGraph();
        NamedObj container = this.getContainer();
        if (!(container instanceof CompositeActor)) {
            return portsGraph;
        }
        CompositeActor castContainer = (CompositeActor)container;
        FunctionDependencyOfCompositeActor functionDependency = (FunctionDependencyOfCompositeActor)castContainer.getFunctionDependency();
        Object[] cycleNodes = functionDependency.getCycleNodes();
        if (cycleNodes.length != 0) {
            StringBuffer names = new StringBuffer();
            for (int i = 0; i < cycleNodes.length; ++i) {
                if (!(cycleNodes[i] instanceof Nameable)) continue;
                if (i > 0) {
                    names.append(", ");
                }
                names.append(((Nameable)cycleNodes[i]).getContainer().getFullName());
            }
            throw new IllegalActionException((Nameable)this.getContainer(), "Found zero delay loop including: " + names.toString());
        }
        portsGraph = functionDependency.getDetailedDependencyGraph().toDirectedAcyclicGraph();
        return portsGraph;
    }

    protected void _disableActor(Actor actor) {
        if (actor != null) {
            if (this._debugging) {
                this._debug("Actor ", actor.getName(), " is disabled.");
            }
            if (this._disabledActors == null) {
                this._disabledActors = new HashSet();
            }
            this._disabledActors.add(actor);
        }
    }

    protected int _getDepthOfActor(Actor actor) throws IllegalActionException {
        Integer depth;
        if (this._sortValid != this.workspace().getVersion() || this._actorToDepth == null) {
            this._computePortDepth();
            this._computeActorDepth();
        }
        if ((depth = (Integer)this._actorToDepth.get(actor)) != null) {
            return depth;
        }
        throw new IllegalActionException("Attempt to get depth of actor " + ((NamedObj)((Object)actor)).getFullName() + " that was not sorted.");
    }

    protected int _getDepthOfIOPort(IOPort ioPort) throws IllegalActionException {
        Integer depth;
        if (this._sortValid != this.workspace().getVersion() || this._portToDepth == null) {
            this._computePortDepth();
            this._computeActorDepth();
        }
        if ((depth = (Integer)this._portToDepth.get(ioPort)) != null) {
            return depth;
        }
        throw new IllegalActionException("Attempt to get depth of ioPort " + ioPort.getName() + " that was not sorted.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Actor _getNextActorToFire() throws IllegalActionException {
        block32: {
            if (this._eventQueue == null) {
                throw new IllegalActionException("Fire method called before the preinitialize method.");
            }
            Actor actorToFire = null;
            DEEvent lastFoundEvent = null;
            DEEvent nextEvent = null;
            while (!this._stopRequested) {
                Time currentTime;
                DEEventQueue dEEventQueue;
                block34: {
                    long elapsedTime;
                    double elapsedTimeInSeconds;
                    Time elapsed;
                    block35: {
                        block33: {
                            if (this._stopWhenQueueIsEmpty && this._eventQueue.isEmpty()) {
                                return actorToFire;
                            }
                            if (!this._isTopLevel()) {
                                if (this._eventQueue.isEmpty()) {
                                    return actorToFire;
                                }
                                nextEvent = this._eventQueue.get();
                                if (nextEvent.timeStamp().compareTo(this.getModelTime()) < 0) {
                                    throw new IllegalActionException("Fire: Missed an event: the next event tag " + nextEvent.timeStamp() + " :: " + nextEvent.microstep() + " is earlier than the current model tag " + this.getModelTime() + " :: " + this._microstep + " !");
                                }
                                if (nextEvent.timeStamp().compareTo(this.getModelTime()) > 0) {
                                    return actorToFire;
                                }
                            } else {
                                if (this._eventQueue.isEmpty()) {
                                    if (actorToFire != null) return actorToFire;
                                    if (this.getModelTime().equals(this.getModelStopTime())) {
                                        return actorToFire;
                                    }
                                }
                                while (this._eventQueue.isEmpty() && !this._stopRequested && !this._stopFireRequested) {
                                    if (this._debugging) {
                                        this._debug("Queue is empty. Waiting for input events.");
                                    }
                                    Thread.yield();
                                    DEEventQueue dEEventQueue2 = this._eventQueue;
                                    // MONITORENTER : dEEventQueue2
                                    if (this._eventQueue.isEmpty() && !this._stopFireRequested) {
                                        try {
                                            this.workspace().wait(this._eventQueue);
                                        }
                                        catch (InterruptedException e) {
                                            // MONITOREXIT : dEEventQueue2
                                            break;
                                        }
                                    }
                                    // MONITOREXIT : dEEventQueue2
                                }
                                if (this._eventQueue.isEmpty()) {
                                    return actorToFire;
                                }
                                nextEvent = this._eventQueue.get();
                            }
                            if (nextEvent == null) {
                                throw new IllegalActionException("The event to be handled can not be null!");
                            }
                            if (actorToFire != null) break block33;
                            if (!this._synchronizeToRealTime) break block34;
                            dEEventQueue = this._eventQueue;
                            // MONITORENTER : dEEventQueue
                            break block35;
                        }
                        if (nextEvent.hasTheSameTagAndDepthAs(lastFoundEvent)) {
                            this._eventQueue.take();
                            continue;
                        }
                        if (!nextEvent.hasTheSameTagAs(lastFoundEvent)) return actorToFire;
                        Actor actor = nextEvent.actor();
                        if (actor != actorToFire) return actorToFire;
                        this._eventQueue.take();
                        continue;
                    }
                    while (!this._stopRequested && !this._stopFireRequested && (currentTime = (lastFoundEvent = this._eventQueue.get()).timeStamp()).compareTo(elapsed = new Time((Director)this, elapsedTimeInSeconds = (double)(elapsedTime = System.currentTimeMillis() - this._realStartTime) / 1000.0)) > 0) {
                        long timeToWait = (long)(currentTime.subtract(elapsed).getDoubleValue() * 1000.0);
                        if (timeToWait <= 0L) continue;
                        if (this._debugging) {
                            this._debug("Waiting for real time to pass: " + timeToWait);
                        }
                        try {
                            this._workspace.wait(this._eventQueue, timeToWait);
                            if (!this._stopRequested && !this._stopFireRequested) continue;
                            // MONITOREXIT : dEEventQueue
                            return null;
                        }
                        catch (InterruptedException ex) {
                        }
                    }
                    // MONITOREXIT : dEEventQueue
                }
                dEEventQueue = this._eventQueue;
                // MONITORENTER : dEEventQueue
                lastFoundEvent = this._eventQueue.take();
                currentTime = lastFoundEvent.timeStamp();
                actorToFire = lastFoundEvent.actor();
                if (this._disabledActors != null && this._disabledActors.contains(actorToFire)) {
                    if (this._debugging) {
                        this._debug("Skipping disabled actor: ", actorToFire.getFullName());
                    }
                    actorToFire = null;
                    // MONITOREXIT : dEEventQueue
                    continue;
                }
                this.setModelTime(currentTime);
                this._microstep = lastFoundEvent.microstep();
                // MONITOREXIT : dEEventQueue
                if (currentTime.compareTo(this.getModelStopTime()) <= 0) {
                    continue;
                }
                break block32;
            }
            return actorToFire;
        }
        if (this._debugging) {
            this._debug("Current time has passed the stop time.");
        }
        this._exceedStopTime = true;
        return null;
    }

    private void _initParameters() {
        try {
            this.startTime = new Parameter(this, "startTime");
            this.startTime.setExpression("0.0");
            this.startTime.setTypeEquals(BaseType.DOUBLE);
            this.stopTime = new Parameter(this, "stopTime");
            this.stopTime.setExpression("Infinity");
            this.stopTime.setTypeEquals(BaseType.DOUBLE);
            this.stopWhenQueueIsEmpty = new Parameter(this, "stopWhenQueueIsEmpty");
            this.stopWhenQueueIsEmpty.setExpression("true");
            this.stopWhenQueueIsEmpty.setTypeEquals(BaseType.BOOLEAN);
            this.synchronizeToRealTime = new Parameter(this, "synchronizeToRealTime");
            this.synchronizeToRealTime.setExpression("false");
            this.synchronizeToRealTime.setTypeEquals(BaseType.BOOLEAN);
            this.isCQAdaptive = new Parameter(this, "isCQAdaptive");
            this.isCQAdaptive.setExpression("true");
            this.isCQAdaptive.setTypeEquals(BaseType.BOOLEAN);
            this.isCQAdaptive.setVisibility(Settable.EXPERT);
            this.minBinCount = new Parameter(this, "minBinCount");
            this.minBinCount.setExpression("2");
            this.minBinCount.setTypeEquals(BaseType.INT);
            this.minBinCount.setVisibility(Settable.EXPERT);
            this.binCountFactor = new Parameter(this, "binCountFactor");
            this.binCountFactor.setExpression("2");
            this.binCountFactor.setTypeEquals(BaseType.INT);
            this.binCountFactor.setVisibility(Settable.EXPERT);
            this.timeResolution.setVisibility(Settable.FULL);
            this.timeResolution.moveToLast();
        }
        catch (KernelException e) {
            throw new InternalErrorException("Cannot set parameter:\n" + e.getMessage());
        }
    }

    private void _requestFiring() throws IllegalActionException {
        DEEvent nextEvent = null;
        nextEvent = this._eventQueue.get();
        CompositeActor container = (CompositeActor)this.getContainer();
        if (this._debugging) {
            this._debug("DEDirector: Requests refiring of: " + container.getName() + " at time " + nextEvent.timeStamp());
        }
        container.getExecutiveDirector().fireAt((Actor)container, nextEvent.timeStamp());
    }
}

