/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.lib;

import java.util.LinkedList;
import ptolemy.actor.Actor;
import ptolemy.actor.util.Time;
import ptolemy.actor.util.TimedEvent;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.domains.de.lib.Timer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;

public class NonInterruptibleTimer
extends Timer {
    private Time _nextTimeFree;
    private LinkedList _delayedInputTokensList;

    public NonInterruptibleTimer(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
    }

    @Override
    public void fire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("NonInterruptibleTimer: Called fire()");
        }
        this._delay = -1.0;
        if (this.input.hasToken(0)) {
            this._currentInput = this.input.get(0);
            this._delayedInputTokensList.addLast(this._currentInput);
            double delayValue = ((DoubleToken)this._currentInput).doubleValue();
            if (delayValue < 0.0) {
                throw new IllegalActionException("Delay can not be negative.");
            }
            this._delay = delayValue;
        } else {
            this._currentInput = null;
        }
        Time currentTime = this.getDirector().getModelTime();
        this._currentOutput = null;
        if (this._delayedOutputTokens.size() > 0 && currentTime.compareTo(this._nextTimeFree) == 0) {
            TimedEvent earliestEvent = (TimedEvent)this._delayedOutputTokens.get();
            Time eventTime = earliestEvent.timeStamp;
            if (!eventTime.equals(currentTime)) {
                throw new InternalErrorException("Timer time is reached, but output is not available.");
            }
            this._currentOutput = (Token)earliestEvent.contents;
            this.output.send(0, this._currentOutput);
            return;
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._nextTimeFree = Time.NEGATIVE_INFINITY;
        this._delayedInputTokensList = new LinkedList();
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        Time currentTime = this.getDirector().getModelTime();
        if (this._currentOutput != null) {
            this._delayedOutputTokens.take();
        }
        if (this._delayedInputTokensList.size() != 0 && this._delayedOutputTokens.isEmpty()) {
            DoubleToken delayToken = (DoubleToken)this._delayedInputTokensList.removeFirst();
            double delay = delayToken.doubleValue();
            this._nextTimeFree = currentTime.add(delay);
            this._delayedOutputTokens.put(new TimedEvent(this._nextTimeFree, this.value.getToken()));
            this.getDirector().fireAt((Actor)this, this._nextTimeFree);
        }
        return !this._stopRequested;
    }
}

