/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.util.CalendarQueue;
import ptolemy.actor.util.Time;
import ptolemy.actor.util.TimedEvent;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.de.lib.DETransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class TimedDelay
extends DETransformer {
    public Parameter delay;
    protected Token _currentInput;
    protected Token _currentOutput;
    protected double _delay;
    protected CalendarQueue _delayedOutputTokens;

    public TimedDelay(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this._init();
        this.output.setTypeSameAs(this.input);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.delay) {
            double newDelay = ((DoubleToken)this.delay.getToken()).doubleValue();
            if (newDelay < 0.0) {
                throw new IllegalActionException((Nameable)this, "Cannot have negative delay: " + newDelay);
            }
            this._delay = newDelay;
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        TimedDelay newObject = (TimedDelay)super.clone(workspace);
        newObject.output.setTypeSameAs(newObject.input);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this._currentInput = this.input.hasToken(0) ? this.input.get(0) : null;
        Time currentTime = this.getDirector().getModelTime();
        this._currentOutput = null;
        if (this._delayedOutputTokens.size() > 0) {
            TimedEvent earliestEvent = (TimedEvent)this._delayedOutputTokens.get();
            Time eventTime = earliestEvent.timeStamp;
            if (eventTime.equals(currentTime)) {
                this._currentOutput = (Token)earliestEvent.contents;
                this.output.send(0, this._currentOutput);
            }
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._currentInput = null;
        this._currentOutput = null;
        this._delayedOutputTokens = new CalendarQueue(new TimedEvent.TimeComparator());
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        Time currentTime = this.getDirector().getModelTime();
        Time delayToTime = currentTime.add(this._delay);
        if (this._delayedOutputTokens.size() > 0 && this._currentOutput != null) {
            this._delayedOutputTokens.take();
        }
        if (this._delayedOutputTokens.size() > 0) {
            TimedEvent earliestEvent = (TimedEvent)this._delayedOutputTokens.get();
            Time eventTime = earliestEvent.timeStamp;
            if (eventTime.equals(currentTime)) {
                this.getDirector().fireAt((Actor)this, currentTime);
            }
        }
        if (this._currentInput != null) {
            this._delayedOutputTokens.put(new TimedEvent(delayToTime, this._currentInput));
            this.getDirector().fireAt((Actor)this, delayToTime);
        }
        return super.postfire();
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.input, this.output);
    }

    protected void _init() throws IllegalActionException, NameDuplicationException {
        this.delay = new Parameter((NamedObj)this, "delay", new DoubleToken(1.0));
        this.delay.setTypeEquals(BaseType.DOUBLE);
        this._delay = ((DoubleToken)this.delay.getToken()).doubleValue();
    }
}

