/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.util.CalendarQueue;
import ptolemy.actor.util.Time;
import ptolemy.actor.util.TimedEvent;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.de.lib.DETransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class Timer
extends DETransformer {
    public Parameter value = new Parameter((NamedObj)this, "value", new BooleanToken(true));
    protected double _delay;
    protected CalendarQueue _delayedOutputTokens;
    protected Token _currentInput;
    protected Token _currentOutput;

    public Timer(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.output.setTypeSameAs(this.value);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Timer newObject = (Timer)super.clone(workspace);
        newObject.output.setTypeSameAs(newObject.value);
        newObject.input.setTypeEquals(BaseType.DOUBLE);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this._delay = -1.0;
        if (this.input.hasToken(0)) {
            this._currentInput = this.input.get(0);
            double delayValue = ((DoubleToken)this._currentInput).doubleValue();
            if (delayValue < 0.0) {
                throw new IllegalActionException("Delay can not be negative.");
            }
            this._delay = delayValue;
        } else {
            this._currentInput = null;
        }
        Time currentTime = this.getDirector().getModelTime();
        this._currentOutput = null;
        if (this._delayedOutputTokens.size() > 0) {
            TimedEvent earliestEvent = (TimedEvent)this._delayedOutputTokens.get();
            Time eventTime = earliestEvent.timeStamp;
            if (eventTime.equals(currentTime)) {
                this._currentOutput = (Token)earliestEvent.contents;
                this.output.send(0, this.value.getToken());
                return;
            }
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._currentInput = null;
        this._currentOutput = null;
        this._delayedOutputTokens = new CalendarQueue(new TimedEvent.TimeComparator());
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        Time currentTime = this.getDirector().getModelTime();
        Time delayToTime = currentTime.add(this._delay);
        if (this._delayedOutputTokens.size() > 0 && this._currentOutput != null) {
            this._delayedOutputTokens.take();
        }
        if (this._delayedOutputTokens.size() > 0) {
            TimedEvent earliestEvent = (TimedEvent)this._delayedOutputTokens.get();
            Time eventTime = earliestEvent.timeStamp;
            if (eventTime.equals(currentTime)) {
                this.getDirector().fireAt((Actor)this, currentTime);
            }
        }
        if (this._currentInput != null) {
            this._delayedOutputTokens.put(new TimedEvent(delayToTime, this.value.getToken()));
            this.getDirector().fireAt((Actor)this, delayToTime);
        }
        return super.postfire();
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.input, this.output);
    }
}

