/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.lib;

import java.util.Vector;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.util.Time;
import ptolemy.data.DoubleToken;
import ptolemy.data.type.BaseType;
import ptolemy.domains.de.kernel.DEActor;
import ptolemy.domains.de.kernel.DEDirector;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class WaitingTime
extends DEActor {
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);
    public TypedIOPort waiter;
    public TypedIOPort waitee;
    private Vector _waiting;

    public WaitingTime(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.waiter = new TypedIOPort(this, "waiter", true, false);
        this.waitee = new TypedIOPort(this, "waitee", true, false);
        this._waiting = new Vector();
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        WaitingTime newObject = (WaitingTime)super.clone(workspace);
        newObject._waiting = new Vector();
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        Time currentTime = ((DEDirector)this.getDirector()).getModelTime();
        while (this.waiter.hasToken(0)) {
            this.waiter.get(0);
            this._waiting.addElement(currentTime);
        }
        boolean godot = false;
        while (this.waitee.hasToken(0)) {
            this.waitee.get(0);
            godot = true;
        }
        if (godot) {
            for (int i = 0; i < this._waiting.size(); ++i) {
                Time previousTime = (Time)this._waiting.elementAt(i);
                DoubleToken outToken = new DoubleToken(currentTime.subtract(previousTime).getDoubleValue());
                this.output.send(0, outToken);
            }
            this._waiting.removeAllElements();
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._waiting.removeAllElements();
    }
}

