/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.TypedActor;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.domains.fsm.kernel.Action;
import ptolemy.domains.fsm.kernel.ChoiceAction;
import ptolemy.domains.fsm.kernel.CommitAction;
import ptolemy.domains.fsm.kernel.CommitActionsAttribute;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.domains.fsm.kernel.FSMDirector;
import ptolemy.domains.fsm.kernel.OutputActionsAttribute;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StreamListener;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class Transition
extends ComponentRelation {
    public StringParameter annotation;
    public Parameter defaultTransition = null;
    public Parameter exitAngle;
    public Parameter gamma;
    public StringAttribute guardExpression = null;
    public Parameter nondeterministic = null;
    public OutputActionsAttribute outputActions;
    public Parameter preemptive = null;
    public Parameter reset = null;
    public CommitActionsAttribute setActions;
    public StringAttribute refinementName = null;
    private long _actionListsVersion = -1L;
    private List _choiceActionList = new LinkedList();
    private List _commitActionList = new LinkedList();
    private State _destinationState = null;
    private ASTPtRootNode _guardParseTree;
    private boolean _nondeterministic = false;
    private State _sourceState = null;
    private long _stateVersion = -1L;
    private TypedActor[] _refinement = null;
    private long _refinementVersion = -1L;
    private ParseTreeEvaluator _parseTreeEvaluator;
    private long _parseTreeEvaluatorVersion = -1L;

    public Transition(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
        this._init();
    }

    public Transition(FSMActor container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._init();
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.preemptive) {
            this.preemptive.getToken();
            this.workspace().incrVersion();
        } else if (attribute == this.nondeterministic) {
            this._nondeterministic = ((BooleanToken)this.nondeterministic.getToken()).booleanValue();
        } else if (attribute == this.guardExpression) {
            this._guardParseTree = null;
            this._parseTreeEvaluatorVersion = -1L;
        } else if (attribute == this.refinementName) {
            this._refinementVersion = -1L;
        } else if (attribute == this.outputActions || attribute == this.setActions) {
            this._actionListsVersion = -1L;
        } else {
            super.attributeChanged(attribute);
        }
        if (attribute == this.outputActions && this._debugging) {
            this.outputActions.addDebugListener(new StreamListener());
        } else if (attribute == this.setActions && this._debugging) {
            this.setActions.addDebugListener(new StreamListener());
        }
    }

    public List choiceActionList() {
        if (this._actionListsVersion != this.workspace().getVersion()) {
            this._updateActionLists();
        }
        return this._choiceActionList;
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Transition newObject = (Transition)super.clone(workspace);
        newObject.guardExpression = (StringAttribute)newObject.getAttribute("guardExpression");
        newObject.preemptive = (Parameter)newObject.getAttribute("preemptive");
        newObject.refinementName = (StringAttribute)newObject.getAttribute("refinementName");
        newObject._guardParseTree = null;
        newObject._actionListsVersion = -1L;
        newObject._choiceActionList = new LinkedList();
        newObject._commitActionList = new LinkedList();
        newObject._stateVersion = -1L;
        return newObject;
    }

    public List commitActionList() {
        if (this._actionListsVersion != this.workspace().getVersion()) {
            this._updateActionLists();
        }
        return this._commitActionList;
    }

    public State destinationState() {
        if (this._stateVersion != this.workspace().getVersion()) {
            this._checkConnectedStates();
        }
        return this._destinationState;
    }

    public String getGuardExpression() {
        return this.guardExpression.getExpression();
    }

    public String getLabel() {
        String expression;
        String guard;
        String text;
        StringBuffer buffer = new StringBuffer("");
        boolean hasAnnotation = false;
        try {
            text = this.annotation.stringValue();
        }
        catch (IllegalActionException e) {
            text = "Exception evaluating annotation: " + e.getMessage();
        }
        if (!text.trim().equals("")) {
            hasAnnotation = true;
            buffer.append(text);
        }
        if ((guard = this.getGuardExpression()) != null && !guard.trim().equals("")) {
            if (hasAnnotation) {
                buffer.append("\n");
            }
            buffer.append("guard: ");
            buffer.append(guard);
        }
        if ((expression = this.outputActions.getExpression()) != null && !expression.trim().equals("")) {
            buffer.append("\n");
            buffer.append("output: ");
            buffer.append(expression);
        }
        if ((expression = this.setActions.getExpression()) != null && !expression.trim().equals("")) {
            buffer.append("\n");
            buffer.append("set: ");
            buffer.append(expression);
        }
        return buffer.toString();
    }

    public ParseTreeEvaluator getParseTreeEvaluator() {
        if (this._parseTreeEvaluatorVersion != this.workspace().getVersion()) {
            FSMDirector director = this._getDirector();
            if (director != null) {
                this._parseTreeEvaluator = director.getParseTreeEvaluator();
            } else if (this._parseTreeEvaluator == null) {
                this._parseTreeEvaluator = new ParseTreeEvaluator();
            }
            this._parseTreeEvaluatorVersion = this.workspace().getVersion();
        }
        return this._parseTreeEvaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypedActor[] getRefinement() throws IllegalActionException {
        if (this._refinementVersion == this.workspace().getVersion()) {
            return this._refinement;
        }
        try {
            this.workspace().getReadAccess();
            String names = this.refinementName.getExpression();
            if (names == null || names.trim().equals("")) {
                this._refinementVersion = this.workspace().getVersion();
                this._refinement = null;
                TypedActor[] typedActorArray = null;
                return typedActorArray;
            }
            StringTokenizer tokenizer = new StringTokenizer(names, ",");
            int size = tokenizer.countTokens();
            if (size <= 0) {
                this._refinementVersion = this.workspace().getVersion();
                this._refinement = null;
                TypedActor[] typedActorArray = null;
                return typedActorArray;
            }
            this._refinement = new TypedActor[size];
            NamedObj container = this.getContainer();
            TypedCompositeActor containerContainer = (TypedCompositeActor)container.getContainer();
            int index = 0;
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken().trim();
                if (name.equals("")) {
                    throw new IllegalActionException((Nameable)this, "Malformed list of refinements: " + names);
                }
                TypedActor element = (TypedActor)((Object)containerContainer.getEntity(name));
                if (element == null) {
                    throw new IllegalActionException((Nameable)this, "Cannot find refinement with name \"" + name + "\" in " + containerContainer.getFullName());
                }
                this._refinement[index++] = element;
            }
            this._refinementVersion = this.workspace().getVersion();
            TypedActor[] typedActorArray = this._refinement;
            return typedActorArray;
        }
        finally {
            this.workspace().doneReading();
        }
    }

    public boolean isDefault() throws IllegalActionException {
        return ((BooleanToken)this.defaultTransition.getToken()).booleanValue();
    }

    public boolean isEnabled() throws IllegalActionException {
        Token token;
        ParseTreeEvaluator parseTreeEvaluator = this.getParseTreeEvaluator();
        FSMActor fsmActor = (FSMActor)this.getContainer();
        if (this._guardParseTree == null) {
            String expr = this.getGuardExpression();
            PtParser parser = new PtParser();
            try {
                this._guardParseTree = parser.generateParseTree(expr);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException((Nameable)this, ex, "Failed to parse guard expression \"" + expr + "\"");
            }
        }
        if ((token = parseTreeEvaluator.evaluateParseTree(this._guardParseTree, fsmActor.getPortScope())) == null) {
            return false;
        }
        boolean result = ((BooleanToken)token).booleanValue();
        return result;
    }

    public boolean isNondeterministic() {
        return this._nondeterministic;
    }

    public boolean isPreemptive() {
        try {
            return ((BooleanToken)this.preemptive.getToken()).booleanValue();
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(this.preemptive.getFullName() + ": The parameter does not have a valid value, \"" + this.preemptive.getExpression() + "\".");
        }
    }

    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        if (container != null && !(container instanceof FSMActor)) {
            throw new IllegalActionException((Nameable)container, this, "Transition can only be contained by instances of FSMActor.");
        }
        super.setContainer(container);
    }

    public void setGuardExpression(String expression) {
        try {
            this.guardExpression.setExpression(expression);
            this.guardExpression.validate();
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("Error in setting the guard expression of a transition.");
        }
    }

    public State sourceState() {
        if (this._stateVersion != this.workspace().getVersion()) {
            this._checkConnectedStates();
        }
        return this._sourceState;
    }

    @Override
    protected void _checkPort(Port port) throws IllegalActionException {
        super._checkPort(port);
        if (!(port.getContainer() instanceof State)) {
            throw new IllegalActionException((Nameable)this, port.getContainer(), "Transition can only connect to instances of State.");
        }
        State st = (State)port.getContainer();
        if (port != st.incomingPort && port != st.outgoingPort) {
            throw new IllegalActionException((Nameable)this, port.getContainer(), "Transition can only be linked to incoming or outgoing port of State.");
        }
        if (this.numLinks() == 0) {
            return;
        }
        if (this.numLinks() >= 2) {
            throw new IllegalActionException((Nameable)this, "Transition can only connect two States.");
        }
        Iterator ports = this.linkedPortList().iterator();
        Port pt = (Port)ports.next();
        State s = (State)pt.getContainer();
        if (pt == s.incomingPort && port == st.incomingPort || pt == s.outgoingPort && port == st.outgoingPort) {
            throw new IllegalActionException((Nameable)this, "Transition can only have one source and one destination.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _checkConnectedStates() {
        try {
            this.workspace().getReadAccess();
            Iterator ports = this.linkedPortList().iterator();
            this._sourceState = null;
            this._destinationState = null;
            while (ports.hasNext()) {
                Port p = (Port)ports.next();
                State s = (State)p.getContainer();
                if (p == s.incomingPort) {
                    this._destinationState = s;
                    continue;
                }
                this._sourceState = s;
            }
            this._stateVersion = this.workspace().getVersion();
        }
        finally {
            this.workspace().doneReading();
        }
    }

    private FSMDirector _getDirector() {
        Director director;
        CompositeActor modalModel;
        NamedObj container = this.getContainer();
        if (container != null && (modalModel = (CompositeActor)container.getContainer()) != null && (director = modalModel.getDirector()) instanceof FSMDirector) {
            return (FSMDirector)director;
        }
        return null;
    }

    private void _init() throws IllegalActionException, NameDuplicationException {
        this.annotation = new StringParameter(this, "annotation");
        this.annotation.setExpression("");
        Variable variable = new Variable(this.annotation, "_textHeightHint");
        variable.setExpression("5");
        variable.setPersistent(false);
        this.guardExpression = new StringAttribute(this, "guardExpression");
        variable = new Variable(this.guardExpression, "_textHeightHint");
        variable.setExpression("5");
        variable.setPersistent(false);
        this.outputActions = new OutputActionsAttribute(this, "outputActions");
        variable = new Variable(this.outputActions, "_textHeightHint");
        variable.setExpression("5");
        variable.setPersistent(false);
        this.setActions = new CommitActionsAttribute(this, "setActions");
        variable = new Variable(this.setActions, "_textHeightHint");
        variable.setExpression("5");
        variable.setPersistent(false);
        this.exitAngle = new Parameter(this, "exitAngle");
        this.exitAngle.setVisibility(Settable.NONE);
        this.exitAngle.setExpression("PI/5.0");
        this.exitAngle.setTypeEquals(BaseType.DOUBLE);
        this.gamma = new Parameter(this, "gamma");
        this.gamma.setVisibility(Settable.NONE);
        this.gamma.setExpression("0.0");
        this.gamma.setTypeEquals(BaseType.DOUBLE);
        this.reset = new Parameter(this, "reset");
        this.reset.setTypeEquals(BaseType.BOOLEAN);
        this.reset.setToken(BooleanToken.FALSE);
        this.preemptive = new Parameter(this, "preemptive");
        this.preemptive.setTypeEquals(BaseType.BOOLEAN);
        this.preemptive.setToken(BooleanToken.FALSE);
        this.defaultTransition = new Parameter(this, "defaultTransition");
        this.defaultTransition.setTypeEquals(BaseType.BOOLEAN);
        this.defaultTransition.setToken(BooleanToken.FALSE);
        this.nondeterministic = new Parameter(this, "nondeterministic");
        this.nondeterministic.setTypeEquals(BaseType.BOOLEAN);
        this.nondeterministic.setToken(BooleanToken.FALSE);
        this.refinementName = new StringAttribute(this, "refinementName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateActionLists() {
        try {
            this.workspace().getReadAccess();
            this._choiceActionList.clear();
            this._commitActionList.clear();
            for (Action action : this.attributeList(Action.class)) {
                if (action instanceof ChoiceAction) {
                    this._choiceActionList.add(action);
                }
                if (!(action instanceof CommitAction)) continue;
                this._commitActionList.add(action);
            }
            this._actionListsVersion = this.workspace().getVersion();
        }
        finally {
            this.workspace().doneReading();
        }
    }
}

