/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.pn.kernel;

import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.QueueReceiver;
import ptolemy.actor.process.BoundaryDetector;
import ptolemy.actor.process.ProcessReceiver;
import ptolemy.actor.process.TerminateProcessException;
import ptolemy.data.Token;
import ptolemy.domains.pn.kernel.PNDirector;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class PNQueueReceiver
extends QueueReceiver
implements ProcessReceiver {
    private PNDirector _director;
    private Thread _readPending = null;
    private Thread _writePending = null;
    private boolean _terminate = false;
    private BoundaryDetector _boundaryDetector = new BoundaryDetector(this);

    public PNQueueReceiver() {
    }

    public PNQueueReceiver(IOPort container) throws IllegalActionException {
        super(container);
    }

    @Override
    public void setContainer(IOPort port) throws IllegalActionException {
        super.setContainer(port);
        if (port == null) {
            this._director = null;
        } else {
            Actor actor = (Actor)((Object)port.getContainer());
            Director director = port.isInput() ? actor.getExecutiveDirector() : actor.getDirector();
            if (!(director instanceof PNDirector)) {
                throw new IllegalActionException((Nameable)port, "Cannot use an instance of PNQueueReceiver since the director is not a PNDirector.");
            }
            this._director = (PNDirector)director;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token get() {
        Token result = null;
        PNDirector pNDirector = this._director;
        synchronized (pNDirector) {
            while (!this._terminate) {
                if (super.hasToken()) {
                    result = super.get();
                    if (this._writePending == null) break;
                    this._director.threadUnblocked(this._writePending, this, PNDirector.WRITE_BLOCKED);
                    this._writePending = null;
                    break;
                }
                try {
                    this._readPending = Thread.currentThread();
                    this._director.threadBlocked(Thread.currentThread(), this, PNDirector.READ_BLOCKED);
                    Workspace workspace = this.getContainer().workspace();
                    workspace.wait(this._director);
                }
                catch (InterruptedException e) {
                    this._terminate = true;
                }
            }
            if (this._terminate) {
                throw new TerminateProcessException("");
            }
        }
        return result;
    }

    public PNDirector getDirector() {
        return this._director;
    }

    @Override
    public boolean hasRoom() {
        return true;
    }

    @Override
    public boolean hasRoom(int tokens) {
        return true;
    }

    @Override
    public boolean hasToken() {
        return true;
    }

    @Override
    public boolean hasToken(int tokens) {
        return true;
    }

    @Override
    public boolean isConnectedToBoundary() {
        return this._boundaryDetector.isConnectedToBoundary();
    }

    @Override
    public boolean isConnectedToBoundaryInside() {
        return this._boundaryDetector.isConnectedToBoundaryInside();
    }

    @Override
    public boolean isConnectedToBoundaryOutside() {
        return this._boundaryDetector.isConnectedToBoundaryOutside();
    }

    @Override
    public boolean isConsumerReceiver() {
        return this.isConnectedToBoundary();
    }

    @Override
    public boolean isInsideBoundary() {
        return this._boundaryDetector.isInsideBoundary();
    }

    @Override
    public boolean isOutsideBoundary() {
        return this._boundaryDetector.isOutsideBoundary();
    }

    @Override
    public boolean isProducerReceiver() {
        return this.isOutsideBoundary() || this.isInsideBoundary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadBlocked() {
        PNDirector pNDirector = this._director;
        synchronized (pNDirector) {
            return this._readPending != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWriteBlocked() {
        PNDirector pNDirector = this._director;
        synchronized (pNDirector) {
            return this._writePending != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Token token) {
        PNDirector pNDirector = this._director;
        synchronized (pNDirector) {
            while (!this._terminate) {
                if (super.hasRoom()) {
                    super.put(token);
                    if (this._readPending != null) {
                        this._director.threadUnblocked(this._readPending, this, PNDirector.READ_BLOCKED);
                        this._readPending = null;
                    }
                    if (this._writePending == null) break;
                    this._director.threadUnblocked(this._writePending, this, PNDirector.WRITE_BLOCKED);
                    this._writePending = null;
                    break;
                }
                try {
                    this._writePending = Thread.currentThread();
                    this._director.threadBlocked(this._writePending, this, PNDirector.WRITE_BLOCKED);
                    Workspace workspace = this.getContainer().workspace();
                    workspace.wait(this._director);
                }
                catch (InterruptedException e) {
                    this._terminate = true;
                }
            }
            if (this._terminate) {
                throw new TerminateProcessException("Process terminated.");
            }
        }
    }

    @Override
    public void reset() {
        if (this._readPending != null) {
            this._director.threadUnblocked(this._readPending, this, PNDirector.READ_BLOCKED);
        }
        if (this._writePending != null) {
            this._director.threadUnblocked(this._writePending, this, PNDirector.WRITE_BLOCKED);
        }
        this._readPending = null;
        this._writePending = null;
        this._terminate = false;
        this._boundaryDetector.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestFinish() {
        PNDirector pNDirector = this._director;
        synchronized (pNDirector) {
            this._terminate = true;
            this._director.notifyAll();
        }
    }
}

