/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class CountTrues
extends SDFTransformer {
    public Parameter blockSize;

    public CountTrues(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.BOOLEAN);
        this.output.setTypeEquals(BaseType.INT);
        this.blockSize = new Parameter((NamedObj)this, "blockSize", new IntToken(1));
        this.blockSize.setTypeEquals(BaseType.INT);
        this.input_tokenConsumptionRate.setExpression("blockSize");
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        CountTrues newObject = (CountTrues)super.clone(workspace);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int count = ((IntToken)this.blockSize.getToken()).intValue();
        Token[] inputBlock = this.input.get(0, count);
        int trueCount = 0;
        for (int i = 0; i < count; ++i) {
            if (!((BooleanToken)inputBlock[i]).booleanValue()) continue;
            ++trueCount;
        }
        this.output.send(0, new IntToken(trueCount));
    }
}

