/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class LineCoder
extends SDFTransformer {
    public Parameter table;
    public Parameter wordLength;
    private int _wordLength;
    private Token[] _table;

    public LineCoder(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.BOOLEAN);
        this.table = new Parameter(this, "table");
        this.table.setExpression("{-1.0, 1.0}");
        this.attributeChanged(this.table);
        this.wordLength = new Parameter((NamedObj)this, "wordLength", new IntToken(1));
        this.wordLength.setTypeEquals(BaseType.INT);
        this.output.setTypeAtLeast(ArrayType.elementType(this.table));
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        LineCoder newObject = (LineCoder)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.table));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int tableAddress = 0;
        Token[] tokens = this.input.get(0, this._wordLength);
        for (int i = 0; i < this._wordLength; ++i) {
            boolean data = ((BooleanToken)tokens[i]).booleanValue();
            if (!data) continue;
            tableAddress |= 1 << i;
        }
        this.output.send(0, this._table[tableAddress]);
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        this._wordLength = ((IntToken)this.wordLength.getToken()).intValue();
        this.input_tokenConsumptionRate.setToken(new IntToken(this._wordLength));
        ArrayToken tableToken = (ArrayToken)this.table.getToken();
        int size = (int)Math.pow(2.0, this._wordLength);
        if (tableToken.length() < size) {
            throw new IllegalActionException((Nameable)this, "Table parameter must have at least " + size + " entries, but only has " + tableToken.length());
        }
        this._table = tableToken.arrayValue();
    }
}

