/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class Repeat
extends SDFTransformer {
    public Parameter numberOfTimes = new Parameter((NamedObj)this, "numberOfTimes", new IntToken(2));
    public Parameter blockSize;

    public Repeat(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.numberOfTimes.setTypeEquals(BaseType.INT);
        this.blockSize = new Parameter((NamedObj)this, "blockSize", new IntToken(1));
        this.blockSize.setTypeEquals(BaseType.INT);
        this.input_tokenConsumptionRate.setExpression("blockSize");
        this.output_tokenProductionRate.setExpression("numberOfTimes*blockSize");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.numberOfTimes || attribute == this.blockSize) {
            int repetitions = ((IntToken)this.numberOfTimes.getToken()).intValue();
            int count = ((IntToken)this.blockSize.getToken()).intValue();
            if (repetitions < 1) {
                throw new IllegalActionException((Nameable)this.numberOfTimes, "The value of numberOfTimes must be positive, but was set to " + repetitions);
            }
            if (count < 1) {
                throw new IllegalActionException((Nameable)this.blockSize, "The value of blockSize must be positive, but was set to " + count);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int repetitions = ((IntToken)this.numberOfTimes.getToken()).intValue();
        int count = ((IntToken)this.blockSize.getToken()).intValue();
        Token[] inputBlock = this.input.get(0, count);
        for (int i = 0; i < repetitions; ++i) {
            this.output.send(0, inputBlock, count);
        }
    }
}

