/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib.vq;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.math.IntegerMatrixMath;
import ptolemy.util.FileUtilities;

public class VQDecode
extends Transformer {
    public Parameter codeBook;
    public Parameter blockCount;
    public Parameter blockWidth;
    public Parameter blockHeight;
    public Parameter input_tokenConsumptionRate;
    public Parameter output_tokenProductionRate;
    private int[][][][] _codebook = new int[6][256][][];
    private Token[] _codewords;
    private IntMatrixToken[] _blocks;
    private int _blockCount;
    private int _blockWidth;
    private int _blockHeight;

    public VQDecode(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.INT);
        this.output.setTypeEquals(BaseType.INT_MATRIX);
        this.codeBook = new Parameter((NamedObj)this, "codeBook", new StringToken("/ptolemy/domains/sdf/lib/vq/data/usc_hvq_s5.dat"));
        this.codeBook.setTypeEquals(BaseType.STRING);
        this.blockCount = new Parameter((NamedObj)this, "blockCount", new IntToken("1"));
        this.blockCount.setTypeEquals(BaseType.INT);
        this.blockWidth = new Parameter((NamedObj)this, "blockWidth", new IntToken("4"));
        this.blockWidth.setTypeEquals(BaseType.INT);
        this.blockHeight = new Parameter((NamedObj)this, "blockHeight", new IntToken("2"));
        this.blockHeight.setTypeEquals(BaseType.INT);
        this.input_tokenConsumptionRate = new Parameter(this.input, "tokenConsumptionRate");
        this.input_tokenConsumptionRate.setTypeEquals(BaseType.INT);
        this.input_tokenConsumptionRate.setExpression("blockCount");
        this.output_tokenProductionRate = new Parameter(this.output, "tokenProductionRate");
        this.output_tokenProductionRate.setTypeEquals(BaseType.INT);
        this.output_tokenProductionRate.setExpression("blockCount");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int stage = this._stages(this._blockWidth * this._blockHeight);
        this._codewords = this.input.get(0, this._blockCount);
        for (int j = 0; j < this._blockCount; ++j) {
            this._blocks[j] = new IntMatrixToken(this._codebook[stage][((IntToken)this._codewords[j]).intValue()]);
        }
        this.output.send(0, this._blocks, this._blocks.length);
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        InputStream source = null;
        this._blockCount = ((IntToken)this.blockCount.getToken()).intValue();
        this._blockWidth = ((IntToken)this.blockWidth.getToken()).intValue();
        this._blockHeight = ((IntToken)this.blockHeight.getToken()).intValue();
        this._codewords = new Token[this._blockCount];
        this._blocks = new IntMatrixToken[this._blockCount];
        String filename = ((StringToken)this.codeBook.getToken()).stringValue();
        try {
            if (filename != null) {
                try {
                    URL dataurl = FileUtilities.nameToURL(filename, null, null);
                    this._debug("VQDecode: codebook = " + dataurl);
                    source = dataurl.openStream();
                }
                catch (MalformedURLException e) {
                    System.err.println(e.toString());
                }
                catch (FileNotFoundException e) {
                    System.err.println("File not found: " + e);
                }
                catch (IOException e) {
                    throw new IllegalActionException("Error reading input file: " + e.getMessage());
                }
            }
            int size = 1;
            int rows = 1;
            int columns = 1;
            for (int i = 0; i < 5; ++i) {
                size *= 2;
                if (i % 2 == 0) {
                    columns *= 2;
                } else {
                    rows *= 2;
                }
                byte[] temp = new byte[size];
                int[] intTemp = new int[size];
                for (int j = 0; j < 256; ++j) {
                    if (this._fullRead(source, temp) != size) {
                        throw new IllegalActionException("Error reading codebook file!");
                    }
                    for (int x = 0; x < size; ++x) {
                        intTemp[x] = temp[x] & 0xFF;
                    }
                    this._codebook[i][j] = IntegerMatrixMath.toMatrixFromArray(intTemp, rows, columns);
                }
                temp = new byte[65536];
                if (this._fullRead(source, temp) == 65536) continue;
                throw new IllegalActionException("Error reading codebook file!");
            }
        }
        catch (Exception e) {
            throw new IllegalActionException(e.getMessage());
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private int _fullRead(InputStream s, byte[] b) throws IOException {
        int length = 0;
        int remaining = b.length;
        int bytesRead = 0;
        while (remaining > 0) {
            bytesRead = s.read(b, length, remaining);
            if (bytesRead == -1) {
                throw new IOException("Unexpected EOF");
            }
            remaining -= bytesRead;
            length += bytesRead;
        }
        return length;
    }

    private int _stages(int length) {
        int x = 0;
        if (length < 2) {
            throw new RuntimeException("Vector length of " + length + "must be greater than 1");
        }
        while (length > 2) {
            length >>= 1;
            ++x;
        }
        return x;
    }
}

