/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import ptolemy.gui.Top;
import ptolemy.util.CancelException;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;

public class GraphicalMessageHandler
extends MessageHandler {
    protected static WeakReference _context = null;

    public static Component getContext() {
        if (_context == null) {
            return null;
        }
        return (Component)_context.get();
    }

    public static void setContext(Component context) {
        _context = new WeakReference<Component>(context);
    }

    @Override
    protected void _error(final String info) {
        Runnable doMessage = new Runnable(){

            @Override
            public void run() {
                Object[] message = new Object[1];
                String string = info;
                message[0] = StringUtilities.ellipsis(string, 400);
                Object[] options = new Object[]{"Dismiss"};
                JOptionPane.showOptionDialog(GraphicalMessageHandler.getContext(), message, "Error", 0, 0, null, options, options[0]);
            }
        };
        Top.deferIfNecessary(doMessage);
    }

    @Override
    protected void _error(final String info, final Throwable throwable) {
        Runnable doMessage = new Runnable(){

            @Override
            public void run() {
                if (throwable instanceof CancelException) {
                    return;
                }
                Object[] message = new Object[1];
                String string = info != null ? info + "\n" + throwable.getMessage() : throwable.getMessage();
                message[0] = StringUtilities.ellipsis(string, 400);
                Object[] options = new Object[]{"Dismiss", "Display Stack Trace"};
                int selected = JOptionPane.showOptionDialog(GraphicalMessageHandler.getContext(), message, MessageHandler.shortDescription(throwable), 0, 0, null, options, options[0]);
                if (selected == 1) {
                    GraphicalMessageHandler.this._showStackTrace(throwable, info);
                }
            }
        };
        Top.deferIfNecessary(doMessage);
    }

    @Override
    protected void _message(final String info) {
        Runnable doMessage = new Runnable(){

            @Override
            public void run() {
                Object[] message = new Object[]{StringUtilities.ellipsis(info, 2000)};
                Object[] options = new Object[]{"OK"};
                JOptionPane.showOptionDialog(GraphicalMessageHandler.getContext(), message, "Message", 0, 1, null, options, options[0]);
            }
        };
        Top.deferIfNecessary(doMessage);
    }

    @Override
    protected void _warning(final String info) throws CancelException {
        if (EventQueue.isDispatchThread()) {
            Object[] options = new Object[]{"OK", "Cancel"};
            Object[] message = new Object[]{StringUtilities.ellipsis(info, 2000)};
            int selected = JOptionPane.showOptionDialog(GraphicalMessageHandler.getContext(), message, "Warning", 0, 2, null, options, options[0]);
            if (selected == 1) {
                throw new CancelException();
            }
        } else {
            Runnable doWarning = new Runnable(){

                @Override
                public void run() {
                    Object[] options = new Object[]{"OK"};
                    Object[] message = new Object[]{StringUtilities.ellipsis(info, 2000)};
                    JOptionPane.showOptionDialog(GraphicalMessageHandler.getContext(), message, "Warning", 0, 2, null, options, options[0]);
                }
            };
            Top.deferIfNecessary(doWarning);
        }
    }

    @Override
    protected void _warning(final String info, final Throwable throwable) throws CancelException {
        if (EventQueue.isDispatchThread()) {
            Object[] message = new Object[]{StringUtilities.ellipsis(info, 2000)};
            Object[] options = new Object[]{"OK", "Display Stack Trace", "Cancel"};
            int selected = JOptionPane.showOptionDialog(GraphicalMessageHandler.getContext(), message, "Warning", 0, 2, null, options, options[0]);
            if (selected == 1) {
                this._showStackTrace(throwable, info);
            } else if (selected == 2) {
                throw new CancelException();
            }
        } else {
            Runnable doWarning = new Runnable(){

                @Override
                public void run() {
                    Object[] message = new Object[]{StringUtilities.ellipsis(info, 2000)};
                    Object[] options = new Object[]{"OK", "Display Stack Trace"};
                    int selected = JOptionPane.showOptionDialog(GraphicalMessageHandler.getContext(), message, "Warning", 0, 2, null, options, options[0]);
                    if (selected == 1) {
                        GraphicalMessageHandler.this._showStackTrace(throwable, info);
                    }
                }
            };
            Top.deferIfNecessary(doWarning);
        }
    }

    @Override
    protected boolean _yesNoQuestion(final String question) {
        if (EventQueue.isDispatchThread()) {
            Object[] message = new Object[]{StringUtilities.ellipsis(question, 2000)};
            Object[] options = new Object[]{"Yes", "No"};
            int selected = JOptionPane.showOptionDialog(GraphicalMessageHandler.getContext(), message, "Warning", 0, 2, null, options, options[0]);
            return selected == 0;
        }
        final Boolean[] result = new Boolean[1];
        Runnable doYesNo = new Runnable(){

            @Override
            public void run() {
                Object[] message = new Object[]{StringUtilities.ellipsis(question, 2000)};
                Object[] options = new Object[]{"Yes", "No"};
                int selected = JOptionPane.showOptionDialog(GraphicalMessageHandler.getContext(), message, "Warning", 0, 2, null, options, options[0]);
                result[0] = selected == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        try {
            SwingUtilities.invokeAndWait(doYesNo);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return result[0];
    }

    @Override
    protected boolean _yesNoCancelQuestion(final String question) throws CancelException {
        if (EventQueue.isDispatchThread()) {
            Object[] message = new Object[]{StringUtilities.ellipsis(question, 2000)};
            Object[] options = new Object[]{"Yes", "No", "Cancel"};
            int selected = JOptionPane.showOptionDialog(GraphicalMessageHandler.getContext(), message, "Warning", 1, 2, null, options, options[0]);
            if (selected == 0) {
                return true;
            }
            if (selected == 2) {
                throw new CancelException();
            }
            return false;
        }
        final Boolean[] results = new Boolean[2];
        Runnable doYesNoCancel = new Runnable(){

            @Override
            public void run() {
                Object[] message = new Object[]{StringUtilities.ellipsis(question, 2000)};
                Object[] options = new Object[]{"Yes", "No", "Cancel"};
                int selected = JOptionPane.showOptionDialog(GraphicalMessageHandler.getContext(), message, "Warning", 1, 2, null, options, options[0]);
                if (selected == 0) {
                    results[0] = Boolean.TRUE;
                } else if (selected == 2) {
                    results[1] = Boolean.TRUE;
                } else {
                    results[0] = Boolean.FALSE;
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(doYesNoCancel);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (results[1] != null && results[1].booleanValue()) {
            throw new CancelException();
        }
        return results[0];
    }

    private void _showStackTrace(Throwable throwable, String info) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        JTextArea text = new JTextArea(sw.toString(), 60, 80);
        JScrollPane stext = new JScrollPane(text);
        stext.setPreferredSize(new Dimension(600, 300));
        text.setCaretPosition(0);
        text.setEditable(false);
        Object[] message = new Object[2];
        String string = info != null ? info + "\n" + throwable.getMessage() : throwable.getMessage();
        message[0] = StringUtilities.ellipsis(string, 2000);
        message[1] = stext;
        JOptionPane.showMessageDialog(GraphicalMessageHandler.getContext(), message, "Stack trace", 0);
    }
}

