/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.attributes.VersionAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedList;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class CompositeEntity
extends ComponentEntity {
    NamedList _containedEntities = new NamedList(this);
    NamedList _containedRelations = new NamedList(this);
    private transient List _classDefinitionListCache;
    private transient long _classDefinitionListVersion = -1L;
    private static String _defaultIcon = "<svg>\n<rect x=\"-30\" y=\"-20\" width=\"60\" height=\"40\" style=\"fill:red\"/>\n<rect x=\"-28\" y=\"-18\" width=\"56\" height=\"36\" style=\"fill:lightgrey\"/>\n<rect x=\"-15\" y=\"-10\" width=\"10\" height=\"8\" style=\"fill:white\"/>\n<rect x=\"-15\" y=\"2\" width=\"10\" height=\"8\" style=\"fill:white\"/>\n<rect x=\"5\" y=\"-4\" width=\"10\" height=\"8\" style=\"fill:white\"/>\n<line x1=\"-5\" y1=\"-6\" x2=\"0\" y2=\"-6\"/><line x1=\"-5\" y1=\"6\" x2=\"0\" y2=\"6\"/><line x1=\"0\" y1=\"-6\" x2=\"0\" y2=\"6\"/><line x1=\"0\" y1=\"0\" x2=\"5\" y2=\"0\"/></svg>\n";
    private transient List _entityListCache;
    private transient long _entityListVersion = -1L;
    private boolean _levelCrossingConnectAllowed = false;

    public CompositeEntity() {
        this._addIcon();
    }

    public CompositeEntity(Workspace workspace) {
        super(workspace);
        this._addIcon();
    }

    public CompositeEntity(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._addIcon();
    }

    public List allAtomicEntityList() {
        LinkedList entities = (LinkedList)this.deepEntityList();
        for (int i = 0; i < entities.size(); ++i) {
            Object entity = entities.get(i);
            if (!(entity instanceof CompositeEntity)) continue;
            entities.remove(i);
            --i;
            entities.addAll(((CompositeEntity)entity).allAtomicEntityList());
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List allCompositeEntityList() {
        try {
            this._workspace.getReadAccess();
            LinkedList<ComponentEntity> result = new LinkedList<ComponentEntity>();
            if (this._containedEntities != null) {
                for (ComponentEntity entity : this._containedEntities.elementList()) {
                    if (entity.isOpaque()) continue;
                    result.add(entity);
                    result.addAll(((CompositeEntity)entity).allCompositeEntityList());
                }
            }
            LinkedList<ComponentEntity> linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public void allowLevelCrossingConnect(boolean boole) {
        this._levelCrossingConnectAllowed = boole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List classDefinitionList() {
        try {
            this._workspace.getReadAccess();
            if (this._workspace.getVersion() == this._classDefinitionListVersion) {
                List list = this._classDefinitionListCache;
                return list;
            }
            LinkedList<ComponentEntity> result = new LinkedList<ComponentEntity>();
            if (this._containedEntities != null) {
                for (ComponentEntity entity : this._containedEntities.elementList()) {
                    if (!entity.isClassDefinition()) continue;
                    result.add(entity);
                }
                this._classDefinitionListCache = result;
                this._classDefinitionListVersion = this._workspace.getVersion();
            }
            LinkedList<ComponentEntity> linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        try {
            this.workspace().getReadAccess();
            CompositeEntity newEntity = (CompositeEntity)super.clone(workspace);
            newEntity._containedEntities = new NamedList(newEntity);
            newEntity._containedRelations = new NamedList(newEntity);
            for (ComponentRelation relation : this.relationList()) {
                ComponentRelation newRelation = (ComponentRelation)relation.clone(workspace);
                try {
                    newRelation.setContainer(newEntity);
                }
                catch (KernelException ex) {
                    throw new CloneNotSupportedException("Failed to clone a CompositeEntity: " + ex.getMessage());
                }
            }
            for (ComponentEntity classDefinition : this.classDefinitionList()) {
                ComponentEntity newSubentity = (ComponentEntity)classDefinition.clone(workspace);
                try {
                    newSubentity.setContainer(newEntity);
                }
                catch (KernelException ex) {
                    throw new CloneNotSupportedException("Failed to clone a CompositeEntity: " + KernelException.stackTraceToString(ex));
                }
            }
            for (ComponentEntity entity : this.entityList()) {
                ComponentEntity newSubentity = (ComponentEntity)entity.clone(workspace);
                try {
                    newSubentity.setContainer(newEntity);
                }
                catch (KernelException ex) {
                    throw new CloneNotSupportedException("Failed to clone a CompositeEntity: " + KernelException.stackTraceToString(ex));
                }
                for (ComponentPort port : entity.portList()) {
                    Enumeration linkedRelations = port.linkedRelations();
                    while (linkedRelations.hasMoreElements()) {
                        ComponentRelation rel = (ComponentRelation)linkedRelations.nextElement();
                        if (rel == null) continue;
                        ComponentRelation newRelation = newEntity.getRelation(rel.getName());
                        Port newPort = newSubentity.getPort(port.getName());
                        try {
                            newPort.link(newRelation);
                        }
                        catch (IllegalActionException ex) {
                            throw new CloneNotSupportedException("Failed to clone a CompositeEntity: " + ex.getMessage());
                        }
                    }
                }
            }
            for (ComponentPort port : this.portList()) {
                for (Relation relation : port.insideRelationList()) {
                    ComponentRelation newRelation = newEntity.getRelation(relation.getName());
                    Port newPort = newEntity.getPort(port.getName());
                    try {
                        newPort.link(newRelation);
                    }
                    catch (IllegalActionException ex) {
                        throw new CloneNotSupportedException("Failed to clone a CompositeEntity: " + ex.getMessage());
                    }
                }
            }
            CompositeEntity compositeEntity = newEntity;
            return compositeEntity;
        }
        finally {
            this.workspace().doneReading();
        }
    }

    public ComponentRelation connect(ComponentPort port1, ComponentPort port2) throws IllegalActionException {
        try {
            return this.connect(port1, port2, this.uniqueName("_R"));
        }
        catch (NameDuplicationException ex) {
            throw new InternalErrorException(this, (Throwable)ex, "Internal error in CompositeEntity.connect() method!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentRelation connect(ComponentPort port1, ComponentPort port2, String relationName) throws IllegalActionException, NameDuplicationException {
        if (port1 == null || port2 == null) {
            throw new IllegalActionException((Nameable)this, "Attempt to connect null port.");
        }
        if (port1.workspace() != port2.workspace() || port1.workspace() != this._workspace) {
            throw new IllegalActionException((Nameable)port1, port2, "Cannot connect ports because workspaces are different.");
        }
        try {
            this._workspace.getWriteAccess();
            ComponentRelation ar = this.newRelation(relationName);
            if (this._levelCrossingConnectAllowed) {
                port1.liberalLink(ar);
            } else {
                port1.link(ar);
            }
            try {
                if (this._levelCrossingConnectAllowed) {
                    port2.liberalLink(ar);
                } else {
                    port2.link(ar);
                }
            }
            catch (IllegalActionException ex) {
                port1.unlink(ar);
                throw ex;
            }
            ComponentRelation componentRelation = ar;
            return componentRelation;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    @Override
    public Iterator containedObjectsIterator() {
        return new ContainedObjectsIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List deepEntityList() {
        try {
            this._workspace.getReadAccess();
            LinkedList<ComponentEntity> result = new LinkedList<ComponentEntity>();
            if (this._containedEntities != null) {
                for (ComponentEntity entity : this._containedEntities.elementList()) {
                    if (entity.isClassDefinition()) continue;
                    if (entity.isOpaque()) {
                        result.add(entity);
                        continue;
                    }
                    result.addAll(((CompositeEntity)entity).deepEntityList());
                }
            }
            LinkedList<ComponentEntity> linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration deepGetEntities() {
        return Collections.enumeration(this.deepEntityList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List entityList() {
        try {
            this._workspace.getReadAccess();
            if (this._workspace.getVersion() == this._entityListVersion) {
                List list = this._entityListCache;
                return list;
            }
            LinkedList<ComponentEntity> result = new LinkedList<ComponentEntity>();
            if (this._containedEntities != null) {
                for (ComponentEntity entity : this._containedEntities.elementList()) {
                    if (entity.isClassDefinition()) continue;
                    result.add(entity);
                }
                this._entityListCache = result;
                this._entityListVersion = this._workspace.getVersion();
            }
            LinkedList<ComponentEntity> linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List entityList(Class filter) {
        try {
            this._workspace.getReadAccess();
            LinkedList<ComponentEntity> result = new LinkedList<ComponentEntity>();
            if (this._containedEntities != null) {
                for (ComponentEntity entity : this._containedEntities.elementList()) {
                    if (!filter.isInstance(entity) || entity.isClassDefinition()) continue;
                    result.add(entity);
                }
            }
            LinkedList<ComponentEntity> linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public String exportLinks(int depth, Collection filter) throws IOException {
        String relationName;
        StringBuffer result = new StringBuffer();
        for (ComponentPort port : this.portList()) {
            Iterator relations = port.insideRelationList().iterator();
            int index = -1;
            boolean useIndex = false;
            while (relations.hasNext()) {
                ++index;
                ComponentRelation relation = (ComponentRelation)relations.next();
                if (relation == null) {
                    useIndex = true;
                    continue;
                }
                if (relation.getDerivedLevel() <= depth && port.getDerivedLevel() <= depth || filter != null && (!filter.contains(relation) || !filter.contains(port) && !filter.contains(port.getContainer())) || !relation.isPersistent()) continue;
                String relationName2 = relation.getContainer() == this ? relation.getName() : relation.getFullName();
                if (useIndex) {
                    useIndex = false;
                    result.append(CompositeEntity._getIndentPrefix(depth) + "<link port=\"" + port.getName() + "\" insertAt=\"" + index + "\" relation=\"" + relationName2 + "\"/>\n");
                    continue;
                }
                result.append(CompositeEntity._getIndentPrefix(depth) + "<link port=\"" + port.getName() + "\" relation=\"" + relationName2 + "\"/>\n");
            }
        }
        for (ComponentEntity entity : this.entityList()) {
            for (ComponentPort port : entity.portList()) {
                Iterator relations = port.linkedRelationList().iterator();
                int index = -1;
                boolean useIndex = false;
                while (relations.hasNext()) {
                    ++index;
                    ComponentRelation relation = (ComponentRelation)relations.next();
                    if (relation == null) {
                        useIndex = true;
                        continue;
                    }
                    if (relation.getDerivedLevel() <= depth && port.getDerivedLevel() <= depth + 1 && port.getContainer().getDerivedLevel() <= depth || filter != null && (!filter.contains(relation) || !filter.contains(port) && !filter.contains(port.getContainer())) || !relation.isPersistent()) continue;
                    relationName = relation.getContainer() == this ? relation.getName() : relation.getFullName();
                    if (useIndex) {
                        useIndex = false;
                        result.append(CompositeEntity._getIndentPrefix(depth) + "<link port=\"" + entity.getName() + "." + port.getName() + "\" insertAt=\"" + index + "\" relation=\"" + relationName + "\"/>\n");
                        continue;
                    }
                    result.append(CompositeEntity._getIndentPrefix(depth) + "<link port=\"" + entity.getName() + "." + port.getName() + "\" relation=\"" + relationName + "\"/>\n");
                }
            }
        }
        HashSet<ComponentRelation> visitedRelations = new HashSet<ComponentRelation>();
        for (ComponentRelation relation : this.relationList()) {
            visitedRelations.add(relation);
            for (Object portOrRelation : relation.linkedObjectsList()) {
                Relation otherRelation;
                if (!(portOrRelation instanceof Relation) || visitedRelations.contains(otherRelation = (Relation)portOrRelation) || relation.getDerivedLevel() <= depth && otherRelation.getDerivedLevel() <= depth || filter != null && (!filter.contains(relation) || !filter.contains(otherRelation))) continue;
                relationName = relation.getContainer() == this ? relation.getName() : relation.getFullName();
                String otherRelationName = otherRelation.getContainer() == this ? otherRelation.getName() : otherRelation.getFullName();
                result.append(CompositeEntity._getIndentPrefix(depth) + "<link relation1=\"" + relationName + "\" relation2=\"" + otherRelationName + "\"/>\n");
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attribute getAttribute(String name) {
        try {
            String[] subnames;
            this._workspace.getReadAccess();
            Attribute result = super.getAttribute(name);
            if (result == null && (subnames = CompositeEntity._splitName(name))[1] != null) {
                ComponentRelation relation;
                ComponentEntity entity = this.getEntity(subnames[0]);
                if (entity != null) {
                    result = entity.getAttribute(subnames[1]);
                }
                if (result == null && (relation = this.getRelation(subnames[0])) != null) {
                    result = relation.getAttribute(subnames[1]);
                }
            }
            Attribute attribute = result;
            return attribute;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration getEntities() {
        return Collections.enumeration(this.entityList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentEntity getEntity(String name) {
        try {
            this._workspace.getReadAccess();
            if (this._containedEntities == null) {
                ComponentEntity componentEntity = null;
                return componentEntity;
            }
            String[] subnames = CompositeEntity._splitName(name);
            if (subnames[1] == null) {
                ComponentEntity componentEntity = (ComponentEntity)this._containedEntities.get(name);
                return componentEntity;
            }
            Nameable match = this._containedEntities.get(subnames[0]);
            if (match == null) {
                ComponentEntity componentEntity = null;
                return componentEntity;
            }
            if (match instanceof CompositeEntity) {
                ComponentEntity componentEntity = ((CompositeEntity)match).getEntity(subnames[1]);
                return componentEntity;
            }
            ComponentEntity componentEntity = null;
            return componentEntity;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Port getPort(String name) {
        try {
            this._workspace.getReadAccess();
            String[] subnames = CompositeEntity._splitName(name);
            if (subnames[1] == null) {
                Port port = super.getPort(name);
                return port;
            }
            ComponentEntity match = this.getEntity(subnames[0]);
            if (match == null) {
                Port port = null;
                return port;
            }
            Port port = match.getPort(subnames[1]);
            return port;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentRelation getRelation(String name) {
        try {
            this._workspace.getReadAccess();
            String[] subnames = CompositeEntity._splitName(name);
            if (subnames[1] == null) {
                ComponentRelation componentRelation = (ComponentRelation)this._containedRelations.get(name);
                return componentRelation;
            }
            ComponentEntity match = this.getEntity(subnames[0]);
            if (match == null) {
                ComponentRelation componentRelation = null;
                return componentRelation;
            }
            if (match instanceof CompositeEntity) {
                ComponentRelation componentRelation = ((CompositeEntity)match).getRelation(subnames[1]);
                return componentRelation;
            }
            ComponentRelation componentRelation = null;
            return componentRelation;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration getRelations() {
        return Collections.enumeration(this.relationList());
    }

    @Override
    public final boolean isAtomic() {
        return false;
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentRelation newRelation(String name) throws IllegalActionException, NameDuplicationException {
        try {
            ComponentRelation rel;
            this._workspace.getWriteAccess();
            ComponentRelation componentRelation = rel = new ComponentRelation(this, name);
            return componentRelation;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public int numEntities() {
        return this.numberOfEntities();
    }

    public int numRelations() {
        return this.numberOfRelations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfEntities() {
        try {
            this._workspace.getReadAccess();
            int n = this.entityList().size();
            return n;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfRelations() {
        try {
            this._workspace.getReadAccess();
            int n = this._containedRelations.size();
            return n;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List relationList() {
        try {
            this._workspace.getReadAccess();
            NamedList relationsCopy = new NamedList(this._containedRelations);
            List list = relationsCopy.elementList();
            return list;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeAllEntities() {
        try {
            this._workspace.getReadAccess();
            for (ComponentEntity entity : this.entityList()) {
                try {
                    entity.setContainer(null);
                }
                catch (KernelException ex) {
                    throw new InternalErrorException(this, (Throwable)ex, "Internal error in CompositeEntity.removeAllEntities() method!");
                    return;
                }
            }
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeAllRelations() {
        try {
            this._workspace.getWriteAccess();
            for (ComponentRelation relation : this.relationList()) {
                try {
                    relation.setContainer(null);
                }
                catch (KernelException ex) {
                    throw new InternalErrorException(this, (Throwable)ex, "Internal error in CompositeEntity.removeAllRelations() method!");
                    return;
                }
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClassDefinition(boolean isClass) throws IllegalActionException {
        if (isClass && !this.isClassDefinition()) {
            try {
                this.workspace().getWriteAccess();
                this._unlinkLevelCrossingLinksToOutside(this);
            }
            finally {
                this.workspace().doneWriting();
            }
        }
        super.setClassDefinition(isClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        if (container == null) {
            try {
                this._workspace.getWriteAccess();
                this._unlinkLevelCrossingLinksToOutside(this);
                super.setContainer(null);
            }
            finally {
                this._workspace.doneWriting();
            }
        } else {
            super.setContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String statistics(String className) throws IllegalActionException {
        try {
            this._workspace.getReadAccess();
            Class<?> clazz = null;
            try {
                if (className != null && className.length() > 0) {
                    clazz = Class.forName(className);
                }
            }
            catch (Exception ex) {
                throw new IllegalActionException(null, ex, "Failed to instantiate \"" + className + "\"");
            }
            List atomicEntities = this.allAtomicEntityList();
            int entityCount = atomicEntities.size();
            int attributeCount = 0;
            int entityClassCount = 0;
            for (ComponentEntity entity : atomicEntities) {
                List attributeList = entity.attributeList();
                attributeCount += attributeList.size();
                if (clazz == null) continue;
                if (clazz.isAssignableFrom(entity.getClass())) {
                    ++entityClassCount;
                    continue;
                }
                for (Attribute attribute : attributeList) {
                    if (!clazz.isAssignableFrom(attribute.getClass())) continue;
                    ++entityClassCount;
                }
            }
            List relationList = this.relationList();
            int compositeEntityCount = 0;
            int relationCount = relationList.size();
            if (clazz != null) {
                for (Relation relation : relationList) {
                    if (!clazz.isAssignableFrom(relation.getClass())) continue;
                    ++entityClassCount;
                }
            }
            for (Entity entity : this.allCompositeEntityList()) {
                if (!(entity instanceof CompositeEntity)) continue;
                ++compositeEntityCount;
                relationList = ((CompositeEntity)entity).relationList();
                relationCount += relationList.size();
                if (clazz == null) continue;
                if (clazz.isAssignableFrom(entity.getClass())) {
                    ++entityClassCount;
                    continue;
                }
                for (Relation relation : relationList) {
                    if (!clazz.isAssignableFrom(relation.getClass())) continue;
                    ++entityClassCount;
                }
            }
            String string = "Size Statistics for " + this.getFullName() + "\nAtomicEntities: " + entityCount + "\nCompositeEntities: " + compositeEntityCount + "\nRelations: " + relationCount + "\nAttributes: " + attributeCount + (clazz == null ? "" : "\nEntities of type \"" + clazz.getName() + "\": " + entityClassCount);
            return string;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    @Override
    public String uniqueName(String prefix) {
        if (prefix == null) {
            prefix = "null";
        }
        String candidate = prefix = CompositeEntity._stripNumericSuffix(prefix);
        try {
            int depth = this.getPrototypeList().size();
            if (depth > 0) {
                prefix = prefix + "_" + depth + "_";
            }
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        int uniqueNameIndex = 2;
        while (this.getAttribute(candidate) != null || this.getPort(candidate) != null || this.getEntity(candidate) != null || this.getRelation(candidate) != null) {
            candidate = prefix + uniqueNameIndex++;
        }
        return candidate;
    }

    protected void _addEntity(ComponentEntity entity) throws IllegalActionException, NameDuplicationException {
        if (entity.deepContains(this)) {
            throw new IllegalActionException((Nameable)entity, this, "Attempt to construct recursive containment");
        }
        this._containedEntities.append(entity);
    }

    protected void _addRelation(ComponentRelation relation) throws IllegalActionException, NameDuplicationException {
        this._containedRelations.append(relation);
    }

    @Override
    protected void _adjustDeferrals() throws IllegalActionException {
        super._adjustDeferrals();
        for (NamedObj containedObject : this.classDefinitionList()) {
            if (!(containedObject instanceof ComponentEntity)) continue;
            ((ComponentEntity)containedObject)._adjustDeferrals();
        }
        for (NamedObj containedObject : this.entityList()) {
            if (!(containedObject instanceof ComponentEntity)) continue;
            ((ComponentEntity)containedObject)._adjustDeferrals();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _description(int detail, int indent, int bracket) {
        try {
            this._workspace.getReadAccess();
            StringBuffer result = new StringBuffer();
            if (bracket == 1 || bracket == 2) {
                result.append(super._description(detail, indent, 1));
            } else {
                result.append(super._description(detail, indent, 0));
            }
            if ((detail & 8) != 0) {
                if (result.toString().trim().length() > 0) {
                    result.append(" ");
                }
                result.append("classes {\n");
                for (ComponentEntity entity : this.classDefinitionList()) {
                    result.append(entity._description(detail, indent + 1, 2) + "\n");
                }
                result.append(CompositeEntity._getIndentPrefix(indent) + "} entities {\n");
                for (ComponentEntity entity : this.entityList()) {
                    result.append(entity._description(detail, indent + 1, 2) + "\n");
                }
                result.append(CompositeEntity._getIndentPrefix(indent) + "} relations {\n");
                for (Relation relation : this.relationList()) {
                    result.append(relation._description(detail, indent + 1, 2) + "\n");
                }
                result.append(CompositeEntity._getIndentPrefix(indent) + "}");
            }
            if (bracket == 2) {
                result.append("}");
            }
            String string = result.toString();
            return string;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    @Override
    protected void _exportMoMLContents(Writer output, int depth) throws IOException {
        if (depth == 1 && this.getContainer() == null) {
            if (this.getAttribute("_createdBy") == null) {
                output.write(CompositeEntity._getIndentPrefix(depth) + "<property name=\"_createdBy\" " + "class=\"" + VersionAttribute.CURRENT_VERSION.getClass().getName() + "\" value=\"" + VersionAttribute.CURRENT_VERSION.getExpression() + "\">\n");
                output.write(CompositeEntity._getIndentPrefix(depth) + "</property>\n");
            } else if (this.getAttribute("_createdBy") != null) {
                try {
                    ((VersionAttribute)this.getAttribute("_createdBy")).setExpression(VersionAttribute.CURRENT_VERSION.getExpression());
                }
                catch (IllegalActionException ex) {
                    throw new InternalErrorException(this, (Throwable)ex, "Failed to update _createdBy");
                }
            }
        }
        super._exportMoMLContents(output, depth);
        for (ComponentEntity entity : this.classDefinitionList()) {
            entity.exportMoML(output, depth);
        }
        for (ComponentEntity entity : this.entityList()) {
            entity.exportMoML(output, depth);
        }
        for (ComponentRelation relation : this.relationList()) {
            relation.exportMoML(output, depth);
        }
        output.write(this.exportLinks(depth, null));
    }

    protected void _finishedAddEntity(ComponentEntity entity) {
    }

    protected void _removeEntity(ComponentEntity entity) {
        this._containedEntities.remove(entity);
    }

    protected void _removeRelation(ComponentRelation relation) {
        this._containedRelations.remove(relation);
    }

    @Override
    protected void _validateSettables(Collection attributesValidated) throws IllegalActionException {
        super._validateSettables(attributesValidated);
        for (Entity entity : this.classDefinitionList()) {
            block15: {
                if (entity instanceof Settable) {
                    try {
                        Collection validated = ((Settable)((Object)entity)).validate();
                        if (validated != null) {
                            attributesValidated.addAll(validated);
                        }
                        attributesValidated.add(entity);
                    }
                    catch (IllegalActionException ex) {
                        if (this.handleModelError(this, ex)) break block15;
                        throw ex;
                    }
                }
            }
            entity._validateSettables(attributesValidated);
        }
        for (Entity entity : this.entityList()) {
            block16: {
                if (entity instanceof Settable) {
                    try {
                        Collection validated = ((Settable)((Object)entity)).validate();
                        if (validated != null) {
                            attributesValidated.addAll(validated);
                        }
                        attributesValidated.add(entity);
                    }
                    catch (IllegalActionException ex) {
                        if (this.handleModelError(this, ex)) break block16;
                        throw ex;
                    }
                }
            }
            entity._validateSettables(attributesValidated);
        }
        for (Relation relation : this.relationList()) {
            block17: {
                if (relation instanceof Settable) {
                    try {
                        Collection validated = ((Settable)((Object)relation)).validate();
                        if (validated != null) {
                            attributesValidated.addAll(validated);
                        }
                        attributesValidated.add(relation);
                    }
                    catch (IllegalActionException ex) {
                        if (this.handleModelError(this, ex)) break block17;
                        throw ex;
                    }
                }
            }
            relation.validateSettables();
        }
    }

    private void _addIcon() {
        this._attachText("_iconDescription", _defaultIcon);
    }

    private void _unlinkLevelCrossingLinksToOutside(CompositeEntity entity) {
        for (ComponentRelation relation : entity.relationList()) {
            for (Object linkedObject : relation.linkedObjectsList()) {
                NamedObj linkedObjectContainer;
                NamedObj relationContainer = relation.getContainer();
                if (linkedObject instanceof Relation) {
                    Relation linkedRelation = (Relation)linkedObject;
                    linkedObjectContainer = linkedRelation.getContainer();
                    if (relationContainer == linkedObjectContainer || linkedObjectContainer.getContainer() == relationContainer) continue;
                    relation.unlink(linkedRelation);
                    continue;
                }
                Port linkedPort = (Port)linkedObject;
                linkedObjectContainer = linkedPort.getContainer();
                if (relationContainer == linkedObjectContainer || linkedObjectContainer.getContainer() == relationContainer) continue;
                linkedPort.unlink(relation);
            }
        }
        for (ComponentEntity containedEntity : entity.entityList()) {
            if (containedEntity instanceof CompositeEntity) {
                this._unlinkLevelCrossingLinksToOutside((CompositeEntity)containedEntity);
            }
            for (ComponentPort port : containedEntity.portList()) {
                for (ComponentRelation relation : port.linkedRelationList()) {
                    if (relation == null || this.deepContains(relation)) continue;
                    port.unlink(relation);
                }
            }
        }
    }

    protected class ContainedObjectsIterator
    extends Entity.ContainedObjectsIterator {
        private Iterator _classListIterator;
        private Iterator _entityListIterator;
        private Iterator _relationListIterator;

        public ContainedObjectsIterator() {
            super(CompositeEntity.this);
            this._classListIterator = null;
            this._entityListIterator = null;
            this._relationListIterator = null;
            this._classListIterator = CompositeEntity.this.classDefinitionList().iterator();
            this._entityListIterator = CompositeEntity.this.entityList().iterator();
            this._relationListIterator = CompositeEntity.this.relationList().iterator();
        }

        @Override
        public boolean hasNext() {
            if (super.hasNext()) {
                return true;
            }
            if (this._classListIterator.hasNext()) {
                return true;
            }
            if (this._entityListIterator.hasNext()) {
                return true;
            }
            return this._relationListIterator.hasNext();
        }

        @Override
        public Object next() {
            if (super.hasNext()) {
                return super.next();
            }
            if (this._classListIterator.hasNext()) {
                return this._classListIterator.next();
            }
            if (this._entityListIterator.hasNext()) {
                return this._entityListIterator.next();
            }
            return this._relationListIterator.next();
        }

        @Override
        public void remove() {
            super.remove();
        }
    }
}

