/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public final class NamedList
implements Cloneable,
Serializable {
    private Nameable _container;
    private LinkedList _namedList = new LinkedList();
    private static final String _NULL_NAME_EXCEPTION_STRING = "Attempt to add an object with a null name to a NamedList.";

    public NamedList() {
    }

    public NamedList(Nameable container) {
        this._container = container;
    }

    public NamedList(NamedList original) {
        if (original != null) {
            this._namedList.addAll(original.elementList());
        }
        this._container = null;
    }

    public void append(Nameable element) throws IllegalActionException, NameDuplicationException {
        String newName = element.getName();
        if (newName == null) {
            throw new IllegalActionException(this._container, _NULL_NAME_EXCEPTION_STRING);
        }
        if (this.get(newName) != null) {
            throw new NameDuplicationException(this._container, element);
        }
        this._namedList.add(element);
    }

    public Object clone() {
        return new NamedList(this);
    }

    public List elementList() {
        return Collections.unmodifiableList(this._namedList);
    }

    public Enumeration elements() {
        return Collections.enumeration(this._namedList);
    }

    public Nameable first() throws NoSuchElementException {
        return (Nameable)this._namedList.getFirst();
    }

    public Nameable get(String name) {
        for (Nameable obj : this._namedList) {
            if (!name.equals(obj.getName())) continue;
            return obj;
        }
        return null;
    }

    public boolean includes(Nameable element) {
        return this._namedList.contains(element);
    }

    public void insertAfter(String name, Nameable element) throws IllegalActionException, NameDuplicationException {
        int index = this._getIndexOf(name);
        if (index == -1) {
            this.append(element);
        } else {
            this._insertAt(index + 1, element);
        }
    }

    public void insertBefore(String name, Nameable element) throws IllegalActionException, NameDuplicationException {
        int index = this._getIndexOf(name);
        if (index == -1) {
            this.prepend(element);
        } else {
            this._insertAt(index, element);
        }
    }

    public Nameable last() throws NoSuchElementException {
        return (Nameable)this._namedList.getLast();
    }

    public int moveDown(Nameable element) throws IllegalActionException {
        int index = this._namedList.indexOf(element);
        if (index < 0) {
            throw new IllegalActionException(element, "Not on the list.");
        }
        if (index < this._namedList.size() - 1) {
            this._namedList.remove(element);
            this._namedList.add(index + 1, element);
            return index;
        }
        return -1;
    }

    public int moveToFirst(Nameable element) throws IllegalActionException {
        int index = this._namedList.indexOf(element);
        if (index < 0) {
            throw new IllegalActionException(element, "Not on the list.");
        }
        if (index > 0) {
            this._namedList.remove(element);
            this._namedList.add(0, element);
            return index;
        }
        return -1;
    }

    public int moveToIndex(Nameable element, int index) throws IllegalActionException {
        int priorIndex = this._namedList.indexOf(element);
        if (priorIndex < 0) {
            throw new IllegalActionException(element, "Not on the list.");
        }
        if (index < 0 || index >= this._namedList.size()) {
            throw new IllegalActionException(element, "Index out of range.");
        }
        if (priorIndex != index) {
            this._namedList.remove(element);
            this._namedList.add(index, element);
            return priorIndex;
        }
        return -1;
    }

    public int moveToLast(Nameable element) throws IllegalActionException {
        int index = this._namedList.indexOf(element);
        if (index < 0) {
            throw new IllegalActionException(element, "Not on the list.");
        }
        if (index < this._namedList.size() - 1) {
            this._namedList.remove(element);
            this._namedList.add(element);
            return index;
        }
        return -1;
    }

    public int moveUp(Nameable element) throws IllegalActionException {
        int index = this._namedList.indexOf(element);
        if (index < 0) {
            throw new IllegalActionException(element, "Not on the list.");
        }
        if (index > 0) {
            this._namedList.remove(element);
            this._namedList.add(index - 1, element);
            return index;
        }
        return -1;
    }

    public void prepend(Nameable element) throws IllegalActionException, NameDuplicationException {
        this._insertAt(0, element);
    }

    public void remove(Nameable element) {
        this._namedList.remove(element);
    }

    public Nameable remove(String name) {
        Nameable element = this.get(name);
        if (element != null) {
            this.remove(element);
            return element;
        }
        return null;
    }

    public void removeAll() {
        this._namedList.clear();
    }

    public int size() {
        return this._namedList.size();
    }

    private int _getIndexOf(String name) {
        Iterator iterator = this._namedList.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            Nameable obj = (Nameable)iterator.next();
            if (name.equals(obj.getName())) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    private void _insertAt(int index, Nameable element) throws IllegalActionException, NameDuplicationException {
        if (element.getName() == null) {
            throw new IllegalActionException(this._container, _NULL_NAME_EXCEPTION_STRING);
        }
        if (this.get(element.getName()) == null) {
            this._namedList.add(index, element);
            return;
        }
        throw new NameDuplicationException(this._container, element);
    }
}

