/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Complex;
import ptolemy.math.ComplexArrayMath;
import ptolemy.math.ComplexBinaryOperation;
import ptolemy.math.ComplexUnaryOperation;

public class ComplexMatrixMath {
    private ComplexMatrixMath() {
    }

    public static final Complex[][] add(Complex[][] matrix, Complex z) {
        Complex[][] returnValue = new Complex[ComplexMatrixMath._rows(matrix)][ComplexMatrixMath._columns(matrix)];
        for (int i = 0; i < ComplexMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < ComplexMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j].add(z);
            }
        }
        return returnValue;
    }

    public static final Complex[][] add(Complex[][] matrix1, Complex[][] matrix2) {
        ComplexMatrixMath._checkSameDimension("add", matrix1, matrix2);
        Complex[][] returnValue = new Complex[ComplexMatrixMath._rows(matrix1)][ComplexMatrixMath._columns(matrix1)];
        for (int i = 0; i < ComplexMatrixMath._rows(matrix1); ++i) {
            for (int j = 0; j < ComplexMatrixMath._columns(matrix1); ++j) {
                returnValue[i][j] = matrix1[i][j].add(matrix2[i][j]);
            }
        }
        return returnValue;
    }

    public static final Complex[][] allocCopy(Complex[][] matrix) {
        return ComplexMatrixMath.crop(matrix, 0, 0, ComplexMatrixMath._rows(matrix), ComplexMatrixMath._columns(matrix));
    }

    public static final Complex[][] applyBinaryOperation(ComplexBinaryOperation op, Complex z, Complex[][] matrix) {
        int rows = ComplexMatrixMath._rows(matrix);
        int columns = ComplexMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(z, matrix[i][j]);
            }
        }
        return returnValue;
    }

    public static final Complex[][] applyBinaryOperation(ComplexBinaryOperation op, Complex[][] matrix, Complex z) {
        int rows = ComplexMatrixMath._rows(matrix);
        int columns = ComplexMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix[i][j], z);
            }
        }
        return returnValue;
    }

    public static final Complex[][] applyBinaryOperation(ComplexBinaryOperation op, Complex[][] matrix1, Complex[][] matrix2) {
        int rows = ComplexMatrixMath._rows(matrix1);
        int columns = ComplexMatrixMath._columns(matrix1);
        ComplexMatrixMath._checkSameDimension("applyBinaryOperation", matrix1, matrix2);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix1[i][j], matrix2[i][j]);
            }
        }
        return returnValue;
    }

    public static final Complex[][] applyUnaryOperation(ComplexUnaryOperation op, Complex[][] matrix) {
        int rows = ComplexMatrixMath._rows(matrix);
        int columns = ComplexMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix[i][j]);
            }
        }
        return returnValue;
    }

    public static final Complex[][] conjugate(Complex[][] matrix) {
        int rows = ComplexMatrixMath._rows(matrix);
        int columns = ComplexMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j].conjugate();
            }
        }
        return returnValue;
    }

    public static final Complex[][] conjugateTranspose(Complex[][] matrix) {
        int rows = ComplexMatrixMath._rows(matrix);
        int columns = ComplexMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[columns][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[j][i] = matrix[i][j].conjugate();
            }
        }
        return returnValue;
    }

    public static final Complex[][] crop(Complex[][] matrix, int rowStart, int colStart, int rowSpan, int colSpan) {
        Complex[][] returnValue = new Complex[rowSpan][colSpan];
        for (int i = 0; i < rowSpan; ++i) {
            System.arraycopy(matrix[rowStart + i], colStart, returnValue[i], 0, colSpan);
        }
        return returnValue;
    }

    public static final Complex determinant(Complex[][] matrix) {
        ComplexMatrixMath._checkSquare("determinant", matrix);
        Complex det = Complex.ONE;
        int n = ComplexMatrixMath._rows(matrix);
        Complex[][] a = ComplexMatrixMath.allocCopy(matrix);
        for (int pivot = 0; pivot < n - 1; ++pivot) {
            double big = a[pivot][pivot].magnitudeSquared();
            int swapRow = 0;
            for (int row = pivot + 1; row < n; ++row) {
                double magSquaredElement = a[row][pivot].magnitudeSquared();
                if (!(magSquaredElement > big)) continue;
                swapRow = row;
                big = magSquaredElement;
            }
            if (swapRow != 0) {
                Complex[] aPtr = a[pivot];
                a[pivot] = a[swapRow];
                a[swapRow] = aPtr;
                det = det.multiply(a[pivot][pivot].negate());
            } else {
                det = det.multiply(a[pivot][pivot]);
            }
            if (det.magnitudeSquared() <= 1.0E-9) {
                return Complex.ZERO;
            }
            Complex pivotInverse = a[pivot][pivot].reciprocal();
            for (int col = pivot + 1; col < n; ++col) {
                a[pivot][col] = a[pivot][col].multiply(pivotInverse);
            }
            for (int row = pivot + 1; row < n; ++row) {
                Complex temp = a[row][pivot];
                for (int col = pivot + 1; col < n; ++col) {
                    a[row][col] = a[row][col].subtract(a[pivot][col].multiply(temp));
                }
            }
        }
        det = det.multiply(a[n - 1][n - 1]);
        return det;
    }

    public static final Complex[][] diag(Complex[] array) {
        int n = array.length;
        Complex[][] returnValue = new Complex[n][n];
        ComplexMatrixMath._zeroMatrix(returnValue, n, n);
        for (int i = 0; i < n; ++i) {
            returnValue[i][i] = array[i];
        }
        return returnValue;
    }

    public static final Complex[][] divide(Complex[][] matrix, Complex z) {
        Complex[][] returnValue = new Complex[ComplexMatrixMath._rows(matrix)][ComplexMatrixMath._columns(matrix)];
        for (int i = 0; i < ComplexMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < ComplexMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j].divide(z);
            }
        }
        return returnValue;
    }

    public static final Complex[][] divideElements(Complex[][] matrix1, Complex[][] matrix2) {
        int rows = ComplexMatrixMath._rows(matrix1);
        int columns = ComplexMatrixMath._columns(matrix1);
        ComplexMatrixMath._checkSameDimension("divideElements", matrix1, matrix2);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j].divide(matrix2[i][j]);
            }
        }
        return returnValue;
    }

    public static final Complex[] fromMatrixToArray(Complex[][] matrix) {
        return ComplexMatrixMath.fromMatrixToArray(matrix, ComplexMatrixMath._rows(matrix), ComplexMatrixMath._columns(matrix));
    }

    public static final Complex[] fromMatrixToArray(Complex[][] matrix, int maxRow, int maxCol) {
        Complex[] returnValue = new Complex[maxRow * maxCol];
        for (int i = 0; i < maxRow; ++i) {
            System.arraycopy(matrix[i], 0, returnValue, i * maxCol, maxCol);
        }
        return returnValue;
    }

    public static final Complex[][] identity(int dim) {
        Complex[][] returnValue = new Complex[dim][dim];
        ComplexMatrixMath._zeroMatrix(returnValue, dim, dim);
        for (int i = 0; i < dim; ++i) {
            returnValue[i][i] = Complex.ONE;
        }
        return returnValue;
    }

    public static final Complex[][] identityMatrixComplex(int dim) {
        return ComplexMatrixMath.identity(dim);
    }

    public static final double[][] imagParts(Complex[][] matrix) {
        int rows = ComplexMatrixMath._rows(matrix);
        int columns = ComplexMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j].imag;
            }
        }
        return returnValue;
    }

    public static final Complex[][] inverse(Complex[][] A) {
        ComplexMatrixMath._checkSquare("inverse", A);
        int n = ComplexMatrixMath._rows(A);
        Complex[][] Ai = ComplexMatrixMath.allocCopy(A);
        int[] pivotFlag = new int[n];
        int[] swapCol = new int[n];
        int[] swapRow = new int[n];
        int irow = 0;
        int icol = 0;
        for (int i = 0; i < n; ++i) {
            int col;
            double big = 0.0;
            for (int row = 0; row < n; ++row) {
                if (pivotFlag[row] != 0) continue;
                for (col = 0; col < n; ++col) {
                    double magSquaredElement;
                    if (pivotFlag[col] != 0 || !((magSquaredElement = Ai[row][col].magnitudeSquared()) >= big)) continue;
                    big = magSquaredElement;
                    irow = row;
                    icol = col;
                }
            }
            int n2 = icol;
            pivotFlag[n2] = pivotFlag[n2] + 1;
            if (irow != icol) {
                for (int col2 = 0; col2 < n; ++col2) {
                    Complex temp = Ai[irow][col2];
                    Ai[irow][col2] = Ai[icol][col2];
                    Ai[icol][col2] = temp;
                }
            }
            swapRow[i] = irow;
            swapCol[i] = icol;
            if (Ai[icol][icol].equals(Complex.ZERO)) {
                return null;
            }
            Complex pivotInverse = Ai[icol][icol].reciprocal();
            Ai[icol][icol] = Complex.ONE;
            for (col = 0; col < n; ++col) {
                Ai[icol][col] = Ai[icol][col].multiply(pivotInverse);
            }
            for (int row = 0; row < n; ++row) {
                if (row == icol) continue;
                Complex temp = Ai[row][icol];
                Ai[row][icol] = Complex.ZERO;
                for (int col3 = 0; col3 < n; ++col3) {
                    Ai[row][col3] = Ai[row][col3].subtract(Ai[icol][col3].multiply(temp));
                }
            }
        }
        for (int swap = n - 1; swap >= 0; --swap) {
            if (swapRow[swap] == swapCol[swap]) continue;
            for (int row = 0; row < n; ++row) {
                Complex temp = Ai[row][swapRow[swap]];
                Ai[row][swapRow[swap]] = Ai[row][swapCol[swap]];
                Ai[row][swapCol[swap]] = temp;
            }
        }
        return Ai;
    }

    public static final void matrixCopy(Complex[][] srcMatrix, Complex[][] destMatrix) {
        ComplexMatrixMath.matrixCopy(srcMatrix, 0, 0, destMatrix, 0, 0, ComplexMatrixMath._rows(srcMatrix), ComplexMatrixMath._columns(srcMatrix));
    }

    public static final void matrixCopy(Complex[][] srcMatrix, int srcRowStart, int srcColStart, Complex[][] destMatrix, int destRowStart, int destColStart, int rowSpan, int colSpan) {
        for (int i = 0; i < rowSpan; ++i) {
            System.arraycopy(srcMatrix[srcRowStart + i], srcColStart, destMatrix[destRowStart + i], destColStart, colSpan);
        }
    }

    public static final Complex[][] multiply(Complex[][] matrix, double scaleFactor) {
        int rows = ComplexMatrixMath._rows(matrix);
        int columns = ComplexMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j].scale(scaleFactor);
            }
        }
        return returnValue;
    }

    public static final Complex[][] multiply(Complex[][] matrix, Complex z) {
        int rows = ComplexMatrixMath._rows(matrix);
        int columns = ComplexMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j].multiply(z);
            }
        }
        return returnValue;
    }

    public static final Complex[] multiply(Complex[][] matrix, Complex[] array) {
        int rows = ComplexMatrixMath._rows(matrix);
        int columns = ComplexMatrixMath._columns(matrix);
        if (rows != array.length) {
            throw new IllegalArgumentException("preMultiply : array does not have the same number of elements (" + array.length + ") as the number of rows " + "of the matrix (" + rows + ")");
        }
        Complex[] returnValue = new Complex[columns];
        for (int i = 0; i < columns; ++i) {
            Complex sum = Complex.ZERO;
            for (int j = 0; j < rows; ++j) {
                sum = sum.add(matrix[j][i].multiply(array[j]));
            }
            returnValue[i] = sum;
        }
        return returnValue;
    }

    public static final Complex[] multiply(Complex[] array, Complex[][] matrix) {
        int rows = ComplexMatrixMath._rows(matrix);
        int columns = ComplexMatrixMath._columns(matrix);
        if (columns != array.length) {
            throw new IllegalArgumentException("postMultiply() : array does not have the same number of elements (" + array.length + ") as the number of " + "columns of the matrix (" + columns + ")");
        }
        Complex[] returnValue = new Complex[rows];
        for (int i = 0; i < rows; ++i) {
            Complex sum = Complex.ZERO;
            for (int j = 0; j < columns; ++j) {
                sum = sum.add(matrix[i][j].multiply(array[j]));
            }
            returnValue[i] = sum;
        }
        return returnValue;
    }

    public static final Complex[][] multiply(Complex[][] matrix1, Complex[][] matrix2) {
        Complex[][] returnValue = new Complex[ComplexMatrixMath._rows(matrix1)][matrix2[0].length];
        for (int i = 0; i < ComplexMatrixMath._rows(matrix1); ++i) {
            for (int j = 0; j < matrix2[0].length; ++j) {
                Complex sum = Complex.ZERO;
                for (int k = 0; k < matrix2.length; ++k) {
                    sum = sum.add(matrix1[i][k].multiply(matrix2[k][j]));
                }
                returnValue[i][j] = sum;
            }
        }
        return returnValue;
    }

    public static final Complex[][] multiplyElements(Complex[][] matrix1, Complex[][] matrix2) {
        int rows = ComplexMatrixMath._rows(matrix1);
        int columns = ComplexMatrixMath._columns(matrix1);
        ComplexMatrixMath._checkSameDimension("multiplyElements", matrix1, matrix2);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j].multiply(matrix2[i][j]);
            }
        }
        return returnValue;
    }

    public static final Complex[][] negative(Complex[][] matrix) {
        int rows = ComplexMatrixMath._rows(matrix);
        int columns = ComplexMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j].negate();
            }
        }
        return returnValue;
    }

    public static final Complex[][] orthogonalizeColumns(Complex[][] matrix) {
        Object[] orthoInfo = ComplexMatrixMath._orthogonalizeRows(ComplexMatrixMath.transpose(matrix));
        return ComplexMatrixMath.transpose((Complex[][])orthoInfo[0]);
    }

    public static final Complex[][] orthogonalizeRows(Complex[][] matrix) {
        Object[] orthoInfo = ComplexMatrixMath._orthogonalizeRows(matrix);
        return (Complex[][])orthoInfo[0];
    }

    public static final Complex[][] orthonormalizeColumns(Complex[][] matrix) {
        return ComplexMatrixMath.transpose(ComplexMatrixMath.orthogonalizeRows(ComplexMatrixMath.transpose(matrix)));
    }

    public static final Complex[][] orthonormalizeRows(Complex[][] matrix) {
        int rows = ComplexMatrixMath._rows(matrix);
        Object[] orthoInfo = ComplexMatrixMath._orthogonalizeRows(matrix);
        Complex[][] orthogonalMatrix = (Complex[][])orthoInfo[0];
        Complex[] oneOverNormSquaredArray = (Complex[])orthoInfo[2];
        for (int i = 0; i < rows; ++i) {
            orthogonalMatrix[i] = ComplexArrayMath.scale(orthogonalMatrix[i], oneOverNormSquaredArray[i].sqrt());
        }
        return orthogonalMatrix;
    }

    public static final double[][] realParts(Complex[][] matrix) {
        int rows = ComplexMatrixMath._rows(matrix);
        int columns = ComplexMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j].real;
            }
        }
        return returnValue;
    }

    public static final Complex[][] subtract(Complex[][] matrix1, Complex[][] matrix2) {
        ComplexMatrixMath._checkSameDimension("subtract", matrix1, matrix2);
        int rows = ComplexMatrixMath._rows(matrix1);
        int columns = ComplexMatrixMath._columns(matrix1);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j].subtract(matrix2[i][j]);
            }
        }
        return returnValue;
    }

    public static final Complex sum(Complex[][] matrix) {
        Complex sum = Complex.ZERO;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                sum = sum.add(matrix[i][j]);
            }
        }
        return sum;
    }

    public static final Complex[][] toMatrixFromArray(Complex[] array, int rows, int cols) {
        Complex[][] returnValue = new Complex[rows][cols];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(array, i * cols, returnValue[i], 0, cols);
        }
        return returnValue;
    }

    public static final String toString(Complex[][] matrix) {
        return ComplexMatrixMath.toString(matrix, ", ", "{", "}", "{", ", ", "}");
    }

    public static final String toString(Complex[][] matrix, String elementDelimiter, String matrixBegin, String matrixEnd, String vectorBegin, String vectorDelimiter, String vectorEnd) {
        StringBuffer sb = new StringBuffer();
        sb.append(matrixBegin);
        for (int i = 0; i < ComplexMatrixMath._rows(matrix); ++i) {
            sb.append(vectorBegin);
            for (int j = 0; j < ComplexMatrixMath._columns(matrix); ++j) {
                sb.append(matrix[i][j].toString());
                if (j >= ComplexMatrixMath._columns(matrix) - 1) continue;
                sb.append(elementDelimiter);
            }
            sb.append(vectorEnd);
            if (i >= ComplexMatrixMath._rows(matrix) - 1) continue;
            sb.append(vectorDelimiter);
        }
        sb.append(matrixEnd);
        return sb.toString();
    }

    public static final Complex trace(Complex[][] matrix) {
        int dim = ComplexMatrixMath._checkSquare("trace", matrix);
        Complex sum = Complex.ZERO;
        for (int i = 0; i < dim; ++i) {
            sum = sum.add(matrix[i][i]);
        }
        return sum;
    }

    public static final Complex[][] transpose(Complex[][] matrix) {
        int rows = ComplexMatrixMath._rows(matrix);
        int columns = ComplexMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[columns][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[j][i] = matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final boolean within(Complex[][] matrix1, Complex[][] matrix2, Complex maxError) {
        return ComplexMatrixMath.within(matrix1, matrix2, maxError.magnitude());
    }

    public static final boolean within(Complex[][] matrix1, Complex[][] matrix2, double maxError) {
        ComplexMatrixMath._checkSameDimension("within", matrix1, matrix2);
        int rows = ComplexMatrixMath._rows(matrix1);
        int columns = ComplexMatrixMath._columns(matrix1);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (matrix1[i][j].isCloseTo(matrix2[i][j], maxError)) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean within(Complex[][] matrix1, Complex[][] matrix2, double[][] maxError) {
        ComplexMatrixMath._checkSameDimension("within", matrix1, matrix2);
        int rows = ComplexMatrixMath._rows(matrix1);
        int columns = ComplexMatrixMath._columns(matrix1);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (matrix1[i][j].isCloseTo(matrix2[i][j], maxError[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean within(Complex[][] matrix1, Complex[][] matrix2, Complex[][] maxError) {
        int rows = ComplexMatrixMath._rows(maxError);
        int columns = ComplexMatrixMath._columns(maxError);
        double[][] doubleError = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                doubleError[i][j] = maxError[i][j].magnitude();
            }
        }
        return ComplexMatrixMath.within(matrix1, matrix2, doubleError);
    }

    public static final Complex[][] zero(int rows, int columns) {
        return ComplexMatrixMath._zeroMatrix(new Complex[rows][columns], rows, columns);
    }

    protected static final void _checkSameDimension(String caller, Complex[][] matrix1, Complex[][] matrix2) {
        int rows = ComplexMatrixMath._rows(matrix1);
        int columns = ComplexMatrixMath._columns(matrix1);
        if (rows != ComplexMatrixMath._rows(matrix2) || columns != ComplexMatrixMath._columns(matrix2)) {
            throw new IllegalArgumentException("ptolemy.math.ComplexMatrixMath." + caller + "() : one matrix " + ComplexMatrixMath._dimensionString(matrix1) + " is not the same size as another matrix " + ComplexMatrixMath._dimensionString(matrix2) + ".");
        }
    }

    protected static final int _checkSquare(String caller, Complex[][] matrix) {
        if (ComplexMatrixMath._rows(matrix) != ComplexMatrixMath._columns(matrix)) {
            throw new IllegalArgumentException("ptolemy.math.ComplexMatrixMath." + caller + "() : matrix argument " + ComplexMatrixMath._dimensionString(matrix) + " is not a square matrix.");
        }
        return ComplexMatrixMath._rows(matrix);
    }

    protected static final int _columns(Complex[][] matrix) {
        return matrix[0].length;
    }

    protected static final String _dimensionString(Complex[][] matrix) {
        return "[" + ComplexMatrixMath._rows(matrix) + " x " + ComplexMatrixMath._columns(matrix) + "]";
    }

    protected static final Object[] _orthogonalizeRows(Complex[][] rowArrays) {
        int rows = rowArrays.length;
        int columns = rowArrays[0].length;
        int nullity = 0;
        Complex[][] orthogonalMatrix = new Complex[rows][];
        Complex[] oneOverNormSquaredArray = new Complex[rows];
        Complex[][] dotProductMatrix = new Complex[rows][rows];
        for (int i = 0; i < rows; ++i) {
            Complex Zero_Complex;
            Complex[] refArray;
            Complex[] rowArray = refArray = rowArrays[i];
            for (int j = 0; j < i; ++j) {
                Complex dotProduct;
                dotProductMatrix[j][i] = dotProduct = ComplexArrayMath.dotProduct(refArray, orthogonalMatrix[j]);
                rowArray = ComplexArrayMath.subtract(rowArray, ComplexArrayMath.scale(orthogonalMatrix[j], dotProduct.multiply(oneOverNormSquaredArray[j])));
            }
            dotProductMatrix[i][i] = ComplexArrayMath.dotProduct(refArray, rowArray);
            double normSqrd = ComplexArrayMath.l2normSquared(rowArray);
            Complex normSquared = new Complex(normSqrd, 0.0);
            if (normSquared == (Zero_Complex = new Complex(0.0, 0.0))) {
                orthogonalMatrix[i] = i == 0 ? new Complex[columns] : rowArray;
                oneOverNormSquaredArray[i] = Zero_Complex;
                ++nullity;
                continue;
            }
            orthogonalMatrix[i] = rowArray;
            Complex One_Complex = new Complex(1.0, 0.0);
            oneOverNormSquaredArray[i] = One_Complex.divide(normSquared);
        }
        return new Object[]{orthogonalMatrix, dotProductMatrix, oneOverNormSquaredArray, nullity};
    }

    protected static final int _rows(Complex[][] matrix) {
        return matrix.length;
    }

    protected static final Complex[][] _zeroMatrix(Complex[][] matrix, int rows, int columns) {
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                matrix[i][j] = Complex.ZERO;
            }
        }
        return matrix;
    }
}

