/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.media;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Audio {
    public byte[] magic = new byte[]{46, 115, 110, 100};
    public int offset;
    public int size;
    public int format;
    public int sampleRate;
    public int numChannels;
    public byte[] info;
    public byte[][] audio;
    private static boolean _zerotrap = false;
    private static final int BIAS = 132;
    private static final int CLIP = 32635;
    private static final byte[] exp_lut = new byte[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};

    public Audio(byte[] audio) {
        String ptinfo = "Ptolemy audio";
        this.info = ptinfo.getBytes();
        this.offset = 24 + this.info.length;
        this.size = audio.length;
        this.format = 1;
        this.sampleRate = 8000;
        this.numChannels = 1;
        this.audio = new byte[1][];
        this.audio[0] = audio;
    }

    public Audio(double[] audio) {
        String ptinfo = "Ptolemy audio";
        this.info = ptinfo.getBytes();
        this.offset = 24 + this.info.length;
        this.size = audio.length;
        this.format = 1;
        this.sampleRate = 8000;
        this.numChannels = 1;
        this.audio = new byte[1][this.size];
        for (int i = this.size - 1; i >= 0; --i) {
            this.audio[0][i] = Audio.lin2mu((int)(audio[i] * 31616.0));
        }
    }

    public Audio(DataInputStream input) throws IOException {
        int bytesRead = input.read(this.magic, 0, 4);
        if (bytesRead != 4) {
            throw new IOException("Read only " + bytesRead + " bytes, expecting " + 4);
        }
        if (this.magic[0] != 46 || this.magic[1] != 115 || this.magic[2] != 110 || this.magic[3] != 100) {
            throw new IllegalArgumentException("ptolemy.media.Audio: bad magic number in stream header.  Not an audio file?");
        }
        this.offset = input.readInt();
        this.size = input.readInt();
        this.format = input.readInt();
        this.sampleRate = input.readInt();
        this.numChannels = input.readInt();
        if (this.offset < 0 || this.offset > 10000) {
            throw new IllegalArgumentException("ptolemy.media.Audio: offset value '" + this.offset + "' is out of range 0-10000");
        }
        this.info = new byte[this.offset - 24];
        bytesRead = input.read(this.info, 0, this.offset - 24);
        if (bytesRead != this.offset - 24) {
            throw new IOException("Read only " + bytesRead + " bytes, expecting " + (this.offset - 24));
        }
        if (this.format != 1) {
            throw new IllegalArgumentException("ptolemy.media.Audio: Sorry, only 8-bit mu-law encoded data can be read, " + this.format + " formats seen, 1 expected.");
        }
        if (this.numChannels != 1) {
            throw new IllegalArgumentException("ptolemy.media.Audio: Sorry, only one-channel audio data can be read, " + this.numChannels + " channels seen, 1 expected.");
        }
        this.audio = new byte[1][this.size];
        input.readFully(this.audio[0]);
    }

    public static byte lin2mu(int sample) {
        int sign = 0;
        if (sample < 0) {
            sample = -sample;
            sign = 128;
        }
        if (sample > 32635) {
            sample = 32635;
        }
        byte exponent = exp_lut[(sample += 132) >> 7 & 0xFF];
        int mantissa = sample >> exponent + 3 & 0xF;
        int ulawbyte = sign | exponent << 4 | mantissa;
        ulawbyte ^= 0xFFFFFFFF;
        if (_zerotrap && (ulawbyte &= 0xFF) == 0) {
            ulawbyte = 2;
        }
        return (byte)ulawbyte;
    }

    public static int mu2lin(byte b) {
        int mu = b ^ 0xFF;
        int sign = (mu & 0x80) >> 7;
        int exponent = (mu & 0x70) >> 4;
        int mantissa = mu & 0xF;
        int linear = (mantissa << exponent + 1) - 32 + (32 << exponent);
        return sign == 1 ? -linear : (linear <<= 2);
    }

    public static double[] readAudio(DataInputStream input) throws IOException {
        Audio audio = new Audio(input);
        return audio.toDouble(0);
    }

    public static void setZeroTrap(boolean boole) {
        _zerotrap = boole;
    }

    public double[] toDouble(int channel) {
        int[] intdata = this.toLinear(channel);
        if (intdata != null) {
            double[] result = new double[intdata.length];
            for (int i = intdata.length - 1; i >= 0; --i) {
                result[i] = (double)intdata[i] / 31616.0;
            }
            return result;
        }
        return null;
    }

    public int[] toLinear(int channel) {
        if (this.audio != null && this.audio.length > channel && this.audio[channel] != null) {
            int[] result = new int[this.audio[channel].length];
            for (int i = this.audio[channel].length - 1; i >= 0; --i) {
                result[i] = Audio.mu2lin(this.audio[channel][i]);
            }
            return result;
        }
        return null;
    }

    public String toString() {
        return "file ID tag = " + new String(this.magic) + "\n" + "offset = " + this.offset + "\n" + "size = " + this.size + "\n" + "format code = " + this.format + "\n" + "sampleRate = " + this.sampleRate + "\n" + "number of channels = " + this.numChannels + "\n" + "info field = " + new String(this.info).trim();
    }

    public void write(DataOutputStream output) throws IOException {
        output.write(this.magic, 0, 4);
        output.writeInt(this.offset);
        output.writeInt(this.size);
        output.writeInt(this.format);
        output.writeInt(this.sampleRate);
        output.writeInt(this.numChannels);
        output.write(this.info, 0, this.offset - 24);
        output.write(this.audio[0], 0, this.size);
    }

    public void writeRaw(DataOutputStream output) throws IOException {
        output.write(this.audio[0], 0, this.size);
    }

    public static void writeAudio(double[] audio, DataOutputStream output) throws IOException {
        Audio obj = new Audio(audio);
        obj.write(output);
    }
}

