/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.media;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import ptolemy.media.Audio;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotApplication;
import sun.audio.AudioPlayer;

public class AudioViewer
extends PlotApplication {
    private DataInputStream _dataInputStream;
    private Audio _sound;
    private ByteArrayInputStream _instream;

    public AudioViewer() throws Exception {
        this((String[])null);
    }

    public AudioViewer(String[] args) throws Exception {
        super(args);
        JMenuItem play = new JMenuItem("Play", 80);
        play.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        play.setActionCommand("Play");
        PlayListener playlistener = new PlayListener();
        play.addActionListener(playlistener);
        this._specialMenu.add(play);
    }

    public void cleanup() {
        if (this._dataInputStream != null) {
            try {
                this._dataInputStream.close();
            }
            catch (Throwable throwable) {
                System.out.println("Ignoring failure to close stream on '" + this._dataInputStream + "'");
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        AudioViewer plot = null;
        try {
            plot = new AudioViewer(args);
            plot.setTitle("Ptolemy Audio Viewer");
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            ex.printStackTrace();
        }
        finally {
            if (plot != null) {
                plot.cleanup();
            }
        }
        if (_test) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    @Override
    protected void _about() {
        JOptionPane.showMessageDialog(this, "Ptolemy AudioViewer (ptaudio program)\nBy: Edward A. Lee\nVersion 2.0, Build: $Id: AudioViewer.java,v 1.43 2005/07/08 19:59:31 cxh Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot", "About Ptolemy AudioViewer", 1);
    }

    @Override
    protected void _help() {
        JOptionPane.showMessageDialog(this, "Use Control-P to play the sound", "Usage of Ptolemy AudioViewer", 1);
    }

    @Override
    protected void _read(URL base, InputStream in) throws IOException {
        try {
            this._dataInputStream = new DataInputStream(in);
            this._sound = new Audio(this._dataInputStream);
            Plot plt = (Plot)this.plot;
            plt.clear(true);
            plt.setXRange(0.0, (double)(this._sound.size - 1) / 8000.0);
            plt.setXLabel("Time in seconds");
            plt.setYRange(-1.0, 1.0);
            double[] pltdata = this._sound.toDouble(0);
            if (pltdata != null) {
                plt.addPoint(0, 0.0, pltdata[0], false);
                for (int i = 1; i < pltdata.length; ++i) {
                    plt.addPoint(0, (double)i / 8000.0, pltdata[i], true);
                }
            }
            plt.repaint();
        }
        catch (IOException ex) {
            this.cleanup();
            IOException newException = new IOException();
            newException.initCause(ex);
            throw newException;
        }
    }

    protected void _play() {
        if (this._instream == null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(this._sound.size);
            DataOutputStream dataOutputStream = null;
            try {
                dataOutputStream = new DataOutputStream(out);
                this._sound.writeRaw(dataOutputStream);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to convert audio data to stream.");
            }
            finally {
                if (dataOutputStream != null) {
                    try {
                        dataOutputStream.close();
                    }
                    catch (Throwable throwable) {
                        System.out.println("Ignoring failure to close stream on '" + dataOutputStream + "'");
                        throwable.printStackTrace();
                    }
                }
            }
            byte[] _iobuffer = out.toByteArray();
            this._instream = new ByteArrayInputStream(_iobuffer);
        }
        this._instream.reset();
        AudioPlayer.player.start((InputStream)this._instream);
    }

    @Override
    protected void _save() {
        if (this._file != null) {
            try {
                FileOutputStream fout = new FileOutputStream(this._file);
                this._sound.write(new DataOutputStream(fout));
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error writing file: " + ex, "AudioViewer error", 0);
            }
        } else {
            this._saveAs();
        }
    }

    @Override
    protected String _usage() {
        String result = "Usage: ptaudio file";
        return result;
    }

    private class PlayListener
    implements ActionListener {
        private PlayListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem target = (JMenuItem)e.getSource();
            String actionCommand = target.getActionCommand();
            if (actionCommand.equals("Play")) {
                AudioViewer.this._play();
            }
        }
    }
}

