/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml.filter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.moml.MoMLParser;
import ptolemy.moml.filter.BackwardCompatibility;
import ptolemy.moml.filter.NamedObjClassesSeen;
import ptolemy.moml.filter.RemoveGraphicalClasses;
import ptolemy.util.FileUtilities;
import ptolemy.util.StringUtilities;

public class ActorIndex {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateActorIndex(String classesFileName, String modelsFileName, String outputDirectory) throws Exception {
        HashMap classesToBeIndexed = new HashMap();
        BufferedReader classesReader = null;
        BufferedReader modelReader = null;
        try {
            String modelName;
            String className;
            classesReader = new BufferedReader(new FileReader(classesFileName));
            while ((className = classesReader.readLine()) != null) {
                System.out.println("Going to index " + className);
                classesToBeIndexed.put(className, new HashSet());
            }
            modelReader = new BufferedReader(new FileReader(modelsFileName));
            MoMLParser parser = new MoMLParser();
            MoMLParser.setMoMLFilters(BackwardCompatibility.allFilters());
            NamedObjClassesSeen namedObjClassesSeen = new NamedObjClassesSeen(classesToBeIndexed);
            MoMLParser.addMoMLFilter(namedObjClassesSeen);
            RemoveGraphicalClasses removeGraphicalClasses = new RemoveGraphicalClasses();
            removeGraphicalClasses.setRemoveGR(true);
            MoMLParser.addMoMLFilter(removeGraphicalClasses);
            while ((modelName = modelReader.readLine()) != null) {
                namedObjClassesSeen.reset(modelName);
                try {
                    URL modelURL = FileUtilities.nameToURL(modelName, null, null);
                    System.out.println("Parsing: " + modelURL);
                    parser.reset();
                    parser.parse(null, modelURL);
                }
                catch (Exception ex) {
                    System.err.println("Warning, failed to parse " + modelName);
                    ex.printStackTrace();
                }
            }
        }
        finally {
            if (classesReader != null) {
                try {
                    classesReader.close();
                }
                catch (Exception ex) {}
            }
            if (modelReader != null) {
                try {
                    modelReader.close();
                }
                catch (Exception ex) {}
            }
        }
        for (Map.Entry entry : classesToBeIndexed.entrySet()) {
            String actorClassName = (String)entry.getKey();
            if (((Set)entry.getValue()).size() == 0) continue;
            BufferedWriter writer = null;
            try {
                File outputDirectoryFile;
                String outputFileName = outputDirectory + File.separator + actorClassName.replace('.', File.separatorChar) + "Idx.htm";
                String canonicalOutputFileName = new File(outputFileName).getCanonicalPath().replace('\\', '/');
                String ptII = null;
                try {
                    ptII = new URI(StringUtilities.getProperty("ptolemy.ptII.dirAsURL")).normalize().getPath();
                    ptII = new File(ptII).getCanonicalPath().replace('\\', '/');
                }
                catch (URISyntaxException ex) {
                    throw new InternalErrorException(null, (Throwable)ex, "Failed to process PTII " + ptII);
                }
                if (ptII.length() == 0) {
                    throw new InternalErrorException("Failed to process ptolemy.ptII.dirAsURL property, ptII = null?");
                }
                String relativePath = "";
                if (canonicalOutputFileName.startsWith(ptII)) {
                    String relativeOutputFileName = StringUtilities.substitute(canonicalOutputFileName, ptII, "");
                    StringBuffer relativePathBuffer = new StringBuffer();
                    int index = 0;
                    while (relativeOutputFileName.indexOf(47, index) != -1) {
                        index = relativeOutputFileName.indexOf(47, index) + 1;
                        relativePathBuffer.append("../");
                    }
                    relativePath = relativePathBuffer.toString();
                    relativePath = relativePath.substring(0, relativePath.length() - 3);
                }
                if (!(outputDirectoryFile = new File(new File(outputFileName).getParent())).exists()) {
                    System.out.println("Creating " + outputDirectoryFile);
                    if (!outputDirectoryFile.mkdirs()) {
                        throw new IOException("Directory \"" + outputDirectoryFile + "\" does not exist and cannot be created.");
                    }
                }
                System.out.println("Writing " + outputFileName);
                writer = new BufferedWriter(new FileWriter(outputFileName));
                writer.write("<html>\n<head>\n<title>Index for " + actorClassName + "</title>\n" + "<link href=\"" + relativePath + "doc/default.css\"" + "rel=\"stylesheet\" type=\"text/css\">\n" + "</head>\n<body>\n" + "<h2>" + actorClassName + "</h2>\n" + "Below are demonstration models that use " + actorClassName + "\n<ul>\n");
                for (String model : (Set)entry.getValue()) {
                    if (model.startsWith("$CLASSPATH")) {
                        model = model.substring(11);
                    }
                    writer.write("<li><a href=\"" + relativePath + model + "\">" + model + "</a>\n");
                }
                writer.write("</ul>\n</body>\n</html>\n");
            }
            finally {
                if (writer == null) continue;
                writer.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ActorIndex.generateActorIndex(args[0], args[1], args[2]);
    }
}

