/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments;

import JSci.instruments.Image;
import JSci.instruments.ImageFilter;
import JSci.instruments.ImageSink;
import JSci.instruments.ImageSource;
import JSci.instruments.PTTemplateCross;
import JSci.instruments.ParticleTracker;
import JSci.instruments.ParticleTrackerListener;
import JSci.instruments.Player;
import JSci.instruments.TwoROI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class PTTemplate
implements ImageFilter,
ParticleTracker {
    private static long startTime = System.currentTimeMillis();
    private TwoROI theROI = null;
    private Image stillImage = null;
    private boolean catchImage = false;
    private JComboBox crossCombo = new JComboBox();
    private ImageSink sink;
    private ImageSource source = null;
    private ParticleTrackerListener ptl = null;
    JComponent comp;

    public PTTemplate(TwoROI twoROI) {
        this.theROI = twoROI;
    }

    public void setSink(ImageSink imageSink) {
        if (this.sink != imageSink) {
            this.sink = imageSink;
            this.sink.setSource(this);
        }
    }

    public void setSource(ImageSource imageSource) {
        if (this.source != imageSource) {
            this.source = imageSource;
            this.source.setSink(this);
        }
    }

    public int getWidth() {
        return this.source.getWidth();
    }

    public int getHeight() {
        return this.source.getHeight();
    }

    public Dimension getSize() {
        return this.source.getSize();
    }

    public String getName() {
        return "PT Template";
    }

    public void setListener(ParticleTrackerListener particleTrackerListener) {
        this.ptl = particleTrackerListener;
    }

    public String toString() {
        return "Particle Tracking - Template; startTime=" + startTime;
    }

    public void receive(Image image) {
        ComboBoxModel comboBoxModel = this.crossCombo.getModel();
        if (comboBoxModel.getSize() >= 0) {
            int[] nArray = new int[comboBoxModel.getSize()];
            double[] dArray = new double[comboBoxModel.getSize()];
            double[] dArray2 = new double[comboBoxModel.getSize()];
            for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                PTTemplateCross pTTemplateCross = (PTTemplateCross)comboBoxModel.getElementAt(i);
                pTTemplateCross.find(image);
                nArray[i] = pTTemplateCross.getN();
                dArray[i] = pTTemplateCross.getX();
                dArray2[i] = pTTemplateCross.getY();
            }
            if (this.ptl != null) {
                this.ptl.receivePosition(image.getTimeStamp() - startTime, nArray, dArray, dArray2, null);
            }
        }
        if (this.catchImage && this.stillImage == null) {
            this.stillImage = image;
        }
        if (this.sink != null) {
            if (this.stillImage != null) {
                this.sink.receive(this.stillImage);
            } else {
                this.sink.receive(image);
            }
        }
    }

    public Component getControlComponent() {
        if (this.comp != null) {
            return this.comp;
        }
        JPanel jPanel = new JPanel();
        final JButton jButton = new JButton("Add");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jButton.getText().equals("Add")) {
                    PTTemplate.this.stillImage = null;
                    PTTemplate.this.catchImage = true;
                    jButton.setText("Done");
                } else {
                    PTTemplate.this.catchImage = false;
                    jButton.setText("Add");
                    if (PTTemplate.this.stillImage != null) {
                        PTTemplateCross pTTemplateCross = new PTTemplateCross((Rectangle)PTTemplate.this.theROI.getShape(), PTTemplate.this.theROI.getOuterRectangle(), PTTemplate.this.stillImage.getSubImage((Rectangle)PTTemplate.this.theROI.getShape()));
                        PTTemplate.this.crossCombo.addItem(pTTemplateCross);
                    }
                    PTTemplate.this.stillImage = null;
                }
            }
        });
        JButton jButton2 = new JButton("Remove");
        jPanel.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PTTemplate.this.crossCombo.removeItem(PTTemplate.this.crossCombo.getSelectedItem());
            }
        });
        this.crossCombo.setEditable(false);
        jPanel.add(this.crossCombo);
        jPanel.add(this.theROI.getControlComponent());
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.getName());
        jPanel.setBorder(titledBorder);
        return jPanel;
    }

    public static void main(String[] stringArray) {
        TwoROI twoROI = new TwoROI();
        PTTemplate pTTemplate = new PTTemplate(twoROI);
        Player player = new Player();
        SimulatedBarycentreSource simulatedBarycentreSource = new SimulatedBarycentreSource();
        simulatedBarycentreSource.setSink(pTTemplate);
        pTTemplate.setSink(player);
        player.addROI(twoROI);
        player.start();
        final NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setMinimumFractionDigits(1);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumIntegerDigits(4);
        ParticleTrackerListener particleTrackerListener = new ParticleTrackerListener(){

            public void receivePosition(long l, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3) {
                System.out.print(l);
                for (int i = 0; i < nArray.length; ++i) {
                    System.out.print(" " + nArray[i] + " " + numberFormat.format(dArray[i]) + " " + numberFormat.format(dArray2[i]));
                }
                System.out.println();
            }
        };
        pTTemplate.setListener(particleTrackerListener);
    }

    static class SimulatedBarycentreSource
    implements ImageSource,
    Runnable {
        Dimension dim = new Dimension(130, 97);
        private ImageSink sink;
        private static final double SIGMA = 4.0;
        private static final double DELTAX = 4.0;
        private static final double DELTAY = 2.0;

        public SimulatedBarycentreSource() {
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.start();
        }

        public void setSink(ImageSink imageSink) {
            if (this.sink != imageSink) {
                this.sink = imageSink;
                this.sink.setSource(this);
            }
        }

        private double f(double d, double d2) {
            return Math.exp(-(d * d + d2 * d2) / 32.0) - Math.exp(-((d - 4.0) * (d - 4.0) + (d2 - 2.0) * (d2 - 2.0)) / 32.0);
        }

        public void run() {
            int n = 0;
            while (true) {
                int n2 = n++;
                final long l = System.currentTimeMillis();
                double d = Math.random() * 4.0 + 40.0;
                double d2 = Math.random() * 4.0 + 50.0;
                final byte[] byArray = new byte[this.getWidth() * this.getHeight()];
                final Dimension dimension = new Dimension(this.getWidth(), this.getHeight());
                Image image = new Image(){

                    public byte[] getData() {
                        return byArray;
                    }

                    public Dimension getSize() {
                        return dimension;
                    }

                    public long getTimeStamp() {
                        return l;
                    }
                };
                for (int i = 0; i < image.getWidth(); ++i) {
                    for (int j = 0; j < image.getHeight(); ++j) {
                        image.getData()[i + j * image.getWidth()] = (byte)(128.0 + 128.0 * this.f((double)i - d, (double)j - d2));
                    }
                }
                if (this.sink != null) {
                    this.sink.receive(image);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        public int getWidth() {
            return this.dim.width;
        }

        public int getHeight() {
            return this.dim.height;
        }

        public Dimension getSize() {
            return this.dim;
        }

        public Component getControlComponent() {
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("Test"));
            Border border = BorderFactory.createEtchedBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "source");
            jPanel.setBorder(titledBorder);
            return jPanel;
        }
    }
}

