/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import ptolemy.util.ClassUtilities;
import ptolemy.util.StringUtilities;

public class FileUtilities {
    public static BufferedReader STD_IN = null;
    public static PrintWriter STD_OUT = null;
    private static String _CLASSPATH_VALUE = "xxxxxxCLASSPATHxxxxxx";

    private FileUtilities() {
    }

    public static boolean binaryCopyURLToFile(URL sourceURL, File destinationFile) throws IOException {
        URL destinationURL = destinationFile.getCanonicalFile().toURI().toURL();
        if (sourceURL.sameFile(destinationURL)) {
            return false;
        }
        File sourceFile = new File(sourceURL.getFile());
        if (sourceFile.getPath().indexOf("!/") == -1 && sourceFile.getPath().indexOf("!\\") == -1) {
            try {
                if (sourceFile.getCanonicalFile().toURI().toURL().sameFile(destinationURL)) {
                    return false;
                }
            }
            catch (IOException ex) {
                IOException ioException = new IOException("Cannot find canonical file name of '" + sourceFile + "'");
                ioException.initCause(ex);
                throw ioException;
            }
        }
        FileUtilities._binaryCopyStream(sourceURL.openStream(), destinationFile);
        return true;
    }

    public static void extractJarFile(String jarFileName, String directoryName) throws IOException {
        JarFile jarFile = new JarFile(jarFileName);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            File destinationFile = new File(directoryName, jarEntry.getName());
            if (jarEntry.isDirectory()) {
                if (destinationFile.isDirectory() || destinationFile.mkdirs()) continue;
                throw new IOException("Warning, failed to create directory for \"" + destinationFile + "\".");
            }
            FileUtilities._binaryCopyStream(jarFile.getInputStream(jarEntry), destinationFile);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.err.println("Usage: java -classpath $PTII ptolemy.util.FileUtilities jarFile [directory]\nwhere jarFile is the name of the jar file\nand directory is the optional directory in which to extract.");
            StringUtilities.exit(2);
        }
        String jarFileName = args[0];
        String directoryName = null;
        if (args.length >= 2) {
            directoryName = args[1];
        }
        try {
            FileUtilities.extractJarFile(jarFileName, directoryName);
        }
        catch (Throwable throwable) {
            System.err.println("Failed to extract \"" + jarFileName + "\"");
            throwable.printStackTrace();
            StringUtilities.exit(3);
        }
    }

    public static File nameToFile(String name, URI base) {
        if (name == null || name.trim().equals("")) {
            return null;
        }
        File file = new File(name);
        if (!file.isAbsolute() && base != null) {
            URI newURI = base.resolve(name);
            String urlString = newURI.getPath();
            file = new File(StringUtilities.substitute(urlString, "%20", " "));
        }
        return file;
    }

    public static URL nameToURL(String name, URI baseDirectory, ClassLoader classLoader) throws IOException {
        if (name == null || name.trim().equals("")) {
            return null;
        }
        if (name.startsWith(_CLASSPATH_VALUE) || name.startsWith("$CLASSPATH")) {
            URL result;
            String classpathKey = name.startsWith(_CLASSPATH_VALUE) ? _CLASSPATH_VALUE : "$CLASSPATH";
            String trimmedName = name.substring(classpathKey.length() + 1);
            if (classLoader == null) {
                String referenceClassName = "ptolemy.util.FileUtilities";
                try {
                    Class<?> referenceClass = Class.forName(referenceClassName);
                    classLoader = referenceClass.getClassLoader();
                }
                catch (Exception ex) {
                    IOException ioException = new IOException("Cannot look up class \"" + referenceClassName + "\" or get its ClassLoader.");
                    ioException.initCause(ex);
                    throw ioException;
                }
            }
            if ((result = classLoader.getResource(trimmedName)) == null) {
                throw new IOException("Cannot find file '" + trimmedName + "' in classpath");
            }
            return result;
        }
        File file = new File(name);
        if (file.isAbsolute()) {
            if (!file.canRead()) {
                file = new File(StringUtilities.substitute(name, "%20", " "));
                URL possibleJarURL = null;
                if (!file.canRead() && (possibleJarURL = ClassUtilities.jarURLEntryResource((String)name)) != null) {
                    file = new File(possibleJarURL.getFile());
                }
                if (!file.canRead()) {
                    throw new IOException("Cannot read file '" + name + "' or '" + StringUtilities.substitute(name, "%20", " ") + "'" + (possibleJarURL == null ? "" : " or '" + possibleJarURL.getFile() + ""));
                }
            }
            return file.toURI().toURL();
        }
        if (baseDirectory != null) {
            URI newURI;
            try {
                newURI = baseDirectory.resolve(name);
            }
            catch (Exception ex) {
                String name2 = StringUtilities.substitute(name, "%20", " ");
                try {
                    newURI = baseDirectory.resolve(name2);
                    name = name2;
                }
                catch (Exception ex2) {
                    IOException io = new IOException("Problem with URI format in '" + name + "'. " + "and '" + name2 + "' " + "This can happen if the file name " + "is not absolute" + "and is not present relative to the " + "directory in which the specified model " + "was read (which was '" + baseDirectory + "')");
                    io.initCause(ex2);
                    throw io;
                }
            }
            String urlString = newURI.toString();
            try {
                if (newURI.getScheme() != null && newURI.getAuthority() == null) {
                    urlString = urlString.substring(0, 6) + "//" + urlString.substring(6);
                }
                return new URL(urlString);
            }
            catch (Exception ex3) {
                try {
                    return new URL(baseDirectory.toURL(), urlString);
                }
                catch (Exception ex4) {
                    try {
                        return new URL(baseDirectory.toURL(), newURI.toString());
                    }
                    catch (Exception ex5) {
                        IOException io = new IOException("Problem with URI format in '" + urlString + "'. " + "This can happen if the '" + urlString + "' is not absolute" + " and is not present relative to the directory" + " in which the specified model was read" + " (which was '" + baseDirectory + "')");
                        io.initCause(ex3);
                        throw io;
                    }
                }
            }
        }
        URL url = new URL(name);
        try {
            String fixedURLAsString = url.toString().replaceFirst("(https?:)//?", "$1//");
            url = new URL(fixedURLAsString);
        }
        catch (Exception e) {
            // empty catch block
        }
        return url;
    }

    public static BufferedReader openForReading(String name, URI base, ClassLoader classLoader) throws IOException {
        if (name == null || name.trim().equals("")) {
            return null;
        }
        if (name.trim().equals("System.in")) {
            if (STD_IN == null) {
                STD_IN = new BufferedReader(new InputStreamReader(System.in));
            }
            return STD_IN;
        }
        URL url = FileUtilities.nameToURL(name, base, classLoader);
        if (url == null) {
            throw new IOException("Could not convert \"" + name + "\" with base \"" + base + "\" to a URL.");
        }
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(url.openStream());
        }
        catch (IOException ex) {
            try {
                URL possibleJarURL = ClassUtilities.jarURLEntryResource((String)url.toString());
                if (possibleJarURL != null) {
                    inputStreamReader = new InputStreamReader(possibleJarURL.openStream());
                }
                return new BufferedReader(inputStreamReader);
            }
            catch (Exception ex2) {
                try {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (IOException ex3) {
                    // empty catch block
                }
                IOException ioException = new IOException("Failed to open \"" + url + "\".");
                ioException.initCause(ex);
                throw ioException;
            }
        }
        return new BufferedReader(inputStreamReader);
    }

    public static Writer openForWriting(String name, URI base, boolean append) throws IOException {
        if (name == null || name.trim().equals("")) {
            return null;
        }
        if (name.trim().equals("System.out")) {
            if (STD_OUT == null) {
                STD_OUT = new PrintWriter(System.out);
            }
            return STD_OUT;
        }
        File file = FileUtilities.nameToFile(name, base);
        return new FileWriter(file, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _binaryCopyStream(InputStream inputStream, File destinationFile) throws IOException {
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(inputStream);
            FilterOutputStream output = null;
            try {
                int c;
                File parent = destinationFile.getParentFile();
                if (parent != null && !parent.exists() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directories for \"" + parent + "\".");
                }
                output = new BufferedOutputStream(new FileOutputStream(destinationFile));
                while ((c = input.read()) != -1) {
                    ((BufferedOutputStream)output).write(c);
                }
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                }
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
    }
}

