/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies2;

import JSci.maths.wavelet.FWT;

public final class FastDaubechies2
extends FWT {
    private static final float root3 = (float)Math.sqrt(3.0);
    private static final float normalizer = (float)Math.pow(2.0, -0.5);
    static final float[] scale = new float[]{(1.0f + root3) * normalizer / 4.0f, (3.0f + root3) * normalizer / 4.0f, (3.0f + -1.0f * root3) * normalizer / 4.0f, (1.0f + -1.0f * root3) * normalizer / 4.0f};
    static final float[] wavelet = new float[]{-(1.0f + -1.0f * root3) * normalizer / 4.0f, (3.0f + -1.0f * root3) * normalizer / 4.0f, -(3.0f + root3) * normalizer / 4.0f, (1.0f + root3) * normalizer / 4.0f};

    public static void transform(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        int n2 = n / 2;
        try {
            int n3 = 0;
            while (true) {
                fArray2[n3 + n2] = fArray[2 * n3 + 0] * wavelet[0] + fArray[2 * n3 + 1] * wavelet[1] + fArray[2 * n3 + 2] * wavelet[2] + fArray[2 * n3 + 3] * wavelet[3];
                fArray2[n3] = fArray[2 * n3 + 0] * scale[0] + fArray[2 * n3 + 1] * scale[1] + fArray[2 * n3 + 2] * scale[2] + fArray[2 * n3 + 3] * scale[3];
                ++n3;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            fArray2[n - 1] = fArray[n - 2] * wavelet[0] + fArray[n - 1] * wavelet[1] + fArray[0] * wavelet[2] + fArray[1] * wavelet[3];
            fArray2[n2 - 1] = fArray[n - 2] * scale[0] + fArray[n - 1] * scale[1] + fArray[0] * scale[2] + fArray[1] * scale[3];
            System.arraycopy(fArray2, 0, fArray, 0, n);
            return;
        }
    }

    public void transform(float[] fArray) {
        int n;
        for (n = fArray.length; n > 4; n /= 2) {
            FastDaubechies2.transform(fArray, n);
        }
        if (n != 4) {
            System.err.println("Careful! this should be a power of 2 : " + fArray.length);
        }
    }

    public void invTransform(float[] fArray) {
        int n = 4;
        while (2 * n <= fArray.length) {
            FastDaubechies2.invTransform(fArray, n);
            n *= 2;
        }
        if (n != fArray.length) {
            System.err.println("Careful! this should be a power of 2 : " + fArray.length);
        }
    }

    public static void invTransform(float[] fArray, int n) {
        int n2 = 2 * n;
        float[] fArray2 = new float[n2];
        try {
            int n3 = 0;
            while (true) {
                int n4 = 2 * n3 + 3;
                fArray2[n4] = fArray2[n4] + (scale[3] * fArray[n3] + wavelet[3] * fArray[n3 + n]);
                int n5 = 2 * n3 + 2;
                fArray2[n5] = fArray2[n5] + (scale[2] * fArray[n3] + wavelet[2] * fArray[n3 + n]);
                int n6 = 2 * n3 + 1;
                fArray2[n6] = fArray2[n6] + (scale[1] * fArray[n3] + wavelet[1] * fArray[n3 + n]);
                int n7 = 2 * n3 + 0;
                fArray2[n7] = fArray2[n7] + (scale[0] * fArray[n3] + wavelet[0] * fArray[n3 + n]);
                ++n3;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            int n8 = n2 - 2;
            fArray2[n8] = fArray2[n8] + (scale[0] * fArray[n - 1] + wavelet[0] * fArray[n2 - 1]);
            int n9 = n2 - 1;
            fArray2[n9] = fArray2[n9] + (scale[1] * fArray[n - 1] + wavelet[1] * fArray[n2 - 1]);
            fArray2[0] = fArray2[0] + (scale[2] * fArray[n - 1] + wavelet[2] * fArray[n2 - 1]);
            fArray2[1] = fArray2[1] + (scale[3] * fArray[n - 1] + wavelet[3] * fArray[n2 - 1]);
            System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
            return;
        }
    }
}

